/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.vector.VectorCollectionService;
import com.hazelcast.vector.impl.storage.ReplicationStateHolder;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.io.IOException;
import java.util.Map;

public class ReplicationOperation
extends Operation
implements IdentifiedDataSerializable {
    private ReplicationStateHolder replicationStateHolder;

    public ReplicationOperation() {
    }

    public ReplicationOperation(NodeEngine nodeEngine, Map<String, VectorCollectionStorage> storageMap, int partitionId, int replicaIndex) {
        this.replicationStateHolder = new ReplicationStateHolder(storageMap);
        this.setNodeEngine(nodeEngine);
        this.setPartitionId(partitionId);
        this.setReplicaIndex(replicaIndex);
    }

    @Override
    public void run() {
        VectorCollectionService service = (VectorCollectionService)this.getService();
        this.replicationStateHolder.apply(service, this.getPartitionId());
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 26;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.replicationStateHolder);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.replicationStateHolder = (ReplicationStateHolder)in.readObject();
    }

    @Override
    public String getServiceName() {
        return "hz:service:vector";
    }

    public ReplicationStateHolder getReplicationStateHolder() {
        return this.replicationStateHolder;
    }
}

