/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.vector.impl.ops.PutAllOperation;
import com.hazelcast.vector.impl.ops.VectorEntries;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;

public class PutAllOperationFactory
extends PartitionAwareOperationFactory {
    protected String name;
    protected VectorEntries[] vectorEntries;

    public PutAllOperationFactory() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PutAllOperationFactory(String name, int[] partitions, VectorEntries[] vectorEntries) {
        this.name = name;
        this.partitions = partitions;
        this.vectorEntries = vectorEntries;
    }

    @Override
    public Operation createPartitionOperation(int partitionId) {
        for (int i = 0; i < this.partitions.length; ++i) {
            if (this.partitions[i] != partitionId) continue;
            return new PutAllOperation(this.name, this.vectorEntries[i]);
        }
        throw new IllegalArgumentException("Unknown partitionId " + partitionId + " (" + Arrays.toString(this.partitions) + ")");
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeIntArray(this.partitions);
        for (VectorEntries entry : this.vectorEntries) {
            out.writeObject(entry);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.partitions = in.readIntArray();
        this.vectorEntries = new VectorEntries[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            this.vectorEntries[i] = (VectorEntries)in.readObject();
        }
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 19;
    }
}

