/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.vector.VectorCollectionService;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.io.IOException;

public class GetOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable,
ReadonlyOperation {
    private Data key;
    private transient VectorDocument<Data> result;

    public GetOperation() {
    }

    public GetOperation(String vectorCollectionName, Data key) {
        super(vectorCollectionName);
        this.key = key;
    }

    @Override
    public void run() throws Exception {
        VectorCollectionService service = (VectorCollectionService)this.getService();
        VectorCollectionStorage storage = service.getStorageOrNull(this.getName(), this.getPartitionId());
        if (storage != null) {
            this.result = storage.get(this.key);
        }
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public String getServiceName() {
        return "hz:service:vector";
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.key);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.key = IOUtil.readData(in);
    }
}

