/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.InternalSearchResult;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataSearchResult
implements InternalSearchResult<Data, Data>,
IdentifiedDataSerializable {
    private Data key;
    private float score;
    private int id;
    @Nullable
    private Data value;
    @Nullable
    private VectorValues vectors;

    public DataSearchResult() {
    }

    public DataSearchResult(int id, Data key, float score) {
        this.id = id;
        this.key = key;
        this.score = score;
    }

    public DataSearchResult(Data key, Data value, float score, VectorValues vectors) {
        this.id = -1;
        this.key = key;
        this.score = score;
        this.value = value;
        this.vectors = vectors;
    }

    public DataSearchResult setValue(Data value) {
        this.value = value;
        return this;
    }

    public DataSearchResult setVectors(VectorValues vectors) {
        this.vectors = vectors;
        return this;
    }

    @Override
    @Nonnull
    public Data getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public Data getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public VectorValues getVectors() {
        return this.vectors;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        IOUtil.writeData(out, this.key);
        out.writeFloat(this.score);
        IOUtil.writeData(out, this.value);
        out.writeObject(this.vectors);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = IOUtil.readData(in);
        this.score = in.readFloat();
        this.value = IOUtil.readData(in);
        this.vectors = (VectorValues)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    public String toString() {
        return "DataSearchResult{key=" + String.valueOf(this.key) + ", score=" + this.score + ", value=" + String.valueOf(this.value) + ", vectors=" + String.valueOf(this.vectors) + "}";
    }

    @Override
    public int id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSearchResult that = (DataSearchResult)o;
        return Float.compare(this.score, that.score) == 0 && this.id == that.id && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.vectors, that.vectors);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

