/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.server.ServerConnectionManager;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandler;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.Response;
import java.nio.ByteOrder;
import java.util.concurrent.ThreadLocalRandom;

public final class OutboundResponseHandler
implements OperationResponseHandler {
    private final Address thisAddress;
    private final InternalSerializationService serializationService;
    private final boolean useBigEndian;
    private final ILogger logger;

    OutboundResponseHandler(Address thisAddress, InternalSerializationService serializationService, ILogger logger) {
        this.thisAddress = thisAddress;
        this.serializationService = serializationService;
        this.useBigEndian = serializationService.getByteOrder() == ByteOrder.BIG_ENDIAN;
        this.logger = logger;
    }

    public void sendResponse(Operation operation, Object obj) {
        boolean send;
        Address target = operation.getCallerAddress();
        ServerConnectionManager connectionManager = operation.getConnection().getConnectionManager();
        if (obj == null) {
            send = this.sendNormalResponse(connectionManager, target, operation.getCallId(), 0, operation.isUrgent(), null);
        } else if (obj.getClass() == NormalResponse.class) {
            NormalResponse response = (NormalResponse)obj;
            send = this.sendNormalResponse(connectionManager, target, response.getCallId(), response.getBackupAcks(), response.isUrgent(), response.getValue());
        } else if (obj.getClass() == ErrorResponse.class || obj.getClass() == CallTimeoutResponse.class) {
            send = this.send(connectionManager, target, (Response)obj);
        } else if (obj instanceof Throwable) {
            Throwable throwable = (Throwable)obj;
            send = this.send(connectionManager, target, new ErrorResponse(throwable, operation.getCallId(), operation.isUrgent()));
        } else {
            send = this.sendNormalResponse(connectionManager, target, operation.getCallId(), 0, operation.isUrgent(), obj);
        }
        if (!send) {
            this.logger.warning("Cannot send response: " + String.valueOf(obj) + " to " + String.valueOf(target) + ". " + String.valueOf(operation));
        }
    }

    public boolean send(ServerConnectionManager connectionManager, Address target, Response response) {
        Preconditions.checkNotNull(target, "Target is required!");
        if (this.thisAddress.equals(target)) {
            throw new IllegalArgumentException("Target is this node! -> " + String.valueOf(target) + ", response: " + String.valueOf(response));
        }
        byte[] bytes = this.serializationService.toBytes(response);
        Packet packet = this.newResponsePacket(bytes, response.isUrgent());
        return this.transmit(target, packet, connectionManager);
    }

    private boolean sendNormalResponse(ServerConnectionManager connectionManager, Address target, long callId, int backupAcks, boolean urgent, Object value) {
        this.checkTarget(target);
        Packet packet = this.toNormalResponsePacket(callId, (byte)backupAcks, urgent, value);
        return this.transmit(target, packet, connectionManager);
    }

    Packet toNormalResponsePacket(long callId, int backupAcks, boolean urgent, Object value) {
        byte[] bytes;
        boolean isData = value instanceof Data;
        if (isData) {
            Data data = (Data)value;
            int dataLengthInBytes = data.totalSize();
            bytes = new byte[32 + dataLengthInBytes];
            Bits.writeInt(bytes, 28, dataLengthInBytes, this.useBigEndian);
            data.copyTo(bytes, 32);
        } else if (value == null) {
            bytes = new byte[32];
            Bits.writeInt(bytes, 28, 0, this.useBigEndian);
        } else {
            bytes = this.serializationService.toBytes(value, 28, false);
        }
        this.writeResponsePrologueBytes(bytes, 0, callId, urgent);
        bytes[26] = (byte)backupAcks;
        bytes[27] = (byte)(isData ? 1 : 0);
        return this.newResponsePacket(bytes, urgent);
    }

    public void sendBackupAck(ServerConnectionManager connectionManager, Address target, long callId, boolean urgent) {
        this.checkTarget(target);
        Packet packet = this.toBackupAckPacket(callId, urgent);
        this.transmit(target, packet, connectionManager);
    }

    Packet toBackupAckPacket(long callId, boolean urgent) {
        byte[] bytes = new byte[26];
        this.writeResponsePrologueBytes(bytes, 2, callId, urgent);
        return this.newResponsePacket(bytes, urgent);
    }

    private void writeResponsePrologueBytes(byte[] bytes, int typeId, long callId, boolean urgent) {
        Bits.writeIntB(bytes, 0, 0);
        Bits.writeIntB(bytes, 4, -2);
        bytes[8] = 1;
        Bits.writeInt(bytes, 9, SpiDataSerializerHook.F_ID, this.useBigEndian);
        Bits.writeInt(bytes, 13, typeId, this.useBigEndian);
        Bits.writeLong(bytes, 17, callId, this.useBigEndian);
        bytes[25] = (byte)(urgent ? 1 : 0);
    }

    private Packet newResponsePacket(byte[] bytes, boolean urgent) {
        Packet packet = new Packet(bytes, -1).setPacketType(Packet.Type.OPERATION).raiseFlags(2);
        if (urgent) {
            packet.raiseFlags(16);
        }
        return packet;
    }

    private boolean transmit(Address target, Packet packet, ServerConnectionManager connectionManager) {
        return connectionManager.transmit(packet, target, ThreadLocalRandom.current().nextInt());
    }

    private void checkTarget(Address target) {
        Preconditions.checkNotNull(target, "Target is required!");
        if (this.thisAddress.equals(target)) {
            throw new IllegalArgumentException("Target is this node! -> " + String.valueOf(target));
        }
    }
}

