/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.IndeterminateOperationStateException;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.InvocationConstant;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class BaseInvocation {
    private static final AtomicIntegerFieldUpdater<BaseInvocation> BACKUP_ACKS_RECEIVED = AtomicIntegerFieldUpdater.newUpdater(BaseInvocation.class, "backupsAcksReceived");
    protected final ILogger logger;
    protected volatile int backupsAcksReceived;
    volatile int backupsAcksExpected = -1;
    volatile long pendingResponseReceivedMillis = -1L;
    volatile Object pendingResponse = InvocationConstant.VOID;

    protected BaseInvocation(ILogger logger) {
        this.logger = logger;
    }

    public void notifyBackupComplete() {
        int newBackupAcksCompleted = BACKUP_ACKS_RECEIVED.incrementAndGet(this);
        Object pendingResponse = this.pendingResponse;
        if (pendingResponse == InvocationConstant.VOID) {
            return;
        }
        int backupAcksExpected = this.backupsAcksExpected;
        if (backupAcksExpected != newBackupAcksCompleted) {
            return;
        }
        this.completeWithPendingResponse();
    }

    protected void notifyResponse(Object response, int expectedBackups) {
        if (expectedBackups > this.backupsAcksReceived) {
            this.pendingResponseReceivedMillis = Clock.currentTimeMillis();
            this.backupsAcksExpected = expectedBackups;
            this.pendingResponse = response;
            if (this.backupsAcksReceived != expectedBackups) {
                return;
            }
        }
        this.complete(response);
    }

    public boolean detectAndHandleBackupTimeout(long timeoutMillis) {
        boolean timeoutReached;
        if (this.backupsAcksExpected == this.backupsAcksReceived) {
            return false;
        }
        if (this.pendingResponse == InvocationConstant.VOID) {
            return false;
        }
        long expirationTime = this.pendingResponseReceivedMillis + timeoutMillis;
        boolean bl = timeoutReached = expirationTime > 0L && expirationTime < Clock.currentTimeMillis();
        if (!timeoutReached) {
            return false;
        }
        if (this.shouldFailOnIndeterminateOperationState()) {
            this.completeExceptionally(new IndeterminateOperationStateException(String.valueOf(this) + " failed because backup acks missed."));
            return true;
        }
        if (this.shouldCompleteWithoutBackups()) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Invocation " + String.valueOf(this) + " will be completed without backup acks.");
            }
            this.completeWithPendingResponse();
            return true;
        }
        return false;
    }

    private void completeWithPendingResponse() {
        Object object = this.pendingResponse;
        if (object instanceof AbstractInvocationFuture.ExceptionalResult) {
            AbstractInvocationFuture.ExceptionalResult result = (AbstractInvocationFuture.ExceptionalResult)object;
            this.completeExceptionally(result.getCause());
        } else {
            this.complete(this.pendingResponse);
        }
    }

    protected abstract boolean shouldCompleteWithoutBackups();

    protected abstract void complete(Object var1);

    protected abstract void completeExceptionally(Throwable var1);

    protected abstract boolean shouldFailOnIndeterminateOperationState();
}

