/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.util;

import com.hazelcast.shaded.io.github.jbellis.jvector.util.Constants;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.RamUsageEstimator;
import java.lang.reflect.Array;

public final class ArrayUtil {
    public static final int MAX_ARRAY_LENGTH = Integer.MAX_VALUE - RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;

    private ArrayUtil() {
    }

    public static int parseInt(char[] chars, int offset, int len, int radix) throws NumberFormatException {
        boolean negative;
        if (chars == null || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        int i = 0;
        if (len == 0) {
            throw new NumberFormatException("chars length is 0");
        }
        boolean bl = negative = chars[offset + i] == '-';
        if (negative && ++i == len) {
            throw new NumberFormatException("can't convert to an int");
        }
        if (negative) {
            ++offset;
            --len;
        }
        return ArrayUtil.parse(chars, offset, len, radix, negative);
    }

    private static int parse(char[] chars, int offset, int len, int radix, boolean negative) throws NumberFormatException {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        for (int i = 0; i < len; ++i) {
            int digit = Character.digit(chars[i + offset], radix);
            if (digit == -1) {
                throw new NumberFormatException("Unable to parse");
            }
            if (max > result) {
                throw new NumberFormatException("Unable to parse");
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException("Unable to parse");
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException("Unable to parse");
        }
        return result;
    }

    public static int oversize(int minTargetSize, int bytesPerElement) {
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        if (minTargetSize > MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("requested array size " + minTargetSize + " exceeds maximum array in java (" + MAX_ARRAY_LENGTH + ")");
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + extra) + 7 < 0 || newSize + 7 > MAX_ARRAY_LENGTH) {
            return MAX_ARRAY_LENGTH;
        }
        if (Constants.JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 1: {
                return (newSize + 3 & 0x7FFFFFF8) + 4;
            }
            case 2: {
                return (newSize + 1 & 0x7FFFFFFC) + 2;
            }
            case 4: {
                return (newSize & 0x7FFFFFFE) + 1;
            }
        }
        return newSize;
    }

    public static <T> T[] growExact(T[] array, int newLength) {
        Class<?> type = array.getClass();
        Object[] copy = type == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(type.getComponentType(), newLength);
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static <T> T[] grow(T[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            int newLength = ArrayUtil.oversize(minSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            return ArrayUtil.growExact(array, newLength);
        }
        return array;
    }

    public static short[] growExact(short[] array, int newLength) {
        short[] copy = new short[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static short[] grow(short[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 2));
        }
        return array;
    }

    public static float[] growExact(float[] array, int newLength) {
        float[] copy = new float[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static float[] grow(float[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            float[] copy = new float[ArrayUtil.oversize(minSize, 4)];
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return array;
    }

    public static double[] growExact(double[] array, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static double[] grow(double[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 8));
        }
        return array;
    }

    public static int[] growExact(int[] array, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static int[] grow(int[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 4));
        }
        return array;
    }

    public static int[] grow(int[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static long[] growExact(long[] array, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static long[] grow(long[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 8));
        }
        return array;
    }

    public static byte[] growExact(byte[] array, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static byte[] grow(byte[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 1));
        }
        return array;
    }

    public static char[] growExact(char[] array, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static char[] grow(char[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 2));
        }
        return array;
    }

    public static byte[] copyOfSubArray(byte[] array, int from, int to) {
        byte[] copy = new byte[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static int[] copyOfSubArray(int[] array, int from, int to) {
        int[] copy = new int[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static float[] copyOfSubArray(float[] array, int from, int to) {
        float[] copy = new float[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static <T> T[] copyOfSubArray(T[] array, int from, int to) {
        int subLength = to - from;
        Class<?> type = array.getClass();
        Object[] copy = type == Object[].class ? new Object[subLength] : (Object[])Array.newInstance(type.getComponentType(), subLength);
        System.arraycopy(array, from, copy, 0, subLength);
        return copy;
    }

    public static long[] copyOfSubArray(long[] array, int from, int to) {
        long[] copy = new long[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }
}

