/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.graph.ConcurrentNeighborSet;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.GraphIndex;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodesIterator;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.Bits;
import java.util.NoSuchElementException;

public class HazelcastGraphIndexView
implements GraphIndex.View<float[]> {
    private static final NodesIterator EMPTY_ITERATOR = new NodesIterator(0){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }
    };
    private final OnHeapGraphIndex<float[]> index;

    private HazelcastGraphIndexView(OnHeapGraphIndex<float[]> index) {
        this.index = index;
    }

    public static HazelcastGraphIndexView create(OnHeapGraphIndex<float[]> index) {
        return new HazelcastGraphIndexView(index);
    }

    @Override
    public float[] getVector(int node) {
        throw new UnsupportedOperationException("All searches done with OnHeapGraphIndex should be exact");
    }

    @Override
    public NodesIterator getNeighborsIterator(int node) {
        ConcurrentNeighborSet neighbors = this.index.getNeighbors(node);
        if (neighbors == null) {
            return EMPTY_ITERATOR;
        }
        return neighbors.iterator();
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public int entryNode() {
        return this.index.entry();
    }

    public String toString() {
        return "HazelcastGraphIndexView(size=" + this.size() + ", entryPoint=" + this.index.entry();
    }

    @Override
    public Bits liveNodes() {
        return this.index.getDeletedNodes().cardinality() == 0 ? Bits.ALL : Bits.inverseOf(this.index.getDeletedNodes());
    }

    @Override
    public int getIdUpperBound() {
        return this.index.getIdUpperBound();
    }

    @Override
    public void close() {
    }
}

