/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.JSON;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.api.ReaderWriterModifier;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.api.ReaderWriterProvider;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.api.ValueReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.AnyReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.ArrayReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.BeanConstructors;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.BeanPropertyIntrospector;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.BeanPropertyReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.BeanReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.ClassKey;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.CollectionReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.EnumReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.MapReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.POJODefinition;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.RecordsHelpers;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.SimpleValueReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.ValueLocatorBase;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.type.ResolvedType;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.type.TypeBindings;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.type.TypeResolver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class ValueReaderLocator
extends ValueLocatorBase {
    protected static final int MAX_CACHED_READERS = 500;
    protected final TypeResolver _typeResolver;
    protected final ReaderWriterProvider _readerProvider;
    protected final ReaderWriterModifier _readerModifier;
    protected final ConcurrentHashMap<ClassKey, ValueReader> _knownReaders;
    protected Map<ClassKey, ValueReader> _incompleteReaders;
    protected final Object _readerLock;
    protected final int _features;
    protected final JSONReader _readContext;
    private ClassKey _key;

    protected ValueReaderLocator(ReaderWriterProvider readerWriterProvider, ReaderWriterModifier readerWriterModifier) {
        this._features = 0;
        this._readerProvider = readerWriterProvider;
        this._readerModifier = readerWriterModifier;
        this._knownReaders = new ConcurrentHashMap(10, 0.75f, 2);
        this._typeResolver = new TypeResolver();
        this._readerLock = new Object();
        this._readContext = null;
    }

    protected ValueReaderLocator(ValueReaderLocator valueReaderLocator, int n, JSONReader jSONReader) {
        this._features = n;
        this._readContext = jSONReader;
        this._readerProvider = valueReaderLocator._readerProvider;
        this._readerModifier = valueReaderLocator._readerModifier;
        this._knownReaders = valueReaderLocator._knownReaders;
        this._typeResolver = valueReaderLocator._typeResolver;
        this._readerLock = valueReaderLocator._readerLock;
    }

    protected ValueReaderLocator(ValueReaderLocator valueReaderLocator, ReaderWriterProvider readerWriterProvider, ReaderWriterModifier readerWriterModifier) {
        this._knownReaders = new ConcurrentHashMap(10, 0.75f, 2);
        this._readerLock = new Object();
        this._features = valueReaderLocator._features;
        this._readContext = valueReaderLocator._readContext;
        this._readerProvider = readerWriterProvider;
        this._readerModifier = readerWriterModifier;
        this._typeResolver = valueReaderLocator._typeResolver;
    }

    public static final ValueReaderLocator blueprint(ReaderWriterProvider readerWriterProvider, ReaderWriterModifier readerWriterModifier) {
        return new ValueReaderLocator(readerWriterProvider, readerWriterModifier);
    }

    public ValueReaderLocator with(ReaderWriterProvider readerWriterProvider) {
        if (readerWriterProvider == this._readerProvider) {
            return this;
        }
        return new ValueReaderLocator(this, readerWriterProvider, this._readerModifier);
    }

    public ValueReaderLocator with(ReaderWriterModifier readerWriterModifier) {
        if (readerWriterModifier == this._readerModifier) {
            return this;
        }
        return new ValueReaderLocator(this, this._readerProvider, readerWriterModifier);
    }

    public ValueReaderLocator perOperationInstance(JSONReader jSONReader, int n) {
        return new ValueReaderLocator(this, n & CACHE_FLAGS, jSONReader);
    }

    public ReaderWriterProvider readerWriterProvider() {
        return this._readerProvider;
    }

    public ReaderWriterModifier readerWriterModifier() {
        return this._readerModifier;
    }

    public ValueReader findReader(Class<?> clazz) {
        ClassKey classKey = this._key == null ? new ClassKey(clazz, this._features) : this._key.with(clazz, this._features);
        ValueReader valueReader = this._knownReaders.get(classKey);
        if (valueReader != null) {
            return valueReader;
        }
        valueReader = this.createReader(null, clazz, clazz);
        if (this._knownReaders.size() >= 500) {
            this._knownReaders.clear();
        }
        this._knownReaders.putIfAbsent(new ClassKey(clazz, this._features), valueReader);
        return valueReader;
    }

    protected ValueReader createReader(Class<?> clazz, Class<?> clazz2, Type type) {
        ValueReader valueReader = this._createReader(clazz, clazz2, type);
        if (this._readerModifier != null && (valueReader = this._readerModifier.modifyValueReader(this._readContext, clazz2, valueReader)) == null) {
            throw new IllegalArgumentException("ReaderWriterModifier.modifyValueReader() returned null");
        }
        return valueReader;
    }

    protected ValueReader _createReader(Class<?> clazz, Class<?> clazz2, Type type) {
        ValueReader valueReader;
        if (clazz2 == Object.class) {
            return AnyReader.std;
        }
        if (clazz2.isArray()) {
            return this.arrayReader(clazz, clazz2);
        }
        if (clazz2.isEnum()) {
            ValueReader valueReader2;
            if (this._readerProvider != null && (valueReader2 = this._readerProvider.findValueReader(this._readContext, clazz2)) != null) {
                return valueReader2;
            }
            return this.enumReader(clazz2);
        }
        if (Collection.class.isAssignableFrom(clazz2)) {
            return this.collectionReader(clazz, type);
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            return this.mapReader(clazz, type);
        }
        if (this._readerProvider != null && (valueReader = this._readerProvider.findValueReader(this._readContext, clazz2)) != null) {
            return valueReader;
        }
        int n = this._findSimpleType(clazz2, false);
        if (n > 0) {
            return new SimpleValueReader(clazz2, n);
        }
        return this.beanReader(clazz2);
    }

    protected ValueReader arrayReader(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3 = clazz2.getComponentType();
        if (!clazz3.isPrimitive()) {
            return new ArrayReader(clazz2, clazz3, this.createReader(clazz, clazz3, clazz3));
        }
        int n = this._findSimpleType(clazz2, false);
        if (n > 0) {
            return new SimpleValueReader(clazz2, n);
        }
        throw new IllegalArgumentException("Deserialization of " + clazz2.getName() + " not (yet) supported");
    }

    protected ValueReader enumReader(Class<?> clazz) {
        POJODefinition pOJODefinition = null;
        if (this._readerModifier != null) {
            pOJODefinition = this._readerModifier.pojoDefinitionForDeserialization(this._readContext, clazz);
        }
        TreeMap<String, Object> treeMap = JSON.Feature.ACCEPT_CASE_INSENSITIVE_ENUMS.isEnabled(this._features) ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new HashMap();
        Object[] objectArray = clazz.getEnumConstants();
        if (pOJODefinition == null) {
            for (Object obj : objectArray) {
                treeMap.put(obj.toString(), obj);
            }
        } else {
            for (POJODefinition.Prop prop : pOJODefinition.getProperties()) {
                if (prop.field == null || !prop.field.isEnumConstant()) continue;
                try {
                    treeMap.put(prop.name, prop.field.get(null));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
            }
        }
        return new EnumReader(clazz, objectArray, treeMap);
    }

    protected ValueReader collectionReader(Class<?> clazz, Type type) {
        ResolvedType resolvedType = this._typeResolver.resolve(this._bindings(clazz), type);
        List<ResolvedType> list = resolvedType.typeParametersFor(Collection.class);
        return this.collectionReader(resolvedType.erasedType(), list.get(0));
    }

    protected ValueReader collectionReader(Class<?> clazz, ResolvedType resolvedType) {
        ValueReader valueReader;
        Object object;
        Class<?> clazz2 = resolvedType.erasedType();
        if (Collection.class.isAssignableFrom(clazz2)) {
            object = resolvedType.typeParametersFor(Collection.class);
            valueReader = this.collectionReader(clazz2, object.get(0));
        } else if (Map.class.isAssignableFrom(clazz2)) {
            object = resolvedType.typeParametersFor(Map.class);
            valueReader = this.mapReader(clazz2, object.get(1));
        } else {
            valueReader = this.findReader(clazz2);
        }
        if (this._readerProvider != null && (object = this._readerProvider.findCollectionReader(this._readContext, clazz, resolvedType, valueReader)) != null) {
            return object;
        }
        return new CollectionReader(clazz, valueReader);
    }

    protected ValueReader mapReader(Class<?> clazz, Type type) {
        ResolvedType resolvedType = this._typeResolver.resolve(this._bindings(clazz), type);
        List<ResolvedType> list = resolvedType.typeParametersFor(Map.class);
        return this.mapReader(resolvedType.erasedType(), list.get(1));
    }

    protected ValueReader mapReader(Class<?> clazz, ResolvedType resolvedType) {
        ValueReader valueReader;
        Object object;
        Class<?> clazz2 = resolvedType.erasedType();
        if (Collection.class.isAssignableFrom(clazz2)) {
            object = resolvedType.typeParametersFor(Collection.class);
            valueReader = this.collectionReader(clazz2, object.get(0));
        } else if (Map.class.isAssignableFrom(clazz2)) {
            object = resolvedType.typeParametersFor(Map.class);
            valueReader = this.mapReader(clazz2, object.get(1));
        } else {
            valueReader = this.findReader(clazz2);
        }
        if (this._readerProvider != null && (object = this._readerProvider.findMapReader(this._readContext, clazz, resolvedType, valueReader)) != null) {
            return object;
        }
        return new MapReader(clazz, valueReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueReader beanReader(Class<?> clazz) {
        ClassKey classKey = new ClassKey(clazz, this._features);
        Object object = this._readerLock;
        synchronized (object) {
            ValueReader valueReader;
            if (this._incompleteReaders == null) {
                this._incompleteReaders = new HashMap<ClassKey, ValueReader>();
            } else {
                valueReader = this._incompleteReaders.get(classKey);
                if (valueReader != null) {
                    return valueReader;
                }
            }
            valueReader = this._resolveBeanForDeser(clazz, this._resolveBeanDef(clazz));
            try {
                this._incompleteReaders.put(classKey, valueReader);
                for (Map.Entry<String, BeanPropertyReader> entry : ((BeanReader)valueReader).propertiesByName().entrySet()) {
                    BeanPropertyReader beanPropertyReader = entry.getValue();
                    entry.setValue(beanPropertyReader.withReader(this.createReader(clazz, beanPropertyReader.rawSetterType(), beanPropertyReader.genericSetterType())));
                }
            }
            finally {
                this._incompleteReaders.remove(classKey);
            }
            return valueReader;
        }
    }

    protected POJODefinition _resolveBeanDef(Class<?> clazz) {
        try {
            POJODefinition pOJODefinition;
            if (this._readerModifier != null && (pOJODefinition = this._readerModifier.pojoDefinitionForDeserialization(this._readContext, clazz)) != null) {
                return pOJODefinition;
            }
            return BeanPropertyIntrospector.instance().pojoDefinitionForDeserialization(this._readContext, clazz);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.format("Failed to introspect ClassDefinition for type '%s': %s", clazz.getName(), exception.getMessage()), exception);
        }
    }

    protected BeanReader _resolveBeanForDeser(Class<?> clazz, POJODefinition pOJODefinition) {
        Map<String, BeanPropertyReader> map;
        BeanConstructors beanConstructors = pOJODefinition.constructors();
        boolean bl = JSON.Feature.FORCE_REFLECTION_ACCESS.isEnabled(this._features);
        if (bl) {
            beanConstructors.forceAccess();
        }
        boolean bl2 = JSON.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES.isEnabled(this._features);
        List<POJODefinition.Prop> list = pOJODefinition.getProperties();
        int n = list.size();
        AbstractMap abstractMap = null;
        boolean bl3 = RecordsHelpers.isRecordType(clazz);
        if (n == 0) {
            map = Collections.emptyMap();
        } else {
            HashSet<String> hashSet = bl3 ? new HashSet<String>(RecordsHelpers.recordPropertyNames(clazz)) : null;
            map = bl2 ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new LinkedHashMap();
            boolean bl4 = JSON.Feature.USE_FIELDS.isEnabled(this._features);
            for (int i = 0; i < n; ++i) {
                Field field;
                POJODefinition.Prop prop = list.get(i);
                Method method = prop.setter;
                Field field2 = field = bl4 ? prop.field : null;
                if (method != null) {
                    if (bl) {
                        method.setAccessible(true);
                    } else if (!Modifier.isPublic(method.getModifiers())) {
                        method = null;
                    }
                }
                if (bl3) {
                    if (!hashSet.contains(prop.name)) continue;
                    try {
                        field = clazz.getDeclaredField(prop.name);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new IllegalStateException("Cannot access field " + prop.name + " of record class " + clazz.getName(), noSuchFieldException);
                    }
                } else if (method == null) {
                    if (field == null) continue;
                    if (bl) {
                        field.setAccessible(true);
                    } else if (!Modifier.isPublic(field.getModifiers())) continue;
                }
                map.put(prop.name, new BeanPropertyReader(prop.name, field, method, i));
                if (!prop.hasAliases()) continue;
                if (abstractMap == null) {
                    abstractMap = bl2 ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new HashMap();
                }
                for (String string : prop.aliases()) {
                    abstractMap.put(string, prop.name);
                }
            }
        }
        return new BeanReader(clazz, map, beanConstructors, pOJODefinition.getIgnorableNames(), abstractMap);
    }

    private TypeBindings _bindings(Class<?> clazz) {
        if (clazz == null) {
            return TypeBindings.emptyBindings();
        }
        return TypeBindings.create(clazz, (ResolvedType[])null);
    }
}

