/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.map.impl.wan.WanMapEntryView;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanEventType;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanEnterpriseMapAddOrUpdateEvent
extends WanEnterpriseMapEvent<EntryView<Object, Object>> {
    private SplitBrainMergePolicy mergePolicy;
    private WanMapEntryView<Object, Object> entryView;

    public WanEnterpriseMapAddOrUpdateEvent(@Nonnull String mapName, @Nonnull SplitBrainMergePolicy mergePolicy, @Nonnull WanMapEntryView<Object, Object> entryView, int backupCount) {
        super(mapName, backupCount);
        this.mergePolicy = mergePolicy;
        this.entryView = entryView;
    }

    public WanEnterpriseMapAddOrUpdateEvent() {
    }

    public Object getMergePolicy() {
        return this.mergePolicy;
    }

    public WanMapEntryView<Object, Object> getEntryView() {
        return this.entryView;
    }

    @Override
    @Nonnull
    public Data getKey() {
        return this.entryView.getDataKey();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.mergePolicy);
        out.writeObject(this.entryView);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
        this.entryView = (WanMapEntryView)in.readObject();
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void incrementEventCount(@Nonnull WanEventCounters counters) {
        counters.incrementUpdate(this.getMapName());
    }

    @Override
    @Nonnull
    public WanEventType getEventType() {
        return WanEventType.ADD_OR_UPDATE;
    }

    @Override
    @Nullable
    public EntryView<Object, Object> getEventObject() {
        return this.entryView;
    }
}

