/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.RamStoreHelper;
import com.hazelcast.internal.hotrestart.RecordDataSink;
import com.hazelcast.internal.hotrestart.impl.KeyOnHeap;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.EnterpriseRecordStore;
import com.hazelcast.map.impl.recordstore.HotRestartStorage;
import com.hazelcast.map.impl.recordstore.HotRestartStorageImpl;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;

public class OnHeapMapRamStoreImpl
implements RamStore {
    private final EnterpriseRecordStore recordStore;
    private final HotRestartStorageImpl<Record> storage;
    private final ExpirySystem expirySystem;

    public OnHeapMapRamStoreImpl(EnterpriseRecordStore recordStore) {
        this.recordStore = recordStore;
        this.storage = (HotRestartStorageImpl)recordStore.getStorage();
        this.expirySystem = recordStore.getExpirySystem();
    }

    @Override
    public boolean copyEntry(KeyHandle kh, int expectedSize, RecordDataSink sink) throws HotRestartException {
        HeapData key = new HeapData(((KeyOnHeap)kh).bytes());
        Record record = this.storage.get(key);
        if (record == null) {
            return false;
        }
        Data value = this.recordStore.toData(record.getValue());
        return RamStoreHelper.copyEntry((KeyOnHeap)kh, value, expectedSize, sink);
    }

    @Override
    public KeyHandle toKeyHandle(byte[] key) {
        return new KeyOnHeap(this.recordStore.getPrefix(), key);
    }

    @Override
    public void removeNullEntries(SetOfKeyHandle keyHandles) {
    }

    @Override
    public void accept(KeyHandle kh, byte[] valueBytes) {
        HeapData key;
        long now = Clock.currentTimeMillis();
        HeapData value = new HeapData(valueBytes);
        HotRestartStorage storage = (HotRestartStorage)this.recordStore.getStorage();
        Record record = (Record)storage.get(key = new HeapData(((KeyOnHeap)kh).bytes()));
        if (record == null) {
            record = this.recordStore.createRecord(key, value, now);
            storage.putTransient(key, record);
        } else {
            storage.updateTransient(key, record, value);
        }
        this.expirySystem.add((Data)key, now, now);
        this.recordStore.disposeDeferredBlocks();
    }
}

