/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.collection.PartitionIdSet;

public final class Target {
    public static final Target ALL_NODES = new Target(TargetMode.ALL_NODES, null);
    public static final Target LOCAL_NODE = new Target(TargetMode.LOCAL_NODE, null);
    private final TargetMode mode;
    private final PartitionIdSet partitions;

    private Target(TargetMode mode, PartitionIdSet partitions) {
        this.mode = Preconditions.checkNotNull(mode);
        this.partitions = partitions;
        if (mode.equals((Object)TargetMode.PARTITION_OWNER) ^ partitions != null) {
            throw new IllegalArgumentException("partitions must be used only with PARTITION_OWNER mode and not otherwise");
        }
    }

    public TargetMode mode() {
        return this.mode;
    }

    public PartitionIdSet partitions() {
        return this.partitions;
    }

    public static Target createPartitionTarget(PartitionIdSet partitions) {
        return new Target(TargetMode.PARTITION_OWNER, partitions);
    }

    public String toString() {
        return "Target{mode=" + String.valueOf((Object)this.mode) + ", partitionsSize=" + (this.partitions == null ? 0 : this.partitions.size()) + "}";
    }

    public static enum TargetMode {
        LOCAL_NODE,
        ALL_NODES,
        PARTITION_OWNER;

    }
}

