/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.MemoryInfoAccessor;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.memory.MemoryUnit;

public class HDEvictionChecker
extends EvictionChecker {
    private final long maxNativeMemory;
    private final MemoryStats memoryStats;

    public HDEvictionChecker(MemoryInfoAccessor memoryInfoAccessor, MapServiceContext mapServiceContext) {
        super(memoryInfoAccessor, mapServiceContext);
        long l;
        SerializationService serializationService = mapServiceContext.getNodeEngine().getSerializationService();
        HazelcastMemoryManager memoryManager = ((EnterpriseSerializationService)serializationService).getMemoryManager();
        MemoryStats memoryStats = this.memoryStats = memoryManager.getMemoryStats();
        if (memoryStats instanceof PooledNativeMemoryStats) {
            PooledNativeMemoryStats pooledNativeMemoryStats = (PooledNativeMemoryStats)memoryStats;
            l = pooledNativeMemoryStats.getMaxData();
        } else {
            l = this.memoryStats.getMaxNative();
        }
        this.maxNativeMemory = l;
    }

    @Override
    public boolean checkEvictable(RecordStore recordStore) {
        EnterpriseMapContainer mapContainer = (EnterpriseMapContainer)recordStore.getMapContainer();
        HiDensityStorageInfo storageInfo = mapContainer.getHDStorageInfo();
        MapConfig mapConfig = mapContainer.getMapConfig();
        EvictionConfig evictionConfig = mapConfig.getEvictionConfig();
        MaxSizePolicy maxSizePolicy = evictionConfig.getMaxSizePolicy();
        int maxConfiguredSize = evictionConfig.getSize();
        switch (maxSizePolicy) {
            case FREE_NATIVE_MEMORY_PERCENTAGE: {
                return (double)this.memoryStats.getFreeNative() * 100.0 / (double)this.maxNativeMemory < (double)maxConfiguredSize;
            }
            case FREE_NATIVE_MEMORY_SIZE: {
                return this.memoryStats.getFreeNative() < MemoryUnit.MEGABYTES.toBytes(maxConfiguredSize);
            }
            case USED_NATIVE_MEMORY_PERCENTAGE: {
                return (double)storageInfo.getUsedMemory() * 100.0 / (double)this.maxNativeMemory > (double)maxConfiguredSize;
            }
            case USED_NATIVE_MEMORY_SIZE: {
                return storageInfo.getUsedMemory() > MemoryUnit.MEGABYTES.toBytes(maxConfiguredSize);
            }
        }
        return super.checkEvictable(recordStore);
    }
}

