/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.ChunkSuppliers;
import com.hazelcast.internal.partition.OffloadedReplicationPreparation;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.partition.impl.MerkleTreePartitionComparisonOperation;
import com.hazelcast.internal.services.DistributedObjectNamespace;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.tstore.compaction.LogBasedCompactor;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterpriseMapChunkSupplier;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapMigrationAwareService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.EnterpriseMapReplicationOperation;
import com.hazelcast.map.impl.operation.MapMerkleTreePartitionCompareOperation;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.recordstore.CompactionAwareStorage;
import com.hazelcast.map.impl.recordstore.CustomStepAwareStorage;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.TieredStorageImpl;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class EnterpriseMapMigrationAwareService
extends MapMigrationAwareService
implements OffloadedReplicationPreparation {
    private static final int PARTITION_COMPACTOR_STOP_WAITING_SECONDS = 10;
    private final ILogger logger;

    EnterpriseMapMigrationAwareService(MapServiceContext mapServiceContext) {
        super(mapServiceContext);
        this.logger = mapServiceContext.getNodeEngine().getLogger(EnterpriseMapMigrationAwareService.class);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        super.beforeMigration(event);
        if (!EnterpriseMapMigrationAwareService.isLocalPromotion(event)) {
            this.tryStopPartitionCompactors(event);
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        super.rollbackMigration(event);
        this.setCompactorStateBackToNotRunning(event);
    }

    private void tryStopPartitionCompactors(PartitionMigrationEvent event) {
        List mapNameFuturePairs = this.requestCompactorsToStop(event);
        EnterpriseMapMigrationAwareService.waitForCompactorsToStop(event.getPartitionId(), mapNameFuturePairs, this.logger);
    }

    public static void waitForCompactorsToStop(int partitionId, List mapNameFuturePairs, ILogger logger) {
        for (int i = 0; i < mapNameFuturePairs.size(); i += 2) {
            String mapName = (String)mapNameFuturePairs.get(i);
            Future future = (Future)mapNameFuturePairs.get(i + 1);
            try {
                EnterpriseMapMigrationAwareService.logWaitingStarted(partitionId, mapName, logger);
                future.get(10L, TimeUnit.SECONDS);
                EnterpriseMapMigrationAwareService.logWaitingEnd(partitionId, mapName, logger);
                continue;
            }
            catch (Exception e) {
                String msg = String.format("Could not managed to stop partition compactor for migrating partition [map=%s, partitionId=%d, maxWaitSeconds=%d]", mapName, partitionId, 10);
                throw new DeviceException(msg, e);
            }
        }
    }

    private List requestCompactorsToStop(PartitionMigrationEvent event) {
        ArrayList mapNameFuturePairs = new ArrayList();
        this.consumeTieredStoreEnabledMaps(event, recordStore -> EnterpriseMapMigrationAwareService.requestCompactorsToStop(recordStore, mapNameFuturePairs));
        return mapNameFuturePairs;
    }

    public static void requestCompactorsToStop(RecordStore recordStore, List<Object> mapNameFuturePairs) {
        EnterpriseMapMigrationAwareService.requestPartitionedDataCompactorToStop(recordStore, mapNameFuturePairs);
        EnterpriseMapMigrationAwareService.requestPartitionedIndexCompactorToStop(recordStore, mapNameFuturePairs);
    }

    public static void requestPartitionedDataCompactorToStop(RecordStore recordStore, List<Object> mapNameFuturePairs) {
        Storage storage = recordStore.getStorage();
        if (!(storage instanceof TieredStorageImpl)) {
            return;
        }
        LogBasedCompactor<TieredStoreRecord> currentPartitionCompactor = ((TieredStorageImpl)storage).getPartitionCompactorOrNull();
        if (currentPartitionCompactor != null) {
            mapNameFuturePairs.add(recordStore.getName());
            mapNameFuturePairs.add(currentPartitionCompactor.requestCompactorToStop());
        }
    }

    public static void requestPartitionedIndexCompactorToStop(RecordStore recordStore, List<Object> mapNameFuturePairs) {
        IndexRegistry indexes = recordStore.getMapContainer().getOrNullPartitionedIndexRegistry(recordStore.getPartitionId());
        if (indexes == null) {
            return;
        }
        for (InternalIndex index : indexes.getIndexes()) {
            CustomStepAwareStorage storage = index.getCustomStepAwareStorage();
            if (storage == null) continue;
            CompactionAwareStorage caStorage = (CompactionAwareStorage)storage;
            LogBasedCompactor currentPartitionCompactor = caStorage.getPartitionCompactorOrNull();
            String mapName = indexes.getMapName();
            if (currentPartitionCompactor == null) continue;
            mapNameFuturePairs.add(mapName + index.getName());
            mapNameFuturePairs.add(currentPartitionCompactor.requestCompactorToStop());
        }
    }

    private void setCompactorStateBackToNotRunning(PartitionMigrationEvent event) {
        this.consumeTieredStoreEnabledMaps(event, recordStore -> EnterpriseMapMigrationAwareService.setCompactorsBackToRunning(recordStore));
    }

    public static void setCompactorsBackToRunning(RecordStore recordStore) {
        EnterpriseMapMigrationAwareService.setPartitionedDataCompactorsBackToRunning(recordStore);
        EnterpriseMapMigrationAwareService.setPartitionedIndexCompactorsBackToRunning(recordStore);
    }

    private static void setPartitionedDataCompactorsBackToRunning(RecordStore recordStore) {
        Storage storage = recordStore.getStorage();
        if (!(storage instanceof TieredStorageImpl)) {
            return;
        }
        LogBasedCompactor<TieredStoreRecord> currentPartitionCompactor = ((TieredStorageImpl)storage).getPartitionCompactorOrNull();
        if (currentPartitionCompactor != null) {
            currentPartitionCompactor.trySetCompactorStateBackToRunning();
        }
    }

    private static void setPartitionedIndexCompactorsBackToRunning(RecordStore recordStore) {
        IndexRegistry indexes = recordStore.getMapContainer().getOrNullPartitionedIndexRegistry(recordStore.getPartitionId());
        if (indexes == null) {
            return;
        }
        for (InternalIndex index : indexes.getIndexes()) {
            CompactionAwareStorage caStorage;
            LogBasedCompactor partitionedIndexCompactor;
            CustomStepAwareStorage indexStorage = index.getCustomStepAwareStorage();
            if (indexStorage == null || (partitionedIndexCompactor = (caStorage = (CompactionAwareStorage)indexStorage).getPartitionCompactorOrNull()) == null) continue;
            partitionedIndexCompactor.trySetCompactorStateBackToRunning();
        }
    }

    private void consumeTieredStoreEnabledMaps(PartitionMigrationEvent event, Consumer<RecordStore> consume) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        partitionContainer.getMaps().values().stream().filter(recordStore -> recordStore.getStorage() instanceof TieredStorageImpl).forEach(consume);
    }

    private static void logWaitingEnd(int partitionId, String mapName, ILogger logger) {
        if (logger.isFinestEnabled()) {
            logger.finest(String.format("Stopped partition compactor for migrating partition [map=%s, partitionId=%d, maxWaitSeconds=%d]", mapName, partitionId, 10));
        }
    }

    private static void logWaitingStarted(int partitionId, String mapName, ILogger logger) {
        if (logger.isFinestEnabled()) {
            logger.finest(String.format("Waiting partition compactor stop [map=%s, partitionId=%d, maxWaitSeconds=%d]", mapName, partitionId, 10));
        }
    }

    @Override
    public ChunkSupplier newChunkSupplier(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        if (ThreadUtil.isRunningOnPartitionThread()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("Preparing map replication operation on partition thread cannot use differential sync, partitionId %d / replicaIndex %d", event.getPartitionId(), event.getReplicaIndex()));
            }
            return super.newChunkSupplier(event, namespaces);
        }
        Map<String, int[]> mapNamesToMerkleDiff = this.determineDiff(event, namespaces);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Using Merkle tree diff for %s, namespaces were %s on partition ID %d,  replica index %d", mapNamesToMerkleDiff == null ? "-" : mapNamesToMerkleDiff.keySet(), namespaces, event.getPartitionId(), event.getReplicaIndex()));
        }
        ArrayList<ChunkSupplier> chain = new ArrayList<ChunkSupplier>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            String mapName = ((ObjectNamespace)namespace).getObjectName();
            chain.add(new EnterpriseMapChunkSupplier(this.mapServiceContext, namespace, event.getPartitionId(), event.getReplicaIndex(), mapNamesToMerkleDiff == null ? null : mapNamesToMerkleDiff.get(mapName)));
        }
        return ChunkSuppliers.newChainedChunkSupplier(chain);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        assert (this.assertAllKnownNamespaces(namespaces));
        if (ThreadUtil.isRunningOnPartitionThread()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("Preparing map replication operation on partition thread cannot use differential sync, partitionId %d / replicaIndex %d", event.getPartitionId(), event.getReplicaIndex()));
            }
            return super.prepareReplicationOperation(event, namespaces);
        }
        if (this.mapServiceContext.getNodeEngine().getClusterService().getClusterVersion().isLessOrEqual(Versions.V4_2)) {
            return super.prepareReplicationOperation(event, namespaces);
        }
        assert (!ThreadUtil.isRunningOnPartitionThread());
        Map<String, int[]> mapNamesToMerkleDiff = this.determineDiff(event, namespaces);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Using Merkle tree diff for %s, namespaces were %s on partition ID %d,  replica index %d", mapNamesToMerkleDiff == null ? "-" : mapNamesToMerkleDiff.keySet(), namespaces, event.getPartitionId(), event.getReplicaIndex()));
        }
        int partitionId = event.getPartitionId();
        EnterpriseMapReplicationOperation operation = new EnterpriseMapReplicationOperation(this.containers[partitionId], namespaces, partitionId, event.getReplicaIndex(), mapNamesToMerkleDiff);
        operation.setService(this.mapServiceContext.getService());
        operation.setNodeEngine(this.mapServiceContext.getNodeEngine());
        return operation;
    }

    @Override
    public boolean shouldOffload() {
        return true;
    }

    @Nullable
    private Map<String, int[]> determineDiff(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        if (event.getTarget() == null) {
            return null;
        }
        List<String> mapNames = this.getMapNames(event, namespaces);
        if (mapNames.isEmpty()) {
            return null;
        }
        Map<String, int[]> merkleDiffByMapName = MerkleTreePartitionComparisonOperation.syncGetPartitionMerkleDiff(this.mapServiceContext.getNodeEngine(), "hz:impl:mapService", event, mapNames, MapMerkleTreePartitionCompareOperation.class.getName());
        if (MapUtil.isNullOrEmpty(merkleDiffByMapName)) {
            return null;
        }
        merkleDiffByMapName.entrySet().removeIf(entry -> entry.getValue() == MerkleTreePartitionComparisonOperation.FULL_SYNC);
        return merkleDiffByMapName;
    }

    private List<String> getMapNames(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        ArrayList<String> mapNames = new ArrayList<String>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            PartitionContainer container;
            RecordStore existingRecordStore;
            MapConfig mapConfig;
            String objectName = ((DistributedObjectNamespace)namespace).getObjectName();
            MapContainer existingMapContainer = this.mapServiceContext.getExistingMapContainer(objectName);
            if (existingMapContainer == null || (mapConfig = existingMapContainer.getMapConfig()).getTotalBackupCount() < event.getReplicaIndex() || !this.mapServiceContext.shouldEnableMerkleTree(existingMapContainer, false) || (existingRecordStore = (container = this.containers[event.getPartitionId()]).getExistingRecordStore(objectName)) == null) continue;
            mapNames.add(objectName);
        }
        return mapNames;
    }
}

