/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.core.function.KeyedWindowResultFunction;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class SessionWindowP<K, A, R, OUT>
extends AbstractProcessor {
    private static final Watermark COMPLETING_WM = new Watermark(Long.MAX_VALUE);
    final Map<K, Windows<A>> keyToWindows = new HashMap<K, Windows<A>>();
    final SortedMap<Long, Set<K>> deadlineToKeys = new TreeMap<Long, Set<K>>();
    long currentWatermark = Long.MIN_VALUE;
    private final long sessionTimeout;
    @Nonnull
    private final List<ToLongFunction<Object>> timestampFns;
    @Nonnull
    private final List<Function<Object, K>> keyFns;
    @Nonnull
    private final AggregateOperation<A, ? extends R> aggrOp;
    @Nonnull
    private final BiConsumer<? super A, ? super A> combineFn;
    @Nonnull
    private final KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> mapToOutputFn;
    @Nonnull
    private final AbstractProcessor.FlatMapper<Watermark, Object> closedWindowFlatmapper;
    private ProcessingGuarantee processingGuarantee;
    private final byte windowWatermarkKey;
    @Probe(name="lateEventsDropped")
    private final Counter lateEventsDropped = SwCounter.newSwCounter();
    @Probe(name="totalKeys")
    private final Counter totalKeys = SwCounter.newSwCounter();
    @Probe(name="totalWindows")
    private final Counter totalWindows = SwCounter.newSwCounter();
    private final long earlyResultsPeriod;
    private long lastTimeEarlyResultsEmitted;
    private Traverser<OUT> earlyWinTraverser;
    private Traverser snapshotTraverser;
    private long minRestoredCurrentWatermark = Long.MAX_VALUE;
    private boolean inComplete;
    private final Function<K, Windows<A>> newWindowsFunction = k -> {
        this.totalKeys.inc();
        return new Windows();
    };

    public SessionWindowP(long sessionTimeout, long earlyResultsPeriod, @Nonnull List<? extends ToLongFunction<?>> timestampFns, @Nonnull List<? extends Function<?, ? extends K>> keyFns, @Nonnull AggregateOperation<A, ? extends R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> mapToOutputFn, byte windowWatermarkKey) {
        Preconditions.checkTrue(keyFns.size() == aggrOp.arity(), keyFns.size() + " key functions provided for " + aggrOp.arity() + "-arity aggregate operation");
        this.timestampFns = timestampFns;
        this.keyFns = keyFns;
        this.earlyResultsPeriod = earlyResultsPeriod;
        this.aggrOp = aggrOp;
        this.combineFn = Objects.requireNonNull(aggrOp.combineFn());
        this.mapToOutputFn = mapToOutputFn;
        this.sessionTimeout = sessionTimeout;
        this.closedWindowFlatmapper = this.flatMapper(this::traverseClosedWindows);
        this.windowWatermarkKey = windowWatermarkKey;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        this.processingGuarantee = context.processingGuarantee();
        this.lastTimeEarlyResultsEmitted = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    @Override
    public boolean tryProcess() {
        if (this.earlyResultsPeriod == 0L) {
            return true;
        }
        if (this.earlyWinTraverser != null) {
            return this.emitFromTraverser(this.earlyWinTraverser);
        }
        long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        if (now < this.lastTimeEarlyResultsEmitted + this.earlyResultsPeriod) {
            return true;
        }
        this.lastTimeEarlyResultsEmitted = now;
        this.earlyWinTraverser = Traversers.traverseIterable(this.keyToWindows.entrySet()).flatMap(e -> this.earlyWindows(e.getKey(), (Windows)e.getValue())).onFirstNull(() -> {
            this.earlyWinTraverser = null;
        });
        return this.emitFromTraverser(this.earlyWinTraverser);
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        long timestamp = this.timestampFns.get(ordinal).applyAsLong(item);
        if (timestamp < this.currentWatermark) {
            com.hazelcast.jet.impl.util.Util.logLateEvent(this.getLogger(), (byte)0, this.currentWatermark, item);
            this.lateEventsDropped.inc();
            return true;
        }
        K key = this.keyFns.get(ordinal).apply(item);
        this.addItem(ordinal, this.keyToWindows.computeIfAbsent(key, this.newWindowsFunction), key, timestamp, item);
        return true;
    }

    @Override
    public boolean tryProcessWatermark(@Nonnull Watermark wm) {
        if (wm.key() != this.windowWatermarkKey) {
            return true;
        }
        this.currentWatermark = wm.timestamp();
        assert (this.totalWindows.get() == (long)this.deadlineToKeys.values().stream().mapToInt(Set::size).sum()) : "unexpected totalWindows. Expected=" + this.deadlineToKeys.values().stream().mapToInt(Set::size).sum() + ", actual=" + this.totalWindows.get();
        return this.closedWindowFlatmapper.tryProcess(wm);
    }

    @Override
    public boolean complete() {
        this.inComplete = true;
        return this.closedWindowFlatmapper.tryProcess(COMPLETING_WM);
    }

    private Traverser<Object> traverseClosedWindows(Watermark wm) {
        SortedMap<Long, Set<K>> windowsToClose = this.deadlineToKeys.headMap(wm.timestamp());
        Stream closedWindows = windowsToClose.values().stream().flatMap(Collection::stream).map(key -> this.closeWindows(this.keyToWindows.get(key), key, wm.timestamp())).flatMap(Collection::stream);
        Traverser<Object> result = Traversers.traverseStream(closedWindows).onFirstNull(() -> {
            this.totalWindows.inc(-windowsToClose.values().stream().mapToInt(Set::size).sum());
            windowsToClose.clear();
        });
        if (wm != COMPLETING_WM) {
            result = result.append(wm);
        }
        return result;
    }

    private void addToDeadlines(K key, long deadline) {
        if (this.deadlineToKeys.computeIfAbsent(deadline, x -> new HashSet()).add(key)) {
            this.totalWindows.inc();
        }
    }

    private void removeFromDeadlines(K key, long deadline) {
        Set ks = (Set)this.deadlineToKeys.get(deadline);
        ks.remove(key);
        this.totalWindows.inc(-1L);
        if (ks.isEmpty()) {
            this.deadlineToKeys.remove(deadline);
        }
    }

    @Override
    public boolean saveToSnapshot() {
        if (this.inComplete) {
            return this.complete();
        }
        if (this.snapshotTraverser == null) {
            this.snapshotTraverser = Traversers.traverseIterable(this.keyToWindows.entrySet()).append(Util.entry(BroadcastKey.broadcastKey(Keys.CURRENT_WATERMARK), this.currentWatermark)).onFirstNull(() -> {
                this.snapshotTraverser = null;
            });
        }
        return this.emitFromTraverserToSnapshot(this.snapshotTraverser);
    }

    @Override
    protected void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        if (key instanceof BroadcastKey) {
            BroadcastKey bcastKey = (BroadcastKey)key;
            if (!Keys.CURRENT_WATERMARK.equals(bcastKey.key())) {
                throw new JetException("Unexpected broadcast key: " + String.valueOf(bcastKey.key()));
            }
            long newCurrentWatermark = (Long)value;
            assert (this.processingGuarantee != ProcessingGuarantee.EXACTLY_ONCE || this.minRestoredCurrentWatermark == Long.MAX_VALUE || this.minRestoredCurrentWatermark == newCurrentWatermark) : "different values for currentWatermark restored, before=" + this.minRestoredCurrentWatermark + ", new=" + newCurrentWatermark;
            this.minRestoredCurrentWatermark = Math.min(newCurrentWatermark, this.minRestoredCurrentWatermark);
            return;
        }
        if (this.keyToWindows.put(key, (Windows)value) != null) {
            throw new JetException("Duplicate key in snapshot: " + String.valueOf(key));
        }
    }

    @Override
    public boolean finishSnapshotRestore() {
        assert (this.deadlineToKeys.isEmpty());
        for (Map.Entry<K, Windows<A>> entry : this.keyToWindows.entrySet()) {
            for (long end : entry.getValue().ends) {
                this.addToDeadlines(entry.getKey(), end);
            }
        }
        this.currentWatermark = this.minRestoredCurrentWatermark;
        this.totalKeys.set(this.keyToWindows.size());
        this.getLogger().fine("Restored currentWatermark from snapshot to: %s", this.currentWatermark);
        return true;
    }

    @Override
    public boolean closeIsCooperative() {
        return true;
    }

    private void addItem(int ordinal, Windows<A> w, K key, long timestamp, Object item) {
        this.aggrOp.accumulateFn(ordinal).accept(this.resolveAcc(w, key, timestamp), item);
    }

    private Traverser<OUT> earlyWindows(final K key, final Windows<A> w) {
        return new Traverser<OUT>(){
            private int i;

            @Override
            public OUT next() {
                while (this.i < w.size) {
                    Object out = SessionWindowP.this.mapToOutputFn.apply(w.starts[this.i], w.ends[this.i], key, SessionWindowP.this.aggrOp.exportFn().apply(w.accs[this.i]), true);
                    ++this.i;
                    if (out == null) continue;
                    return out;
                }
                return null;
            }
        };
    }

    private List<OUT> closeWindows(Windows<A> w, K key, long wm) {
        int i;
        if (w == null) {
            return Collections.emptyList();
        }
        ArrayList<OUT> results = new ArrayList<OUT>();
        for (i = 0; i < w.size && w.ends[i] < wm; ++i) {
            OUT out = this.mapToOutputFn.apply(w.starts[i], w.ends[i], key, this.aggrOp.finishFn().apply(w.accs[i]), false);
            if (out == null) continue;
            results.add(out);
        }
        if (i != w.size) {
            w.removeHead(i);
        } else {
            this.keyToWindows.remove(key);
            this.totalKeys.set(this.keyToWindows.size());
        }
        return results;
    }

    private A resolveAcc(Windows<A> w, K key, long timestamp) {
        int i;
        long eventEnd = timestamp + this.sessionTimeout;
        for (i = 0; i < w.size && w.starts[i] < eventEnd; ++i) {
            if (w.ends[i] <= timestamp) continue;
            if (w.starts[i] <= timestamp && w.ends[i] >= eventEnd) {
                return w.accs[i];
            }
            if (i + 1 == w.size || w.starts[i + 1] >= eventEnd) {
                w.starts[i] = Math.min(w.starts[i], timestamp);
                if (w.ends[i] < eventEnd) {
                    this.removeFromDeadlines(key, w.ends[i]);
                    w.ends[i] = eventEnd;
                    this.addToDeadlines(key, w.ends[i]);
                }
                return w.accs[i];
            }
            this.removeFromDeadlines(key, w.ends[i]);
            w.ends[i] = w.ends[i + 1];
            this.combineFn.accept(w.accs[i], w.accs[i + 1]);
            w.removeWindow(i + 1);
            return w.accs[i];
        }
        this.addToDeadlines(key, eventEnd);
        return this.insertWindow(w, i, timestamp, eventEnd);
    }

    private A insertWindow(Windows<A> w, int idx, long windowStart, long windowEnd) {
        w.expandIfNeeded();
        w.copy(idx, idx + 1, w.size - idx);
        ++w.size;
        w.starts[idx] = windowStart;
        w.ends[idx] = windowEnd;
        w.accs[idx] = this.aggrOp.createFn().get();
        return w.accs[idx];
    }

    public static class Windows<A>
    implements IdentifiedDataSerializable {
        private int size;
        private long[] starts = new long[2];
        private long[] ends = new long[2];
        private A[] accs = new Object[2];

        private void removeWindow(int idx) {
            --this.size;
            this.copy(idx + 1, idx, this.size - idx);
        }

        private void removeHead(int count) {
            this.copy(count, 0, this.size - count);
            this.size -= count;
        }

        private void copy(int from, int to, int length) {
            System.arraycopy(this.starts, from, this.starts, to, length);
            System.arraycopy(this.ends, from, this.ends, to, length);
            System.arraycopy(this.accs, from, this.accs, to, length);
        }

        private void expandIfNeeded() {
            if (this.size == this.starts.length) {
                this.starts = Arrays.copyOf(this.starts, 2 * this.starts.length);
                this.ends = Arrays.copyOf(this.ends, 2 * this.ends.length);
                this.accs = Arrays.copyOf(this.accs, 2 * this.accs.length);
            }
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 12;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.size);
            for (int i = 0; i < this.size; ++i) {
                out.writeLong(this.starts[i]);
                out.writeLong(this.ends[i]);
                out.writeObject(this.accs[i]);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.size = in.readInt();
            if (this.size > this.starts.length) {
                int newSize = QuickMath.nextPowerOfTwo(this.size);
                this.starts = new long[newSize];
                this.ends = new long[newSize];
                this.accs = new Object[newSize];
            }
            for (int i = 0; i < this.size; ++i) {
                this.starts[i] = in.readLong();
                this.ends[i] = in.readLong();
                this.accs[i] = in.readObject();
            }
        }

        public String toString() {
            StringJoiner sj = new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}");
            for (int i = 0; i < this.size; ++i) {
                sj.add("[s=" + String.valueOf(com.hazelcast.jet.impl.util.Util.toLocalDateTime(this.starts[i]).toLocalTime()) + ", e=" + String.valueOf(com.hazelcast.jet.impl.util.Util.toLocalDateTime(this.ends[i]).toLocalTime()) + ", a=" + String.valueOf(this.accs[i]) + "]");
            }
            return sj.toString();
        }
    }

    static enum Keys {
        CURRENT_WATERMARK;

    }
}

