/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.impl.EnterpriseJetServiceBackend;
import com.hazelcast.jet.impl.EnterpriseSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class ExportSnapshotOperation
extends Operation
implements IdentifiedDataSerializable {
    private long jobId;
    private String name;
    private boolean cancelJob;

    public ExportSnapshotOperation() {
    }

    public ExportSnapshotOperation(long jobId, String name, boolean cancelJob) {
        this.jobId = jobId;
        this.name = name;
        this.cancelJob = cancelJob;
    }

    @Override
    public void run() {
        EnterpriseJetServiceBackend service = (EnterpriseJetServiceBackend)this.getService();
        CompletableFuture<Void> future = service.getJobCoordinationService().exportSnapshot(this.jobId, this.name, this.cancelJob);
        future.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.getLogger(), (r, t) -> this.sendResponse(r != null ? r : t)));
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public final int getFactoryId() {
        return EnterpriseSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeUTF(this.name);
        out.writeBoolean(this.cancelJob);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.name = in.readUTF();
        this.cancelJob = in.readBoolean();
    }
}

