/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.util.IterableUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.JetMemberSelector;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.TopologicalSorter;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DAG
implements IdentifiedDataSerializable,
Iterable<Vertex> {
    private transient boolean locked;
    private final Set<Edge> edges = new LinkedHashSet<Edge>();
    private final Map<String, Vertex> nameToVertex = new HashMap<String, Vertex>();
    private final Set<Vertex> verticesByIdentity = Collections.newSetFromMap(new IdentityHashMap());
    private JetMemberSelector memberSelector;

    @Nonnull
    public Vertex newVertex(@Nonnull String name, @Nonnull SupplierEx<? extends Processor> simpleSupplier) {
        this.throwIfLocked();
        return this.addVertex(new Vertex(name, simpleSupplier));
    }

    @Nonnull
    public Vertex newUniqueVertex(@Nonnull String namePrefix, @Nonnull SupplierEx<? extends Processor> simpleSupplier) {
        this.throwIfLocked();
        return this.addVertex(new Vertex(this.uniqueName(namePrefix), simpleSupplier));
    }

    @Nonnull
    public Vertex newVertex(@Nonnull String name, @Nonnull ProcessorSupplier processorSupplier) {
        this.throwIfLocked();
        return this.addVertex(new Vertex(name, processorSupplier));
    }

    @Nonnull
    public Vertex newUniqueVertex(@Nonnull String namePrefix, @Nonnull ProcessorSupplier processorSupplier) {
        this.throwIfLocked();
        return this.addVertex(new Vertex(this.uniqueName(namePrefix), processorSupplier));
    }

    @Nonnull
    public Vertex newVertex(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier) {
        this.throwIfLocked();
        return this.addVertex(new Vertex(name, metaSupplier));
    }

    @Nonnull
    public Vertex newUniqueVertex(@Nonnull String namePrefix, @Nonnull ProcessorMetaSupplier metaSupplier) {
        this.throwIfLocked();
        return this.addVertex(new Vertex(this.uniqueName(namePrefix), metaSupplier));
    }

    @Nonnull
    public DAG vertex(@Nonnull Vertex vertex) {
        this.throwIfLocked();
        this.addVertex(vertex);
        return this;
    }

    @Nonnull
    public DAG edge(@Nonnull Edge edge) {
        this.throwIfLocked();
        if (edge.getDestination() == null) {
            throw new IllegalArgumentException("Edge has no destination");
        }
        assert (edge.getDestName() != null);
        if (!this.containsVertex(edge.getSource())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getSource()) ? "This DAG has a vertex called '" + edge.getSourceName() + "', but the supplied edge's source is a different vertex with the same name" : "Source vertex '" + edge.getSourceName() + "' is not in this DAG");
        }
        if (!this.containsVertex(edge.getDestination())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getDestination()) ? "This DAG has a vertex called '" + edge.getDestName() + "', but the supplied edge's destination is a different vertex with the same name" : "Destination vertex '" + edge.getDestName() + "' is not in this DAG");
        }
        if (this.getInboundEdges(edge.getDestName()).stream().anyMatch(e -> e.getDestOrdinal() == edge.getDestOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getDestName() + "' already has an inbound edge at ordinal " + edge.getDestOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        if (this.getOutboundEdges(edge.getSourceName()).stream().anyMatch(e -> e.getSourceOrdinal() == edge.getSourceOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getSourceName() + "' already has an outbound edge at ordinal " + edge.getSourceOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        if (edge.getSource() == edge.getDestination()) {
            throw new IllegalArgumentException("Attempted to add an edge from " + edge.getSourceName() + " to itself");
        }
        boolean success = this.edges.add(edge);
        assert (success) : "Duplicate edge added: " + String.valueOf(edge);
        return this;
    }

    @Nonnull
    public List<Edge> getInboundEdges(@Nonnull String vertexName) {
        if (!this.nameToVertex.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> inboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getDestName().equals(vertexName)) continue;
            inboundEdges.add(edge);
        }
        return inboundEdges;
    }

    @Nonnull
    public List<Edge> getOutboundEdges(@Nonnull String vertexName) {
        if (!this.nameToVertex.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> outboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getSourceName().equals(vertexName)) continue;
            outboundEdges.add(edge);
        }
        return outboundEdges;
    }

    @Nullable
    public Vertex getVertex(@Nonnull String vertexName) {
        return this.nameToVertex.get(vertexName);
    }

    @Nonnull
    public Set<Vertex> vertices() {
        return new HashSet<Vertex>(this.verticesByIdentity);
    }

    @Override
    @Nonnull
    public Iterator<Vertex> iterator() {
        return this.validate().iterator();
    }

    @Nonnull
    public Iterator<Edge> edgeIterator() {
        return IterableUtil.asReadOnlyIterator(this.edges.iterator());
    }

    private String uniqueName(String namePrefix) {
        Object name = namePrefix;
        int i = 2;
        while (this.nameToVertex.containsKey(name)) {
            name = namePrefix + "-" + i;
            ++i;
        }
        return name;
    }

    private Vertex addVertex(Vertex vertex) {
        if (this.nameToVertex.containsKey(vertex.getName())) {
            throw new IllegalArgumentException("Vertex " + vertex.getName() + " is already defined.");
        }
        this.verticesByIdentity.add(vertex);
        this.nameToVertex.put(vertex.getName(), vertex);
        return vertex;
    }

    private boolean containsVertex(Vertex vertex) {
        return this.verticesByIdentity.contains(vertex);
    }

    private boolean containsVertexName(Vertex vertex) {
        return this.nameToVertex.containsKey(vertex.getName());
    }

    Iterable<Vertex> validate() {
        Preconditions.checkTrue(!this.nameToVertex.isEmpty(), "DAG must contain at least one vertex");
        Map<String, List<Edge>> inboundEdgeMap = this.edges.stream().collect(Collectors.groupingBy(Edge::getDestName));
        Map<String, List<Edge>> outboundEdgeMap = this.edges.stream().collect(Collectors.groupingBy(Edge::getSourceName));
        DAG.validateInboundEdgeOrdinals(inboundEdgeMap);
        DAG.validateOutboundEdgeOrdinals(outboundEdgeMap);
        HashMap adjacencyMap = new HashMap();
        for (Edge edge : this.edges) {
            adjacencyMap.computeIfAbsent(edge.getSource(), x -> new ArrayList()).add(edge.getDestination());
        }
        for (Vertex v : this.nameToVertex.values()) {
            adjacencyMap.putIfAbsent(v, Collections.emptyList());
        }
        return TopologicalSorter.topologicalSort(adjacencyMap, Vertex::getName);
    }

    private static void validateInboundEdgeOrdinals(Map<String, List<Edge>> inboundEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : inboundEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getDestOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Input ordinals for vertex " + vertex + " are not properly numbered. Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    private static void validateOutboundEdgeOrdinals(Map<String, List<Edge>> outboundEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : outboundEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getSourceOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Output ordinals for vertex " + vertex + " are not ordered. Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    @Nonnull
    public String toString() {
        return this.toString(-1);
    }

    @Nonnull
    public String toString(int defaultLocalParallelism) {
        StringBuilder b = new StringBuilder("dag\n");
        for (Vertex v : this) {
            b.append("    .vertex(\"").append(v.getName()).append("\")");
            int localParallelism = v.determineLocalParallelism(defaultLocalParallelism);
            if (localParallelism != -1) {
                b.append(".localParallelism(").append(localParallelism).append(')');
            }
            b.append('\n');
        }
        for (Edge e : this.edges) {
            b.append("    .edge(").append(e).append(")\n");
        }
        return b.toString();
    }

    @Nonnull
    public JsonObject toJson(int defaultLocalParallelism) {
        JsonObject dag = new JsonObject();
        JsonArray vertices = new JsonArray();
        for (Vertex v : this) {
            JsonObject vertex = new JsonObject();
            vertex.add("name", v.getName());
            vertex.add("parallelism", v.determineLocalParallelism(defaultLocalParallelism));
            vertices.add(vertex);
        }
        dag.add("vertices", vertices);
        JsonArray edges = new JsonArray();
        for (Edge e : this.edges) {
            JsonObject edge = new JsonObject();
            edge.add("from", e.getSourceName());
            edge.add("fromOrdinal", e.getSourceOrdinal());
            edge.add("to", e.getDestName());
            edge.add("toOrdinal", e.getDestOrdinal());
            edge.add("priority", e.getPriority());
            edge.add("distributedTo", String.valueOf(e.getDistributedTo()));
            edge.add("type", StringUtil.lowerCaseInternal(e.getRoutingPolicy().toString()));
            edges.add(edge);
        }
        dag.add("edges", edges);
        return dag;
    }

    @Nonnull
    public String toDotString() {
        return this.toDotString(-1, 1024);
    }

    @Nonnull
    public String toDotString(int defaultLocalParallelism, int defaultQueueSize) {
        StringBuilder builder = new StringBuilder(512);
        builder.append("digraph DAG {\n");
        int clusterCount = 0;
        for (Vertex v2 : this) {
            int localParallelism = v2.determineLocalParallelism(defaultLocalParallelism);
            String parallelism = localParallelism == -1 ? (defaultLocalParallelism == -1 ? "default" : String.valueOf(defaultLocalParallelism)) : String.valueOf(localParallelism);
            builder.append("\t\"").append(Util.escapeGraphviz(v2.getName())).append("\" [localParallelism=").append(parallelism).append("]").append(";\n");
        }
        HashMap<String, int[]> inOutCounts = new HashMap<String, int[]>();
        for (Edge edge : this.edges) {
            int[] nArray = inOutCounts.computeIfAbsent(edge.getSourceName(), v -> new int[2]);
            nArray[0] = nArray[0] + 1;
            int[] nArray2 = inOutCounts.computeIfAbsent(edge.getDestName(), v -> new int[2]);
            nArray2[1] = nArray2[1] + 1;
        }
        for (Vertex v3 : this) {
            List<Edge> out = this.getOutboundEdges(v3.getName());
            for (Edge e : out) {
                ArrayList<CallSite> attributes = new ArrayList<CallSite>();
                String edgeLabel = this.getEdgeLabel(e);
                if (!StringUtil.isNullOrEmpty(edgeLabel)) {
                    attributes.add((CallSite)((Object)("label=\"" + edgeLabel + "\"")));
                }
                if (((int[])inOutCounts.get(e.getDestName()))[1] > 1) {
                    attributes.add((CallSite)((Object)("headlabel=" + e.getDestOrdinal())));
                }
                if (((int[])inOutCounts.get(e.getSourceName()))[0] > 1) {
                    attributes.add((CallSite)((Object)("taillabel=" + e.getSourceOrdinal())));
                }
                int queueSize = e.getConfig() == null ? defaultQueueSize : e.getConfig().getQueueSize();
                attributes.add((CallSite)((Object)("queueSize=" + queueSize)));
                boolean inSubgraph = e.getSourceName().equals(e.getDestName() + "-prepare");
                if (inSubgraph) {
                    builder.append("\tsubgraph cluster_").append(clusterCount++).append(" {\n").append("\t");
                }
                String source = Util.escapeGraphviz(e.getSourceName());
                String destination = Util.escapeGraphviz(e.getDestName());
                builder.append("\t").append("\"").append(source).append("\"").append(" -> ").append("\"").append(destination).append("\"");
                if (!attributes.isEmpty()) {
                    builder.append(attributes.stream().collect(Collectors.joining(", ", " [", "]")));
                }
                builder.append(";\n");
                if (!inSubgraph) continue;
                builder.append("\t}\n");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    private String getEdgeLabel(Edge e) {
        ArrayList<Object> labels = new ArrayList<Object>();
        if (Edge.DISTRIBUTE_TO_ALL.equals(e.getDistributedTo())) {
            labels.add("distributed");
        } else if (e.getDistributedTo() != null) {
            labels.add("distributed to " + String.valueOf(e.getDistributedTo()));
        }
        if (e.getRoutingPolicy() != Edge.RoutingPolicy.UNICAST) {
            labels.add(StringUtil.lowerCaseInternal(e.getRoutingPolicy().toString()));
        }
        if (e.getOrderComparator() != null) {
            labels.add("ordered");
        }
        return String.join((CharSequence)"-", labels);
    }

    public JetMemberSelector memberSelector() {
        return this.memberSelector;
    }

    public void setMemberSelector(JetMemberSelector memberSelector) {
        this.memberSelector = memberSelector;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.nameToVertex.size());
        for (Map.Entry<String, Vertex> entry : this.nameToVertex.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.edges.size());
        for (Edge edge : this.edges) {
            out.writeObject(edge);
        }
        out.writeObject(this.memberSelector);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int vertexCount = in.readInt();
        for (int i = 0; i < vertexCount; ++i) {
            String key = (String)in.readObject();
            Vertex value = (Vertex)in.readObject();
            this.nameToVertex.put(key, value);
        }
        int edgeCount = in.readInt();
        for (int i = 0; i < edgeCount; ++i) {
            Edge edge = (Edge)in.readObject();
            edge.restoreSourceAndDest(this.nameToVertex);
            this.edges.add(edge);
        }
        this.verticesByIdentity.addAll(this.nameToVertex.values());
        try {
            this.memberSelector = (JetMemberSelector)in.readObject();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public int getFactoryId() {
        return JetDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    private void throwIfLocked() {
        if (this.locked) {
            throw new IllegalStateException("DAG is already locked");
        }
    }

    @PrivateApi
    public void lock() {
        this.locked = true;
        this.verticesByIdentity.forEach(Vertex::lock);
        this.edges.forEach(Edge::lock);
    }
}

