/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.service.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.tstore.compaction.CompactionStats;
import com.hazelcast.internal.tstore.compaction.ToHumanReadable;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TieredStoreConfigValidator {
    private TieredStoreConfigValidator() {
    }

    static void validate(Config config, HazelcastProperties properties, NamedConfig ... configs) {
        TieredStoreConfigValidator.validateMemoryManagerConfig(config);
        TieredStoreConfigValidator.validateTieredStoreConfig(config, properties, configs);
        TieredStoreConfigValidator.validateLocalDevices(config);
        TieredStoreConfigValidator.validateHybridLogConfig(config, properties);
    }

    private static void validateMemoryManagerConfig(Config config) {
        long nativeSize;
        Map<String, Long> deviceNameToDeviceDiskCapacity = config.getDeviceConfigs().values().stream().collect(Collectors.toMap(NamedConfig::getName, dc -> dc.getCapacity().bytes()));
        Optional<MapConfig> suspect = config.getMapConfigs().values().stream().filter(cfg -> cfg.getTieredStoreConfig().isEnabled()).filter(cfg -> {
            String deviceName = cfg.getTieredStoreConfig().getDiskTierConfig().getDeviceName();
            Long diskCapacity = (Long)deviceNameToDeviceDiskCapacity.get(deviceName);
            if (diskCapacity != null) {
                long ramCapacity = cfg.getTieredStoreConfig().getMemoryTierConfig().getCapacity().bytes();
                return diskCapacity <= ramCapacity;
            }
            return false;
        }).findFirst();
        if (suspect.isPresent()) {
            throw new InvalidConfigurationException("The cluster failed to start because the configured Tiered Storage in-memory tier is larger than the disk tier");
        }
        NativeMemoryConfig nativeMemoryConfig = config.getNativeMemoryConfig();
        if (!nativeMemoryConfig.isEnabled()) {
            throw new InvalidConfigurationException("Native memory must be enabled to use tiered store");
        }
        long mapSize = config.getMapConfigs().values().stream().filter(m -> m.getTieredStoreConfig().isEnabled()).mapToLong(m -> m.getTieredStoreConfig().getMemoryTierConfig().getCapacity().bytes()).sum();
        if (mapSize > (nativeSize = config.getNativeMemoryConfig().getCapacity().bytes())) {
            throw new InvalidConfigurationException("Native memory size must be higher than sum of all memory tier size");
        }
    }

    private static void validateHybridLogConfig(Config config, HazelcastProperties properties) {
        long nativeSize;
        long pageSize;
        long minimumPages;
        long partitionCount;
        long indexCount;
        long mapCount = config.getMapConfigs().values().stream().filter(m -> m.getTieredStoreConfig().isEnabled()).count();
        long total = (mapCount + (indexCount = config.getMapConfigs().values().stream().filter(m -> m.getTieredStoreConfig().isEnabled()).mapToLong(m -> m.getIndexConfigs().size()).sum())) * (partitionCount = (long)properties.getInteger(ClusterProperty.PARTITION_COUNT)) * (minimumPages = 4L) * (pageSize = MemoryUnit.MEGABYTES.toBytes(properties.getInteger(ClusterProperty.TIERED_STORE_HYBRID_LOG_PAGE_SIZE_IN_MEGABYTES)));
        if (total > (nativeSize = config.getNativeMemoryConfig().getCapacity().bytes())) {
            throw new InvalidConfigurationException(String.format("Insufficient native memory for tiered store, required minimum is %d bytes(%s), got %d bytes(%s)", total, ToHumanReadable.bytesToString(total), nativeSize, ToHumanReadable.bytesToString(nativeSize)));
        }
    }

    private static void validateTieredStoreConfig(Config config, HazelcastProperties properties, NamedConfig ... configs) {
        Stream.concat(config.getMapConfigs().values().stream(), Arrays.stream(configs).filter(MapConfig.class::isInstance).map(MapConfig.class::cast)).forEach(mapConfig -> ConfigValidator.checkTieredStoreMapConfig(config, mapConfig));
        TieredStoreConfigValidator.checkHybridLogConfig(properties);
    }

    private static void checkHybridLogConfig(HazelcastProperties properties) {
        int pageSizeInMB = properties.getInteger(ClusterProperty.TIERED_STORE_HYBRID_LOG_PAGE_SIZE_IN_MEGABYTES);
        long pageSize = MemoryUnit.MEGABYTES.toBytes(pageSizeInMB);
        int minBound = 1;
        int maxBound = 16;
        if (pageSizeInMB < minBound || pageSizeInMB > maxBound || !QuickMath.isPowerOfTwo(pageSize)) {
            throw new InvalidConfigurationException(String.format("Illegal hybrid log page size %s. Page size must be a power of two and in range [1MB, 16MB]", ToHumanReadable.bytesToString(pageSize)));
        }
        long maxLogFileSizeInBytes = MemoryUnit.MEGABYTES.toBytes(properties.getLong(CompactionStats.MAX_LOG_FILE_SIZE_IN_MB));
        if (pageSize > maxLogFileSizeInBytes || maxLogFileSizeInBytes % pageSize != 0L) {
            throw new InvalidConfigurationException(String.format("Hybrid log page size %s must be a multiplication of device segment size %s and must be equal or smaller than device segment size.", ToHumanReadable.bytesToString(pageSize), ToHumanReadable.bytesToString(maxLogFileSizeInBytes)));
        }
    }

    private static void validateLocalDevices(Config config) {
        Collection<DeviceConfig> values = config.getDeviceConfigs().values();
        values.stream().filter(DeviceConfig::isLocal).forEach(TieredStoreConfigValidator::validateLocalDevice);
        if (values.isEmpty()) {
            throw new InvalidConfigurationException("There must be at least one device configured to enable tiered storage.");
        }
    }

    private static void validateLocalDevice(DeviceConfig deviceConfig) {
        assert (deviceConfig.isLocal());
        LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)deviceConfig;
        File baseDir = localDeviceConfig.getBaseDir();
        if (!baseDir.exists()) {
            DirectoryCheck directoryCheck = TieredStoreConfigValidator.canBeCreated(baseDir);
            if (directoryCheck.canBeCreated()) {
                return;
            }
            throw new InvalidConfigurationException(String.format("The configured base directory '%s' for the device '%s' does not exist and cannot be created. The last existing path is '%s' and it is read-only", baseDir.getAbsolutePath(), localDeviceConfig.getName(), directoryCheck.lastExistingDirectory()));
        }
        if (!baseDir.isDirectory()) {
            throw new InvalidConfigurationException(String.format("The configured base directory '%s' for the device '%s' is not a directory", baseDir.getAbsolutePath(), localDeviceConfig.getName()));
        }
        if (!baseDir.canRead()) {
            throw new InvalidConfigurationException(String.format("The configured base directory '%s' for the device '%s' is not readable", baseDir.getAbsolutePath(), localDeviceConfig.getName()));
        }
        if (!baseDir.canWrite()) {
            throw new InvalidConfigurationException(String.format("The configured base directory '%s' for the device '%s' is read-only", baseDir.getAbsolutePath(), localDeviceConfig.getName()));
        }
    }

    private static DirectoryCheck canBeCreated(File baseDir) {
        Path completePath = Paths.get(baseDir.getAbsolutePath(), new String[0]);
        boolean stop = false;
        Path testedPath = completePath.getRoot();
        Iterator<Path> it = completePath.iterator();
        while (it.hasNext() && !stop) {
            stop = !(testedPath = testedPath.resolve(it.next())).toFile().exists();
        }
        return new DirectoryCheck(testedPath);
    }

    private record DirectoryCheck(Path lastTestedPath) {
        private boolean canBeCreated() {
            return this.lastTestedPath.getParent().toFile().canWrite();
        }

        private String lastExistingDirectory() {
            return this.lastTestedPath.getParent().toString();
        }
    }
}

