/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

enum PageState {
    NOT_BACKED,
    PREPARING,
    READY,
    ACTIVATING,
    ACTIVE,
    READONLY,
    FLUSHING,
    FLUSHED,
    MARKING_RELEASABLE,
    RELEASABLE,
    RELEASING,
    PINNED_ACTIVE,
    PINNED_READONLY,
    PINNED_FLUSHING,
    PINNED_FLUSHED,
    PINNED_MARKING_DETACHABLE,
    PINNED_DETACHABLE,
    PINNED_DETACHING,
    PINNED_DETACHED,
    PINNED_FOR_UPDATE,
    DETACHABLE,
    DETACHING,
    DETACHED,
    MARKING_RELEASABLE_DETACHED,
    RELEASABLE_DETACHED,
    RELEASING_DETACHED;

    private PageState[] allowedPreviousStates;
    private PageState pinVariantState;
    private final boolean pinnedState = this.name().startsWith("PINNED_");
    private final boolean detachState = this.name().contains("DETACH");
    private final boolean detachedState = this.name().contains("DETACHED");
    private boolean syncState;

    PageState[] allowedPreviousStates() {
        return this.allowedPreviousStates;
    }

    boolean isPinnedState() {
        return this.pinnedState;
    }

    boolean isDetachState() {
        return this.detachState;
    }

    boolean isDetachedState() {
        return this.detachedState;
    }

    public boolean isSyncState() {
        return this.syncState;
    }

    PageState pinVariantState() {
        return this.pinVariantState;
    }

    static {
        PageState.NOT_BACKED.allowedPreviousStates = new PageState[]{RELEASING, RELEASING_DETACHED};
        PageState.PREPARING.allowedPreviousStates = new PageState[]{NOT_BACKED};
        PageState.READY.allowedPreviousStates = new PageState[]{PREPARING};
        PageState.ACTIVATING.allowedPreviousStates = new PageState[]{READY};
        PageState.ACTIVE.allowedPreviousStates = new PageState[]{ACTIVATING, PINNED_ACTIVE, PINNED_FOR_UPDATE};
        PageState.READONLY.allowedPreviousStates = new PageState[]{ACTIVE, PINNED_READONLY};
        PageState.FLUSHING.allowedPreviousStates = new PageState[]{READONLY, PINNED_FLUSHING};
        PageState.FLUSHED.allowedPreviousStates = new PageState[]{FLUSHING, PINNED_FLUSHED};
        PageState.MARKING_RELEASABLE.allowedPreviousStates = new PageState[]{FLUSHED};
        PageState.RELEASABLE.allowedPreviousStates = new PageState[]{MARKING_RELEASABLE};
        PageState.RELEASING.allowedPreviousStates = new PageState[]{RELEASABLE};
        PageState.PINNED_ACTIVE.allowedPreviousStates = new PageState[]{ACTIVE, PINNED_FOR_UPDATE};
        PageState.PINNED_READONLY.allowedPreviousStates = new PageState[]{READONLY, PINNED_ACTIVE};
        PageState.PINNED_FLUSHING.allowedPreviousStates = new PageState[]{FLUSHING, PINNED_READONLY};
        PageState.PINNED_FLUSHED.allowedPreviousStates = new PageState[]{FLUSHED, PINNED_FLUSHING};
        PageState.PINNED_MARKING_DETACHABLE.allowedPreviousStates = new PageState[]{PINNED_FLUSHED};
        PageState.PINNED_DETACHABLE.allowedPreviousStates = new PageState[]{RELEASABLE, PINNED_MARKING_DETACHABLE, DETACHABLE};
        PageState.PINNED_DETACHING.allowedPreviousStates = new PageState[]{PINNED_DETACHABLE};
        PageState.PINNED_DETACHED.allowedPreviousStates = new PageState[]{PINNED_DETACHING, DETACHED, RELEASABLE_DETACHED};
        PageState.DETACHABLE.allowedPreviousStates = new PageState[]{PINNED_DETACHABLE};
        PageState.DETACHING.allowedPreviousStates = new PageState[]{DETACHABLE};
        PageState.DETACHED.allowedPreviousStates = new PageState[]{DETACHING, PINNED_DETACHED};
        PageState.MARKING_RELEASABLE_DETACHED.allowedPreviousStates = new PageState[]{DETACHED};
        PageState.RELEASABLE_DETACHED.allowedPreviousStates = new PageState[]{MARKING_RELEASABLE_DETACHED};
        PageState.RELEASING_DETACHED.allowedPreviousStates = new PageState[]{RELEASABLE_DETACHED};
        PageState.PINNED_FOR_UPDATE.allowedPreviousStates = new PageState[]{ACTIVE, PINNED_ACTIVE};
        PageState.ACTIVE.pinVariantState = PINNED_ACTIVE;
        PageState.READONLY.pinVariantState = PINNED_READONLY;
        PageState.FLUSHING.pinVariantState = PINNED_FLUSHING;
        PageState.FLUSHED.pinVariantState = PINNED_FLUSHED;
        PageState.RELEASABLE.pinVariantState = PINNED_DETACHABLE;
        PageState.RELEASABLE_DETACHED.pinVariantState = PINNED_DETACHED;
        PageState.PINNED_ACTIVE.pinVariantState = ACTIVE;
        PageState.PINNED_FOR_UPDATE.pinVariantState = ACTIVE;
        PageState.PINNED_READONLY.pinVariantState = READONLY;
        PageState.PINNED_FLUSHING.pinVariantState = FLUSHING;
        PageState.PINNED_FLUSHED.pinVariantState = FLUSHED;
        PageState.PINNED_DETACHABLE.pinVariantState = DETACHABLE;
        PageState.PINNED_DETACHED.pinVariantState = DETACHED;
        PageState.DETACHABLE.pinVariantState = PINNED_DETACHABLE;
        PageState.DETACHED.pinVariantState = PINNED_DETACHED;
        PageState.PREPARING.syncState = true;
        PageState.ACTIVATING.syncState = true;
        PageState.MARKING_RELEASABLE.syncState = true;
        PageState.RELEASING.syncState = true;
        PageState.PINNED_MARKING_DETACHABLE.syncState = true;
        PageState.PINNED_DETACHING.syncState = true;
        PageState.DETACHING.syncState = true;
        PageState.MARKING_RELEASABLE_DETACHED.syncState = true;
        PageState.RELEASING_DETACHED.syncState = true;
    }
}

