/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.tstore.hybridlog.impl.PagePool;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryAllocatorWrapperPagePool
implements PagePool {
    private final MemoryAllocator allocator;
    private final int pageSize;
    private final Set<Long> allocatedBlocks;
    private final AtomicLong consumption;
    private final String allocatorSimpleName;

    public MemoryAllocatorWrapperPagePool(MemoryAllocator allocator, int pageSize) {
        this.allocator = allocator;
        this.pageSize = pageSize;
        this.allocatedBlocks = Collections.newSetFromMap(new ConcurrentHashMap());
        this.consumption = new AtomicLong();
        this.allocatorSimpleName = allocator.getClass().getSimpleName();
    }

    @Override
    public long acquire() {
        long block = this.allocator.allocate(this.pageSize);
        this.allocatedBlocks.add(block);
        this.consumption.addAndGet(this.pageSize);
        return block;
    }

    @Override
    public void release(long pageAddress) {
        this.allocator.free(pageAddress, this.pageSize);
        this.allocatedBlocks.remove(pageAddress);
        this.consumption.addAndGet(-this.pageSize);
    }

    @Override
    public void close() {
    }

    @Override
    public long nativeMemoryConsumptionBytes() {
        return this.consumption.get();
    }

    @Override
    public String debugInfo() {
        return "PagePool\n" + "\t\t - Memory allocator: " + this.allocatorSimpleName + '\n' + "\t\t - Page size: " + this.pageSize + " bytes" + '\n' + "\t\t - Native memory consumption: " + this.nativeMemoryConsumptionBytes() + " bytes" + '\n';
    }
}

