/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import com.hazelcast.internal.tstore.device.ImmutableOperation;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import java.io.IOException;
import java.io.RandomAccessFile;

final class ReadOperation
extends ImmutableOperation {
    private final long logicalAddress;
    private final int readLength;

    ReadOperation(int storeId, Device device, long logicalAddress, int readLength) {
        super(device);
        this.logicalAddress = logicalAddress;
        this.readLength = readLength;
    }

    LocalStorageDevice getDevice() {
        return (LocalStorageDevice)this.device;
    }

    @Override
    public byte[] run(byte[] context) {
        return ReadOperation.run0(this.getDevice(), context, this.logicalAddress, this.readLength);
    }

    static byte[] run0(LocalStorageDevice device, byte[] context, long logicalAddress, int readLength) {
        int bytes;
        long filePos = device.getLogFileOffsetFromLogicalAddress(logicalAddress);
        HybridLogFileHandlePool handlePool = device.getHandlePool();
        int deviceId = device.getDeviceId();
        HybridLogFileHandleProvider hybridLogHandleProvider = device.getHandleProvider();
        int fileNo = device.segmentNoOf(logicalAddress);
        HybridLogFileHandle handle = handlePool.getHandle(deviceId, fileNo, hybridLogHandleProvider);
        byte[] buf = context;
        assert (buf.length == readLength);
        RandomAccessFile raf = handle.getRaf();
        try {
            raf.seek(filePos);
            bytes = raf.read(buf);
        }
        catch (IOException ioe) {
            throw new DeviceException(ioe);
        }
        finally {
            handlePool.releaseHandle(handle);
        }
        if (bytes < buf.length) {
            throw new DeviceException(String.format("Cannot read from device `%s`. The total number of bytes read: expected=%d, actual=%d", device.deviceName(), buf.length, bytes));
        }
        return buf;
    }

    @Override
    public int getReadLength() {
        return this.readLength;
    }

    @Override
    public String toString() {
        return "ReadOperation(" + this.device.deviceName() + ", " + this.logicalAddress + ", " + this.readLength + ")";
    }
}

