/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.compaction.CompactorFlags;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Predicate;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class CompactorFileQueue {
    static final AtomicLongFieldUpdater<CompactorFileQueue> TOTAL_PARTITION_GARBAGE_IN_BYTES = AtomicLongFieldUpdater.newUpdater(CompactorFileQueue.class, "partitionGarbageInBytes");
    private final long compactionFreeGarbageAmount;
    private final long maxLogFileSizeInBytes;
    private final ILogger logger;
    private final Predicate isSegmentOnDevice;
    private final CompactorFlags compactorFlags;
    private final ConcurrentMap<Integer, Garbage> garbageByFileNo;
    private volatile long partitionGarbageInBytes;

    CompactorFileQueue(long maxLogFileSizeInBytes, Predicate<Integer> isSegmentOnDevice, CompactorFlags compactorFlags, HazelcastProperties properties, ILogger logger) {
        this.logger = logger;
        this.compactorFlags = compactorFlags;
        this.isSegmentOnDevice = isSegmentOnDevice;
        this.garbageByFileNo = new ConcurrentHashMap<Integer, Garbage>();
        this.maxLogFileSizeInBytes = maxLogFileSizeInBytes;
        this.compactionFreeGarbageAmount = MemoryUnit.MEGABYTES.toBytes(properties.getLong(new HazelcastProperty("hazelcast.tiered.store.partition.compactor.gc.threshold.per.map.partition.in.mb", MemoryUnit.BYTES.toMegaBytes(maxLogFileSizeInBytes))));
    }

    public long getPartitionGarbageInBytes() {
        return this.partitionGarbageInBytes;
    }

    public ConcurrentMap<Integer, Garbage> getGarbageByFileNo() {
        return this.garbageByFileNo;
    }

    void addToTotalGarbage(long amount) {
        TOTAL_PARTITION_GARBAGE_IN_BYTES.addAndGet(this, amount);
        Invariants.nonNegative(this.partitionGarbageInBytes);
    }

    void add(int fileNo) {
        this.garbageByFileNo.compute(fileNo, (file, currentGarbage) -> {
            currentGarbage = currentGarbage == null ? new Garbage(true) : currentGarbage;
            currentGarbage.canBeCompacted = true;
            this.addToTotalGarbage(currentGarbage.amount);
            return currentGarbage;
        });
    }

    boolean increaseFilesGarbage(int fileNo, long newGarbageInBytes) {
        Garbage garbage = this.garbageByFileNo.compute(fileNo, (file, currentGarbage) -> {
            currentGarbage = currentGarbage == null ? new Garbage(false) : currentGarbage;
            long currentGarbageInBytes = currentGarbage.amount;
            long nextGarbageInBytes = currentGarbageInBytes + newGarbageInBytes;
            currentGarbage.amount = nextGarbageInBytes = nextGarbageInBytes < 0L ? Long.MAX_VALUE : nextGarbageInBytes;
            if (currentGarbage.canBeCompacted) {
                this.addToTotalGarbage(newGarbageInBytes);
            }
            return currentGarbage;
        });
        return garbage.canBeCompacted && garbage.amount >= this.maxLogFileSizeInBytes / 2L;
    }

    Integer poll() {
        return this.pollOrPeek(true);
    }

    Integer peek() {
        return this.pollOrPeek(false);
    }

    private Integer pollOrPeek(boolean poll) {
        Invariants.nonNegative(this.partitionGarbageInBytes);
        if (this.garbageByFileNo.isEmpty()) {
            return null;
        }
        Optional<Map.Entry> first = this.garbageByFileNo.entrySet().stream().filter(entry -> this.isSegmentOnDevice.test(entry.getKey())).filter(entry -> {
            Garbage garbage = (Garbage)entry.getValue();
            return garbage.canBeCompacted && !garbage.nowCompacting;
        }).min(CompactorFileQueue::sortFilesByGarbageDesc);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Dump of garbage file registry=" + String.valueOf(this.garbageByFileNo));
        }
        if (first.isEmpty()) {
            return null;
        }
        Map.Entry entry2 = first.get();
        int segmentNo = (Integer)entry2.getKey();
        if (poll) {
            if (this.compactorFlags.isPartitionCompactorEnabled()) {
                Garbage existingGarbage = this.garbageByFileNo.computeIfPresent(segmentNo, (segment, garbage) -> {
                    garbage.nowCompacting = true;
                    return garbage;
                });
                assert (existingGarbage != null);
            } else {
                Garbage removed = (Garbage)this.garbageByFileNo.remove(segmentNo);
                this.addToTotalGarbage(-removed.amount);
            }
        }
        return segmentNo;
    }

    public void onSegmentCompacted(int fileNo) {
        if (!this.compactorFlags.isPartitionCompactorEnabled()) {
            return;
        }
        Garbage removed = (Garbage)this.garbageByFileNo.remove(fileNo);
        assert (removed != null && removed.nowCompacting && removed.canBeCompacted);
        this.addToTotalGarbage(-removed.amount);
    }

    public boolean isOverPartitionsCompactionFreeThreshold() {
        return this.partitionGarbageInBytes >= this.compactionFreeGarbageAmount;
    }

    private static int sortFilesByGarbageDesc(Map.Entry<Integer, Garbage> file1, Map.Entry<Integer, Garbage> file2) {
        int garbageComparisonResult = Long.compare(file1.getValue().amount, file2.getValue().amount);
        if (garbageComparisonResult == 0) {
            return Integer.compare(file1.getKey(), file2.getKey());
        }
        return -garbageComparisonResult;
    }

    public String toString() {
        return "CompactorFileQueue{gcThresholdInBytes=" + this.compactionFreeGarbageAmount + ", maxLogFileSizeInBytes=" + this.maxLogFileSizeInBytes + ", garbageByFileNo=" + String.valueOf(this.garbageByFileNo) + ", totalGarbageInBytes=" + this.partitionGarbageInBytes + "}";
    }

    public static final class Garbage {
        long amount;
        boolean nowCompacting;
        boolean canBeCompacted;

        private Garbage(boolean canBeCompacted) {
            this.canBeCompacted = canBeCompacted;
        }

        public String toString() {
            return "Garbage{amount=" + this.amount + ", nowCompacting=" + this.nowCompacting + ", canBeCompacted=" + this.canBeCompacted + "}";
        }
    }
}

