/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.memory.MemoryUnit;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public final class ToHumanReadable {
    private static final int DECIMAL_SCALE = 100;

    private ToHumanReadable() {
    }

    public static String bytesToString(long bytes) {
        int scaledValue;
        double capacity = Bytes.toGigaBytes(bytes);
        String abbreviation = MemoryUnit.GIGABYTES.abbreviation();
        if (capacity < 1.0) {
            capacity = Bytes.toMegaBytes(bytes);
            abbreviation = MemoryUnit.MEGABYTES.abbreviation();
            if (capacity < 1.0) {
                capacity = Bytes.toKiloBytes(bytes);
                abbreviation = MemoryUnit.KILOBYTES.abbreviation();
                if (capacity < 1.0) {
                    capacity = bytes;
                    abbreviation = MemoryUnit.BYTES.abbreviation();
                }
            }
        }
        if ((scaledValue = (int)(capacity * 100.0)) % 100 == 0) {
            return (int)capacity + abbreviation;
        }
        return capacity + abbreviation;
    }

    public static String nanosToString(long nanos) {
        long elapsed = TimeUnit.NANOSECONDS.toSeconds(nanos);
        String abbreviation = "s";
        if (elapsed == 0L) {
            elapsed = TimeUnit.NANOSECONDS.toMillis(nanos);
            abbreviation = "ms";
            if (elapsed == 0L) {
                elapsed = TimeUnit.NANOSECONDS.toMicros(nanos);
                abbreviation = "\u00b5s";
                if (elapsed == 0L) {
                    elapsed = nanos;
                    abbreviation = "ns";
                }
            }
        }
        return elapsed + abbreviation;
    }

    private static class Bytes {
        private static final double KB = 1024.0;
        private static final double MB = 1048576.0;
        private static final double GB = 1.073741824E9;

        private Bytes() {
        }

        private static double toKiloBytes(long bytes) {
            return Bytes.roundToTwoDecimals((double)bytes / 1024.0);
        }

        private static double toMegaBytes(long bytes) {
            return Bytes.roundToTwoDecimals((double)bytes / 1048576.0);
        }

        private static double toGigaBytes(long bytes) {
            return Bytes.roundToTwoDecimals((double)bytes / 1.073741824E9);
        }

        private static double roundToTwoDecimals(double value) {
            DecimalFormat df = new DecimalFormat("#.##");
            String format = df.format(value);
            return Double.parseDouble(format);
        }
    }
}

