/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.TStoreException;
import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.internal.tstore.device.Device;
import java.util.concurrent.atomic.AtomicLong;

public abstract class InterruptableCompactor<T>
implements Compactor<T> {
    protected final Device device;
    private volatile boolean interrupted;
    private final AtomicLong registrationId = new AtomicLong(-1L);

    public InterruptableCompactor(Device device) {
        this.device = device;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void failIfInterrupted() {
        if (this.isInterrupted()) {
            throw new TStoreException("Compactor is interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register() {
        AtomicLong atomicLong = this.registrationId;
        synchronized (atomicLong) {
            if (this.registrationId.get() != -1L) {
                throw new TStoreException("Calling register() on already-registered Compactor");
            }
            this.registrationId.set(this.device.registerCompactor(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregister() {
        AtomicLong atomicLong = this.registrationId;
        synchronized (atomicLong) {
            long regId = this.registrationId.get();
            if (regId < 0L) {
                throw new TStoreException("Calling deregister() on not-registered Compactor");
            }
            this.device.deregisterCompactor(regId);
            this.registrationId.set(-1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegistered() {
        AtomicLong atomicLong = this.registrationId;
        synchronized (atomicLong) {
            return this.registrationId.get() >= 0L;
        }
    }
}

