/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.nio.ascii.TextChannelInitializer;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.ClientChannelInitializer;
import com.hazelcast.internal.server.tcp.MemberChannelInitializer;
import com.hazelcast.internal.server.tcp.UnifiedChannelInitializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ChannelInitializerFunction
implements Function<EndpointQualifier, ChannelInitializer> {
    protected final ServerContext serverContext;
    private final ChannelInitializer uniChannelInitializer;
    private final Config config;
    private volatile Map<EndpointQualifier, ChannelInitializer> initializerMap;

    public ChannelInitializerFunction(ServerContext serverContext, Config config) {
        this.checkSslConfigAvailability(config);
        this.serverContext = serverContext;
        this.uniChannelInitializer = new UnifiedChannelInitializer(serverContext);
        this.config = config;
    }

    @Override
    public ChannelInitializer apply(EndpointQualifier qualifier) {
        return this.initializerMap.isEmpty() ? this.provideUnifiedChannelInitializer() : this.initializerMap.get(qualifier);
    }

    public void init() {
        AdvancedNetworkConfig advancedNetworkConfig = this.config.getAdvancedNetworkConfig();
        if (!advancedNetworkConfig.isEnabled() || advancedNetworkConfig.getEndpointConfigs().isEmpty()) {
            this.initializerMap = Collections.emptyMap();
            return;
        }
        HashMap<EndpointQualifier, ChannelInitializer> map = new HashMap<EndpointQualifier, ChannelInitializer>();
        block7: for (EndpointConfig endpointConfig : advancedNetworkConfig.getEndpointConfigs().values()) {
            this.checkSslConfigAvailability(endpointConfig.getSSLConfig());
            switch (endpointConfig.getProtocolType()) {
                case MEMBER: {
                    map.put(EndpointQualifier.MEMBER, this.provideMemberChannelInitializer(endpointConfig));
                    continue block7;
                }
                case CLIENT: {
                    map.put(EndpointQualifier.CLIENT, this.provideClientChannelInitializer(endpointConfig));
                    continue block7;
                }
                case REST: {
                    map.put(EndpointQualifier.REST, this.provideTextChannelInitializer(endpointConfig, true));
                    continue block7;
                }
                case MEMCACHE: {
                    map.put(EndpointQualifier.MEMCACHE, this.provideTextChannelInitializer(endpointConfig, false));
                    continue block7;
                }
                case WAN: {
                    map.put(endpointConfig.getQualifier(), this.provideMemberChannelInitializer(endpointConfig));
                    continue block7;
                }
            }
            throw new IllegalStateException("Cannot build channel initializer for protocol type " + String.valueOf((Object)endpointConfig.getProtocolType()));
        }
        this.initializerMap = map;
    }

    protected ChannelInitializer provideUnifiedChannelInitializer() {
        return this.uniChannelInitializer;
    }

    protected ChannelInitializer provideMemberChannelInitializer(EndpointConfig endpointConfig) {
        return new MemberChannelInitializer(this.serverContext, endpointConfig);
    }

    protected ChannelInitializer provideClientChannelInitializer(EndpointConfig endpointConfig) {
        return new ClientChannelInitializer(this.serverContext, endpointConfig);
    }

    protected ChannelInitializer provideTextChannelInitializer(EndpointConfig endpointConfig, boolean rest) {
        return new TextChannelInitializer(this.serverContext, endpointConfig, rest);
    }

    protected ChannelInitializer provideWanChannelInitializer(EndpointConfig endpointConfig) {
        throw new UnsupportedOperationException("TODO");
    }

    private void checkSslConfigAvailability(Config config) {
        if (config.getAdvancedNetworkConfig().isEnabled()) {
            return;
        }
        SSLConfig sslConfig = config.getNetworkConfig().getSSLConfig();
        this.checkSslConfigAvailability(sslConfig);
    }

    private void checkSslConfigAvailability(SSLConfig sslConfig) {
        if (sslConfig != null && sslConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("SSL/TLS requires Hazelcast Enterprise Edition");
        }
    }
}

