/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.HashUtil;
import java.nio.ByteOrder;

public final class NativeMemoryDataUtil {
    private static final boolean BIG_ENDIAN = ByteOrder.BIG_ENDIAN == ByteOrder.nativeOrder();

    private NativeMemoryDataUtil() {
    }

    public static boolean equals(long address, Data data) {
        if (data instanceof NativeMemoryData) {
            NativeMemoryData memoryData = (NativeMemoryData)data;
            return NativeMemoryDataUtil.equals(address, memoryData.address());
        }
        if (address == 0L) {
            return false;
        }
        int type = NativeMemoryDataUtil.readType(address);
        if (type != data.getType()) {
            return false;
        }
        int bufferSize = NativeMemoryDataUtil.readDataSize(address);
        if (bufferSize != data.dataSize()) {
            return false;
        }
        if (bufferSize == 0) {
            return true;
        }
        return NativeMemoryDataUtil.equals(address, bufferSize, data.toByteArray());
    }

    static int readType(long address) {
        if (address == 0L) {
            return 0;
        }
        int type = GlobalMemoryAccessorRegistry.MEM.getInt(address + 8L);
        return BIG_ENDIAN ? type : Integer.reverseBytes(type);
    }

    public static int readDataSize(long address) {
        return Math.max(NativeMemoryDataUtil.readTotalSize(address) - 8, 0);
    }

    public static int readTotalSize(long address) {
        if (address == 0L) {
            return 0;
        }
        return GlobalMemoryAccessorRegistry.MEM.getInt(address + 0L);
    }

    public static boolean equals(long address1, long address2) {
        int bufferSize2;
        if (address1 == address2) {
            return true;
        }
        if (address1 == 0L || address2 == 0L) {
            return false;
        }
        if (NativeMemoryDataUtil.readType(address1) != NativeMemoryDataUtil.readType(address2)) {
            return false;
        }
        int bufferSize1 = NativeMemoryDataUtil.readDataSize(address1);
        if (bufferSize1 != (bufferSize2 = NativeMemoryDataUtil.readDataSize(address2))) {
            return false;
        }
        if (bufferSize1 == 0) {
            return true;
        }
        return NativeMemoryDataUtil.equals(address1, address2, bufferSize1);
    }

    public static boolean equals(long address1, long address2, int bufferSize) {
        int i;
        if (address1 == address2) {
            return true;
        }
        if (address1 == 0L || address2 == 0L) {
            return false;
        }
        int numLongs = bufferSize / 8;
        int remaining = bufferSize % 8;
        int lastAddress = 12 + bufferSize - 1;
        for (i = 0; i < remaining; ++i) {
            byte k2;
            byte k1 = GlobalMemoryAccessorRegistry.MEM.getByte(address1 + (long)lastAddress - (long)i);
            if (k1 == (k2 = GlobalMemoryAccessorRegistry.MEM.getByte(address2 + (long)lastAddress - (long)i))) continue;
            return false;
        }
        for (i = 0; i < numLongs; ++i) {
            long k2;
            long k1 = GlobalMemoryAccessorRegistry.MEM.getLong(address1 + 12L + (long)(i * 8));
            if (k1 == (k2 = GlobalMemoryAccessorRegistry.MEM.getLong(address2 + 12L + (long)(i * 8)))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long address, int bufferSize, byte[] bytes) {
        if (address == 0L || bytes == null || bytes.length == 0 || bufferSize != bytes.length - 8) {
            return false;
        }
        int bufferOffset = 12;
        for (int i = 0; i < bufferSize; ++i) {
            byte b = GlobalMemoryAccessorRegistry.MEM.getByte(address + (long)bufferOffset + (long)i);
            if (b == bytes[i + 8]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(long address) {
        int bufferSize = NativeMemoryDataUtil.readDataSize(address);
        return HashUtil.MurmurHash3_x86_32_direct(address, 12, bufferSize);
    }

    public static long hash64(long address) {
        int bufferSize = NativeMemoryDataUtil.readDataSize(address);
        return HashUtil.MurmurHash3_x64_64_direct(address, 12, bufferSize);
    }

    public static void dispose(EnterpriseSerializationService ess, MemoryAllocator malloc, MemoryBlock ... blocks) {
        NativeMemoryData[] nativeMemoryData = new NativeMemoryData[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            MemoryBlock block = blocks[i];
            nativeMemoryData[i] = new NativeMemoryData(block.address(), block.size());
        }
        NativeMemoryDataUtil.dispose(ess, malloc, nativeMemoryData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose(EnterpriseSerializationService ess, MemoryAllocator malloc, NativeMemoryData ... nativeData) {
        Exception caught = null;
        try {
            for (NativeMemoryData data : nativeData) {
                try {
                    if (data == null) continue;
                    ess.disposeData(data, malloc);
                }
                catch (Exception ex) {
                    caught = ex;
                }
            }
        }
        finally {
            if (caught != null) {
                throw new HazelcastException("Could not deallocate native data. There may be a native memory leak!", caught);
            }
        }
    }
}

