/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;

final class TLSUtil {
    private static final Certificate[] EMPTY_CERTS = new Certificate[0];

    private TLSUtil() {
    }

    static void publishRemoteCertificates(SSLEngine sslEngine, Map attributeMap) throws CertificateException {
        if (sslEngine.getUseClientMode() || sslEngine.getNeedClientAuth() || sslEngine.getWantClientAuth()) {
            Certificate certificate;
            Certificate[] certs;
            try {
                certs = sslEngine.getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                certs = EMPTY_CERTS;
            }
            attributeMap.putIfAbsent(Certificate.class, certs);
            if (attributeMap.get("forceCertValidation") == Boolean.TRUE && certs.length > 0 && (certificate = certs[0]) instanceof X509Certificate) {
                X509Certificate certificate2 = (X509Certificate)certificate;
                certificate2.checkValidity();
            }
        }
    }
}

