/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.nio.ssl.TLSDecoder;
import com.hazelcast.internal.nio.ssl.TLSExecutor;
import com.hazelcast.internal.nio.ssl.TLSUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

public class TLSHandshakeDecoder
extends InboundHandler<ByteBuffer, Void> {
    private final SSLEngine sslEngine;
    private final TLSExecutor tlsExecutor;
    private volatile ByteBuffer appBuffer;
    private final ConcurrentMap attributeMap;
    private final ILogger logger = Logger.getLogger(this.getClass());
    private volatile boolean isHandshakeFailed;

    public TLSHandshakeDecoder(SSLEngine sslEngine, TLSExecutor tlsExecutor, ConcurrentMap attributeMap) {
        this.sslEngine = sslEngine;
        this.tlsExecutor = tlsExecutor;
        this.appBuffer = IOUtil.newByteBuffer(sslEngine.getSession().getApplicationBufferSize(), false);
        this.attributeMap = attributeMap;
    }

    @Override
    public void handlerAdded() {
        this.initSrcBuffer(this.sslEngine.getSession().getPacketBufferSize());
    }

    @Override
    public void interceptError(Throwable t) throws Throwable {
        if (t instanceof EOFException) {
            throw TLSHandshakeDecoder.newSSLException(t);
        }
    }

    static SSLException newSSLException(Throwable t) {
        return new SSLException("Remote socket closed during SSL/TLS handshake.  This is probably caused by a SSL/TLS authentication problem resulting in the remote side closing the socket.", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HandlerStatus onRead() throws Exception {
        HandlerStatus handlerStatus;
        ((ByteBuffer)this.src).flip();
        try {
            block17: while (true) {
                SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
                switch (handshakeStatus) {
                    case FINISHED: {
                        continue block17;
                    }
                    case NEED_TASK: {
                        this.tlsExecutor.executeHandshakeTasks(this.sslEngine, this.channel);
                        handlerStatus = HandlerStatus.BLOCKED;
                        return handlerStatus;
                    }
                    case NEED_WRAP: {
                        this.channel.outboundPipeline().wakeup();
                        handlerStatus = HandlerStatus.BLOCKED;
                        return handlerStatus;
                    }
                    case NEED_UNWRAP: {
                        SSLEngineResult unwrapResult = this.sslEngine.unwrap((ByteBuffer)this.src, this.appBuffer);
                        SSLEngineResult.Status unwrapStatus = unwrapResult.getStatus();
                        if (unwrapStatus == SSLEngineResult.Status.OK) continue block17;
                        if (unwrapStatus == SSLEngineResult.Status.CLOSED) {
                            HandlerStatus handlerStatus2 = HandlerStatus.CLEAN;
                            return handlerStatus2;
                        }
                        if (unwrapStatus == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue block17;
                            HandlerStatus handlerStatus3 = HandlerStatus.CLEAN;
                            return handlerStatus3;
                        }
                        if (unwrapStatus != SSLEngineResult.Status.BUFFER_OVERFLOW) throw new IllegalStateException("Unexpected " + String.valueOf(unwrapResult));
                        if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue block17;
                        int newAppBufferSize = this.sslEngine.getSession().getApplicationBufferSize();
                        if (this.logger.isFineEnabled()) {
                            this.logger.fine("The application buffer needs to be resized during the TLS handshake. Original size: " + this.appBuffer.capacity() + ", required size: " + newAppBufferSize + ". This might be caused by a netty issue https://github.com/netty/netty/issues/13073");
                        }
                        ByteBuffer tmpBuffer = IOUtil.newByteBuffer(newAppBufferSize, false);
                        if (this.appBuffer.position() > 0) {
                            this.appBuffer.flip();
                            IOUtil.copyToHeapBuffer(this.appBuffer, tmpBuffer);
                        }
                        this.appBuffer = tmpBuffer;
                        continue block17;
                    }
                    case NOT_HANDSHAKING: {
                        if (this.isHandshakeFailed) {
                            throw new SSLHandshakeException("TLS handshake failed.");
                        }
                        TLSUtil.publishRemoteCertificates(this.sslEngine, this.attributeMap);
                        TLSDecoder tlsDecoder = new TLSDecoder(this.sslEngine);
                        this.channel.inboundPipeline().replace(this, tlsDecoder);
                        if (this.appBuffer.position() != 0) {
                            this.appBuffer.flip();
                            tlsDecoder.appBuffer().put(this.appBuffer);
                        }
                        if (((ByteBuffer)this.src).hasRemaining()) {
                            ((ByteBuffer)tlsDecoder.src()).put((ByteBuffer)this.src);
                        }
                        this.channel.outboundPipeline().wakeup();
                        HandlerStatus handlerStatus4 = HandlerStatus.DIRTY;
                        return handlerStatus4;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (SSLHandshakeException e) {
            if (this.isHandshakeFailed) {
                throw e;
            }
            this.isHandshakeFailed = true;
            this.logger.fine("TLS handshake failed. The SSLEngine.closeInbound() will be called.", e);
            this.sslEngine.closeInbound();
            this.channel.outboundPipeline().wakeup();
            handlerStatus = HandlerStatus.DIRTY;
            return handlerStatus;
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)this.src);
        }
    }
}

