/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.namespace.impl;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.impl.deployment.MapResourceClassLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.ServiceLoader;

public class NamespaceAwareDriverManagerInterface {
    private static final ILogger LOGGER = Logger.getLogger(NamespaceAwareDriverManagerInterface.class);
    private final MapResourceClassLoader classLoader = (MapResourceClassLoader)this.getClass().getClassLoader();

    public static void initializeJdbcDrivers(String nsName, MapResourceClassLoader classLoader) {
        ServiceLoader<Driver> driverLoader = ServiceLoader.load(Driver.class, classLoader);
        LOGGER.finest("Initializing driverLoader=%s in namespace %s", driverLoader, nsName);
        for (Driver d : driverLoader) {
            if (d.getClass().getClassLoader() == classLoader) {
                LOGGER.finest("Registering driver %s from classloader for namespace %s", d.getClass(), nsName);
                try {
                    DriverManager.registerDriver(d);
                }
                catch (SQLException e) {
                    LOGGER.warning("Failed to register driver " + String.valueOf(d) + " in namespace " + nsName, e);
                }
                continue;
            }
            LOGGER.finest("Skipping %s because it's classloader (%s) differs from classloader (%s)", d.getClass(), d.getClass().getClassLoader(), classLoader);
        }
    }

    public static void cleanupJdbcDrivers(String nsName, MapResourceClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClassFromThisLoader(NamespaceAwareDriverManagerInterface.class);
            Method cleanupJdbcDriversMethod = clazz.getDeclaredMethod("cleanupJdbcDrivers", String.class);
            cleanupJdbcDriversMethod.invoke(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), nsName);
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public void cleanupJdbcDrivers(String nsName) {
        Enumeration<Driver> registeredDrivers = DriverManager.getDrivers();
        LOGGER.finest("Cleaning up registeredDrivers=%s, in namespace %s", registeredDrivers, nsName);
        while (registeredDrivers.hasMoreElements()) {
            Driver d = registeredDrivers.nextElement();
            if (d.getClass().getClassLoader() == this.classLoader) {
                try {
                    LOGGER.finest("Deregistering %s from removed classloader for namespace %s", d.getClass(), nsName);
                    DriverManager.deregisterDriver(d);
                }
                catch (SQLException e) {
                    LOGGER.warning("Failed to deregister driver " + String.valueOf(d) + " in namespace " + nsName, e);
                }
                continue;
            }
            LOGGER.finest("Skipping %s because it's classloader (%s) differs from removedClassLoader (%s)", d.getClass(), d.getClass().getClassLoader(), this.classLoader);
        }
    }
}

