/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl.rest;

import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.monitor.LicenseInfo;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class LicenseInfoImpl
implements LicenseInfo {
    private long expirationTime;
    private int maxNodeCount;
    private int allowedTieredStoreSize;
    private int allowedNativeMemorySize;
    private int allowedTpcCores;
    private String keyHash;
    private List<String> features;

    public LicenseInfoImpl() {
    }

    public LicenseInfoImpl(License license) {
        this.expirationTime = license.getExpiryDate().toInstant().toEpochMilli();
        this.maxNodeCount = license.getAllowedNumberOfNodes();
        this.allowedTieredStoreSize = license.getAllowedTieredStoreSize();
        this.allowedNativeMemorySize = license.getAllowedNativeMemorySize();
        this.allowedTpcCores = license.getAllowedTpcCores();
        this.keyHash = license.computeKeyHash();
        this.features = this.getFeaturesText(license.getFeatures());
    }

    @Override
    public int getMaxNodeCountAllowed() {
        return this.maxNodeCount;
    }

    @Override
    public int getAllowedTieredStoreSize() {
        return this.allowedTieredStoreSize;
    }

    @Override
    public int getAllowedNativeMemorySize() {
        return this.allowedNativeMemorySize;
    }

    @Override
    public int getAllowedTpcCores() {
        return this.allowedTpcCores;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public String getKeyHash() {
        return this.keyHash;
    }

    @Override
    public List<String> getFeatures() {
        return this.features;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray featuresArray = new JsonArray();
        for (String item : this.features) {
            featuresArray.add(item);
        }
        json.add("expiryDate", this.expirationTime);
        json.add("maxNodeCount", this.maxNodeCount);
        json.add("allowedTieredStoreSize", this.allowedTieredStoreSize);
        json.add("allowedNativeMemorySize", this.allowedNativeMemorySize);
        json.add("allowedTpcCores", this.allowedTpcCores);
        json.add("keyHash", this.keyHash);
        json.add("features", featuresArray);
        return json;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.expirationTime = json.getLong("expiryDate", 0L);
        this.maxNodeCount = json.getInt("maxNodeCount", 0);
        this.allowedTieredStoreSize = json.getInt("allowedTieredStoreSize", 0);
        this.allowedNativeMemorySize = json.getInt("allowedNativeMemorySize", 0);
        this.allowedTpcCores = json.getInt("allowedTpcCores", 0);
        this.keyHash = json.getString("keyHash", null);
        this.features = this.getListFromJson(json.get("features").asArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseInfoImpl that = (LicenseInfoImpl)o;
        return Objects.equals(this.keyHash, that.keyHash);
    }

    public int hashCode() {
        return Objects.hashCode(this.keyHash);
    }

    private List<String> getFeaturesText(Set<Feature> featureList) {
        return featureList.stream().map(Feature::getText).toList();
    }

    private List<String> getListFromJson(JsonArray jsonArray) {
        ArrayList<String> result = new ArrayList<String>();
        for (JsonValue item : jsonArray) {
            result.add(item.asString());
        }
        return result;
    }
}

