/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableTombChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughTombChunk;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.collection.LongHashSet;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Snapshotter {
    public static final String PROPERTY_GCSTATS_ENABLED = "hazelcast.hotrestart.gc.stats.enabled";
    public static final HazelcastProperty GCSTATS_ENABLED = new HazelcastProperty("hazelcast.hotrestart.gc.stats.enabled", false);
    public static final String CHUNK_SNAPSHOT_FNAME = "chunk-snapshot.bin";
    public static final int SOURCE_CHUNK_FLAG_MASK = 1;
    public static final int SURVIVOR_FLAG_MASK = 2;
    public static final int TOMBSTONE_FLAG_MASK = 4;
    private static final String NEW_SNAPSHOT_PREFIX = ".new";
    private static final int SNAPSHOTTING_INTERVAL_MILLIS = 50;
    private static final LongHashSet EMPTY_SET = new LongHashSet(0, -1L);
    final boolean enabled;
    private final File homeDir;
    private final ChunkManager chunkMgr;
    private long lastChunkSnapshot;
    private LongHashSet srcChunkSeqs = EMPTY_SET;

    @Inject
    private Snapshotter(@Name(value="homeDir") File homeDir, ChunkManager chunkMgr, HazelcastProperties properties) {
        this.homeDir = homeDir;
        this.chunkMgr = chunkMgr;
        this.enabled = properties.getBoolean(GCSTATS_ENABLED);
    }

    void initSrcChunkSeqs(Collection<? extends Chunk> srcChunks) {
        if (!this.enabled) {
            return;
        }
        LongHashSet srcChunkSeqs = new LongHashSet(srcChunks.size(), -1L);
        for (Chunk chunk : srcChunks) {
            srcChunkSeqs.add(chunk.seq);
        }
        this.srcChunkSeqs = srcChunkSeqs;
    }

    void resetSrcChunkSeqs() {
        this.srcChunkSeqs = EMPTY_SET;
    }

    void takeChunkSnapshotAsNeeded() {
        long now = System.nanoTime();
        if (this.chunkMgr.getActiveValChunk() == null || now - this.lastChunkSnapshot <= TimeUnit.MILLISECONDS.toNanos(50L)) {
            return;
        }
        this.lastChunkSnapshot = now;
        Map survivors = this.chunkMgr.getSurvivors() != null ? this.chunkMgr.getSurvivors() : Collections.emptyMap();
        File newFile = new File(this.homeDir, "chunk-snapshot.bin.new");
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
            out.writeLong(now);
            out.writeInt(this.chunkMgr.getChunks().size() + survivors.size() + 2);
            for (Chunk chunk : this.chunkMgr.getChunks().values()) {
                this.writeChunkStats(out, chunk, false);
            }
            for (Chunk chunk : survivors.values()) {
                this.writeChunkStats(out, chunk, true);
            }
            this.writeChunkStats(out, this.chunkMgr.getActiveValChunk(), false);
            this.writeChunkStats(out, this.chunkMgr.getActiveTombChunk(), false);
            out.close();
            IOUtil.rename(newFile, new File(this.homeDir, CHUNK_SNAPSHOT_FNAME));
        }
        catch (IOException e) {
            try {
                throw new HotRestartException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(out);
                throw throwable;
            }
        }
        IOUtil.closeResource(out);
    }

    private void writeChunkStats(DataOutputStream out, Chunk chunk, boolean isSurvivor) throws IOException {
        out.writeLong(chunk.seq);
        out.writeChar(Snapshotter.encodeSize(chunk.size()));
        out.writeChar(Snapshotter.encodeSize(chunk.garbage));
        boolean isSrcChunk = this.srcChunkSeqs.contains(chunk.seq);
        boolean isTombstoneChunk = chunk instanceof StableTombChunk || chunk instanceof WriteThroughTombChunk;
        out.writeByte((isSrcChunk ? 1 : 0) | (isSurvivor ? 2 : 0) | (isTombstoneChunk ? 4 : 0));
    }

    private static char encodeSize(long size) {
        long sizeInPages = size >> 8;
        return (char)(sizeInPages <= 65535L ? sizeInPages : 65535L);
    }
}

