/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;

final class GcParams {
    public static final double MIN_GARBAGE_RATIO = 0.05;
    public static final double HIGH_GARBAGE_RATIO = 0.2;
    public static final double MAX_PROJECTED_GARBAGE_RATIO = 0.3;
    public static final double BOOSTED_BENEFIT_TO_COST = 5.0;
    public static final double BASE_BENEFIT_TO_COST = 0.4;
    public static final double FORCED_MIN_B2C = 0.01;
    public static final long MIN_GARBAGE_CHUNKS_TO_FORCE_GC = 10L;
    public static final int MAX_COST_CHUNKS = 8;
    public static final int MAX_RECORD_COUNT = 0x100000;
    static final GcParams ZERO = new GcParams(0L, 0L, 0L, 0.0, 0L, 0x800000L, false);
    final long costGoal;
    final long minCost;
    final long benefitGoal;
    final long maxCost;
    final double minBenefitToCost;
    final boolean forceGc;
    final boolean limitSrcChunks;
    final long currChunkSeq;

    private GcParams(long garbage, long occupancy, long maxLive, double ratio, long currChunkSeq, long chunkSize, boolean forceGc) {
        this.currChunkSeq = currChunkSeq;
        this.forceGc = forceGc;
        long liveData = occupancy - garbage;
        long costGoalChunks = Math.max(1L, Math.min(4L, liveData / chunkSize));
        long costGoalBytes = chunkSize * costGoalChunks;
        this.limitSrcChunks = costGoalBytes < liveData;
        this.costGoal = this.limitSrcChunks ? costGoalBytes : liveData;
        long l = this.minCost = ratio < 0.2 ? chunkSize / 2L : 0L;
        if (forceGc) {
            this.minBenefitToCost = 0.01;
            this.benefitGoal = GcParams.garbageExceedingThreshold(0.3, occupancy - maxLive, maxLive);
            this.maxCost = Long.MAX_VALUE;
        } else {
            double boostBc = 5.0;
            double baseBc = 0.4;
            double minRatio = 0.05;
            double highRatio = 0.2;
            this.minBenefitToCost = 5.0 - 4.6 * (ratio - 0.05) / 0.15000000000000002;
            this.benefitGoal = GcParams.garbageExceedingThreshold(0.05, garbage, liveData);
            this.maxCost = 8L * chunkSize;
        }
    }

    static GcParams gcParams(long garbage, long occupancy, long maxLive, long currChunkSeq) {
        int chunkSize = Chunk.valChunkSizeLimit();
        long liveData = occupancy - garbage;
        return GcParams.ratio(garbage, liveData) < 0.05 ? ZERO : new GcParams(garbage, occupancy, maxLive, GcParams.ratio(garbage, liveData), currChunkSeq, chunkSize, GcParams.shouldForceGc(garbage, maxLive, chunkSize));
    }

    private static boolean shouldForceGc(long occupancy, long maxLive, int chunkSize) {
        long projectedGarbage = occupancy - maxLive;
        return GcParams.ratio(projectedGarbage, maxLive) >= 0.3 && projectedGarbage >= 10L * (long)chunkSize;
    }

    private static double ratio(long garbage, double liveData) {
        return (double)garbage / liveData;
    }

    public String toString() {
        return String.format("(cost goal %,d, min cost %,d, max cost %,d, benefit goal %,d, min benefit/cost %.2f, forceGc %s)", this.costGoal, this.minCost, this.maxCost, this.benefitGoal, this.minBenefitToCost, this.forceGc);
    }

    private static long garbageExceedingThreshold(double thresholdRatio, long garbage, long liveData) {
        return 1L + garbage - (long)(thresholdRatio * (double)liveData);
    }
}

