/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.encryption;

import com.hazelcast.config.AbstractSymmetricEncryptionConfig;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.BasicSymmetricCipherBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class HotRestartCipherBuilder
extends BasicSymmetricCipherBuilder {
    private volatile int randomIVEnabled = -1;

    public HotRestartCipherBuilder(AbstractSymmetricEncryptionConfig<?> config) {
        super(config);
    }

    @Override
    protected BasicSymmetricCipherBuilder.CipherParams createCipherParams(byte[] keyBytes) throws GeneralSecurityException {
        if (this.algorithm.endsWith("/NoPadding")) {
            return null;
        }
        return super.createCipherParams(keyBytes);
    }

    public Cipher create(boolean encryptMode, byte[] keyBytes, File ivFile) {
        Objects.requireNonNull(keyBytes, "Key bytes cannot be null");
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            BasicSymmetricCipherBuilder.CipherParams params = this.createCipherParams(keyBytes);
            if (params == null) {
                throw new UnsupportedOperationException("Encryption algorithm not supported: " + this.algorithm);
            }
            AlgorithmParameterSpec paramSpec = this.buildFinalAlgorithmParameterSpec(params.getIvLength(), params.getParamSpec(), ivFile);
            int mode = encryptMode ? 1 : 2;
            cipher.init(mode, (Key)params.getKey(), paramSpec);
            return cipher;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create Cipher (encrypt mode: " + encryptMode + "): " + e.getMessage(), e);
        }
    }

    public Cipher create(boolean encryptMode, byte[] keyBytes, byte[] iv) {
        Objects.requireNonNull(keyBytes, "Key bytes cannot be null");
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            BasicSymmetricCipherBuilder.CipherParams params = this.createCipherParams(keyBytes);
            if (params == null) {
                throw new UnsupportedOperationException("Encryption algorithm not supported: " + this.algorithm);
            }
            AlgorithmParameterSpec paramSpec = this.algorithm.contains("/CBC/") ? new IvParameterSpec(iv) : params.getParamSpec();
            int mode = encryptMode ? 1 : 2;
            cipher.init(mode, (Key)params.getKey(), paramSpec);
            return cipher;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create Cipher (encrypt mode: " + encryptMode + "): " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlgorithmParameterSpec buildFinalAlgorithmParameterSpec(int ivLength, AlgorithmParameterSpec paramSpec, File ivFile) throws IOException {
        boolean isCBC = this.algorithm.contains("/CBC/");
        if (isCBC) {
            byte[] iv = ivLength == 8 ? new byte[this.salt.length] : new byte[this.saltDigest.length];
            boolean fileExists = ivFile.exists();
            FileInputStream ivFileInputStream = null;
            FileOutputStream ivFileOutputStream = null;
            try {
                if (fileExists) {
                    ivFileInputStream = new FileInputStream(ivFile);
                    IOUtil.readFully(ivFileInputStream, iv);
                    this.setRandomIVEnabled(ivFile, iv);
                } else {
                    ivFileOutputStream = new FileOutputStream(ivFile);
                    this.setRandomIVEnabled(ivFile);
                    iv = this.generateIV();
                    ivFileOutputStream.write(iv);
                }
                paramSpec = new IvParameterSpec(iv);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(ivFileInputStream);
                IOUtil.closeResource(ivFileOutputStream);
                throw throwable;
            }
            IOUtil.closeResource(ivFileInputStream);
            IOUtil.closeResource(ivFileOutputStream);
        }
        return paramSpec;
    }

    byte[] generateIV() {
        byte[] iv;
        int ivLength = this.getIvLength();
        byte[] byArray = iv = ivLength == 8 ? new byte[this.salt.length] : new byte[this.saltDigest.length];
        if (this.randomIVEnabled == 0) {
            iv = ivLength == 8 ? this.salt : this.saltDigest;
        } else if (this.randomIVEnabled == 1) {
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
        }
        return iv;
    }

    private void setRandomIVEnabled(File ivFile) {
        if (this.randomIVEnabled == -1 && new File(ivFile.getParent(), "key.bin").exists()) {
            this.randomIVEnabled = 0;
        } else if (this.randomIVEnabled == -1) {
            this.randomIVEnabled = 1;
        }
    }

    private void setRandomIVEnabled(File ivFile, byte[] iv) {
        if (this.randomIVEnabled == -1) {
            byte[] staticIV = this.getIvLength() == 8 ? this.salt : this.saltDigest;
            this.randomIVEnabled = new File(ivFile.getParent(), "key.bin").exists() && Arrays.equals(staticIV, iv) ? 0 : 1;
        }
    }

    public int getRandomIVEnabled() {
        return this.randomIVEnabled;
    }

    byte[] generateKey(int keySize) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(HotRestartCipherBuilder.findKeyAlgorithm(this.algorithm));
        SecureRandom random = new SecureRandom();
        if (keySize > 0) {
            keyGenerator.init(keySize, random);
        } else {
            keyGenerator.init(random);
        }
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }
}

