/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.internal.hotrestart.cluster.PartitionTableReader;
import com.hazelcast.internal.hotrestart.cluster.PartitionTableWriter;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;

@SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
public class MemberClusterStartInfo
implements DataSerializable,
Versioned {
    private PartitionTableView partitionTable;
    private DataLoadStatus dataLoadStatus;

    public MemberClusterStartInfo() {
    }

    public MemberClusterStartInfo(PartitionTableView partitionTable, DataLoadStatus dataLoadStatus) {
        this.partitionTable = partitionTable;
        this.dataLoadStatus = dataLoadStatus;
    }

    public PartitionTableView getPartitionTable() {
        return this.partitionTable;
    }

    public DataLoadStatus getDataLoadStatus() {
        return this.dataLoadStatus;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        PartitionTableWriter.writePartitionTable(out, this.partitionTable);
        out.writeString(this.dataLoadStatus.name());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.partitionTable = PartitionTableReader.readPartitionTable(in);
        this.dataLoadStatus = DataLoadStatus.valueOf(in.readString());
    }

    public static enum DataLoadStatus {
        LOAD_IN_PROGRESS,
        LOAD_SUCCESSFUL,
        LOAD_FAILED;

    }
}

