/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.cluster.ClusterMetadataManager;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterSerializerHook;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterStartStatus;
import com.hazelcast.internal.hotrestart.cluster.SendClusterStartResultOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.Set;
import java.util.UUID;

public class AskForClusterStartResultOperation
extends Operation
implements JoinOperation {
    @Override
    public void run() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        Address caller = this.getCallerAddress();
        ILogger logger = this.getLogger();
        Address master = nodeEngine.getMasterAddress();
        if (master == null) {
            logger.warning("Master is not known yet. Cannot answer for cluster start result. Caller: " + String.valueOf(caller));
            return;
        }
        if (!master.equals(caller)) {
            logger.warning("Non-master member: " + String.valueOf(caller) + " asked for cluster start result. master: " + String.valueOf(master));
            return;
        }
        HotRestartIntegrationService service = (HotRestartIntegrationService)this.getService();
        ClusterMetadataManager clusterMetadataManager = service.getClusterMetadataManager();
        OperationService operationService = nodeEngine.getOperationService();
        HotRestartClusterStartStatus status = clusterMetadataManager.getHotRestartStatus();
        Set<UUID> excludedMemberUuids = clusterMetadataManager.getExcludedMemberUuids();
        if (clusterMetadataManager.isStartWithHotRestart() && status != HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
            if (logger.isFineEnabled()) {
                logger.fine("Sending " + String.valueOf((Object)status) + " to: " + String.valueOf(caller) + " as response for " + this.getClass().getSimpleName());
            }
            ClusterState clusterState = status == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED ? clusterMetadataManager.getCurrentClusterState() : null;
            operationService.send(new SendClusterStartResultOperation(status, excludedMemberUuids, clusterState), caller);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:ee:internalHotRestartService";
    }

    @Override
    public int getFactoryId() {
        return HotRestartClusterSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }
}

