/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart;

import com.hazelcast.internal.hidensity.HiDensityRecord;
import com.hazelcast.internal.hotrestart.KeyHandleOffHeap;
import com.hazelcast.internal.hotrestart.RecordDataSink;
import com.hazelcast.internal.hotrestart.impl.KeyOnHeap;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import java.nio.ByteBuffer;

public final class RamStoreHelper {
    private RamStoreHelper() {
    }

    public static boolean copyEntry(KeyOnHeap keyHandle, Data value, int expectedSize, RecordDataSink sink) {
        byte[] keyBytes = keyHandle.bytes();
        byte[] valueBytes = value.toByteArray();
        if (valueBytes.length + keyBytes.length != expectedSize) {
            return false;
        }
        sink.getValueBuffer(valueBytes.length).put(valueBytes);
        sink.getKeyBuffer(keyBytes.length).put(keyBytes);
        return true;
    }

    public static boolean copyEntry(KeyHandleOffHeap keyHandleOffHeap, NativeMemoryData key, HiDensityRecord record, int expectedSize, RecordDataSink sink) {
        long valueAddress;
        NativeMemoryData value;
        int valueSize;
        if (keyHandleOffHeap.sequenceId() != record.getSequence()) {
            return false;
        }
        int keySize = key.totalSize();
        if (keySize + (valueSize = (value = new NativeMemoryData().reset(valueAddress = record.getValueAddress())).totalSize()) != expectedSize) {
            return false;
        }
        RamStoreHelper.writeDataToBuffer(value, sink.getValueBuffer(valueSize));
        RamStoreHelper.writeDataToBuffer(key, sink.getKeyBuffer(keySize));
        return true;
    }

    private static void writeDataToBuffer(NativeMemoryData data, ByteBuffer buffer) {
        if (buffer.hasArray()) {
            byte[] bufferArray = buffer.array();
            int position = buffer.position();
            int length = data.totalSize();
            data.copyToByteArray(4L, bufferArray, position, length);
            buffer.position(position + length);
        } else {
            buffer.put(data.toByteArray());
        }
    }

    public static NativeMemoryData validateAndGetKey(KeyHandleOffHeap kh, HazelcastMemoryManager memoryManager) {
        int size = (int)memoryManager.validateAndGetUsableSize(kh.address());
        if (size < 0) {
            return null;
        }
        NativeMemoryData key = new NativeMemoryData(kh.address(), size);
        if (4 + key.totalSize() > size) {
            return null;
        }
        return key;
    }
}

