/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.EnterpriseCacheService;
import com.hazelcast.cache.impl.operation.CacheMerkleTreeRebuildOperation;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.instance.impl.ClusterTopologyIntent;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeState;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.operations.OnJoinOp;
import com.hazelcast.internal.hotrestart.ConfigDescriptor;
import com.hazelcast.internal.hotrestart.EncryptionHelper;
import com.hazelcast.internal.hotrestart.ForceStartException;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.InternalHotRestartService;
import com.hazelcast.internal.hotrestart.LoadedConfigurationListener;
import com.hazelcast.internal.hotrestart.PersistentConfigDescriptors;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.RamStoreRegistry;
import com.hazelcast.internal.hotrestart.cluster.ClusterHotRestartEventListener;
import com.hazelcast.internal.hotrestart.cluster.ClusterHotRestartStatusDTOUtil;
import com.hazelcast.internal.hotrestart.cluster.ClusterMetadataManager;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterStartStatus;
import com.hazelcast.internal.hotrestart.cluster.SendExcludedMemberUuidsOperation;
import com.hazelcast.internal.hotrestart.cluster.TriggerForceStartOnMasterOperation;
import com.hazelcast.internal.hotrestart.impl.HotRestartModule;
import com.hazelcast.internal.hotrestart.impl.HotRestartStoreConfig;
import com.hazelcast.internal.hotrestart.impl.RamStoreRestartLoop;
import com.hazelcast.internal.hotrestart.impl.encryption.HotRestartStoreEncryptionConfig;
import com.hazelcast.internal.management.dto.ClusterHotRestartStatusDTO;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAdjuster;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionReplicaVersionManager;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.impl.PartitionReplicaManager;
import com.hazelcast.internal.partition.operation.SafeStateCheckOperation;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.DirectoryLock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.MapMerkleTreeRebuildOperation;
import com.hazelcast.persistence.BackupTaskState;
import com.hazelcast.persistence.BackupTaskStatus;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationexecutor.impl.OperationThread;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.utils.RetryUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class HotRestartIntegrationService
implements RamStoreRegistry,
InternalHotRestartService {
    private static final int NUM_RETRIES = 5;
    private static final char STORE_PREFIX = 's';
    private static final char ONHEAP_SUFFIX = '0';
    private static final char OFFHEAP_SUFFIX = '1';
    private static final String STORE_NAME_PATTERN = "s\\d+0";
    private final Map<String, RamStoreRegistry> ramStoreRegistryServiceMap = new ConcurrentHashMap<String, RamStoreRegistry>();
    private final Map<Long, RamStoreRegistry> ramStoreRegistryPrefixMap = new ConcurrentHashMap<Long, RamStoreRegistry>();
    private final File hotRestartHome;
    private final File hotRestartBackupDir;
    private final Node node;
    private final ILogger logger;
    private final PersistentConfigDescriptors persistentConfigDescriptors;
    private final ClusterMetadataManager clusterMetadataManager;
    private final long dataLoadTimeoutMillis;
    private final int storeCount;
    private final boolean autoRemoveStaleData;
    private final List<LoadedConfigurationListener> loadedConfigurationListeners;
    private final boolean legacyHotRestartDir;
    private final EncryptionHelper encryptionHelper;
    private final AtomicReference<ClusterState> deferredClusterState = new AtomicReference();
    private volatile HotRestartStore[] onHeapStores;
    private volatile HotRestartStore[] offHeapStores;
    private volatile int partitionThreadCount;
    private volatile DirectoryLock directoryLock;
    private final AtomicReference<PartitionRuntimeState> deferredPartitionRuntimeState = new AtomicReference();
    private final AtomicReference<OnJoinOp> deferredPostJoinOp = new AtomicReference();
    private final AtomicReference<Boolean> rejoiningActiveCluster = new AtomicReference();
    private volatile ClusterTopologyIntent clusterTopologyIntentOnMaster = ClusterTopologyIntent.IN_MANAGED_CONTEXT_UNKNOWN;

    public HotRestartIntegrationService(Node node) {
        this.node = node;
        this.logger = node.getLogger(this.getClass());
        HotRestartPersistenceConfig config = node.getConfig().getHotRestartPersistenceConfig();
        this.directoryLock = this.acquireHotRestartDir(config);
        this.hotRestartHome = this.directoryLock.getDir();
        this.legacyHotRestartDir = this.hotRestartHome.getName().equals(config.getBaseDir().getName());
        this.hotRestartBackupDir = config.getBackupDir();
        this.storeCount = config.getParallelism();
        this.autoRemoveStaleData = config.isAutoRemoveStaleData();
        this.clusterMetadataManager = new ClusterMetadataManager(node, this.hotRestartHome, config);
        this.persistentConfigDescriptors = new PersistentConfigDescriptors(this.hotRestartHome);
        this.dataLoadTimeoutMillis = TimeUnit.SECONDS.toMillis(config.getDataLoadTimeoutSeconds());
        this.loadedConfigurationListeners = new ArrayList<LoadedConfigurationListener>();
        this.encryptionHelper = new EncryptionHelper(config.getEncryptionAtRestConfig());
    }

    private DirectoryLock acquireHotRestartDir(HotRestartPersistenceConfig config) {
        File baseDir = config.getBaseDir();
        if (!(baseDir.exists() || baseDir.mkdirs() || baseDir.exists())) {
            throw new HotRestartException("Could not locate or create base directory. Please check filesystem permissions in " + baseDir.getAbsolutePath());
        }
        if (!baseDir.isDirectory()) {
            throw new HotRestartException(baseDir.getAbsolutePath() + " is not a directory!");
        }
        if (HotRestartIntegrationService.isHotRestartDirectory(baseDir)) {
            this.logger.info("Found legacy hot-restart directory: " + baseDir.getAbsolutePath());
            return DirectoryLock.lockForDirectory(baseDir, this.logger);
        }
        File[] dirs = baseDir.listFiles(f -> {
            boolean hotRestartDirectory = HotRestartIntegrationService.isHotRestartDirectory(f);
            if (!hotRestartDirectory) {
                this.logger.fine(f.getAbsolutePath() + " is not a valid hot-restart directory.");
            }
            return hotRestartDirectory;
        });
        if (dirs == null) {
            return this.newHotRestartDir(baseDir);
        }
        for (File dir : dirs) {
            try {
                this.logger.fine("Trying to lock existing hot-restart directory: " + dir.getAbsolutePath());
                DirectoryLock directoryLock = DirectoryLock.lockForDirectory(dir, this.logger);
                this.logger.info("Found existing hot-restart directory: " + dir.getAbsolutePath());
                return directoryLock;
            }
            catch (Exception e) {
                this.logger.fine("Could not lock existing hot-restart directory: " + dir.getAbsolutePath() + ". Reason: " + e.getMessage());
            }
        }
        return this.newHotRestartDir(baseDir);
    }

    private DirectoryLock newHotRestartDir(File baseDir) {
        File dir = new File(baseDir, UuidUtil.newUnsecureUuidString());
        if (!dir.mkdir()) {
            throw new HotRestartException("Could not create new hot-restart directory.  Please check filesystem permissions in " + baseDir.getAbsolutePath());
        }
        this.logger.info("Created new empty hot-restart directory: " + dir.getAbsolutePath());
        return DirectoryLock.lockForDirectory(dir, this.logger);
    }

    private static boolean isHotRestartDirectory(File dir) {
        return PersistentConfigDescriptors.isValidHotRestartDir(dir) && ClusterMetadataManager.isValidHotRestartDir(dir);
    }

    public boolean isHotRestartHomeValid() {
        return HotRestartIntegrationService.isHotRestartDirectory(this.hotRestartHome);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void registerLoadedConfigurationListener(LoadedConfigurationListener listener) {
        this.loadedConfigurationListeners.add(listener);
    }

    @Override
    public RamStore ramStoreForPrefix(long prefix) {
        return this.ramStoreRegistryForPrefix(prefix).ramStoreForPrefix(prefix);
    }

    @Override
    public RamStore restartingRamStoreForPrefix(long prefix) {
        return this.ramStoreRegistryForPrefix(prefix).restartingRamStoreForPrefix(prefix);
    }

    @Override
    public int prefixToThreadId(long prefix) {
        return this.getOperationExecutor().getPartitionThreadId(PersistentConfigDescriptors.toPartitionId(prefix));
    }

    @Override
    public BiTuple<String, String> describe(long prefix) {
        return this.ramStoreRegistryForPrefix(prefix).describe(prefix);
    }

    @Override
    public void deferApplyPartitionState(PartitionRuntimeState partitionRuntimeState) {
        this.deferredPartitionRuntimeState.compareAndSet(null, partitionRuntimeState);
    }

    @Override
    public void deferPostJoinOps(OnJoinOp postJoinOp) {
        this.deferredPostJoinOp.compareAndSet(null, postJoinOp);
    }

    private void executeDeferredPostJoinOp() {
        this.sendPostJoinOperationsBackToMaster();
        if (this.deferredPostJoinOp.get() != null) {
            this.node.nodeEngine.getOperationService().run(this.deferredPostJoinOp.get());
        }
    }

    private void sendPostJoinOperationsBackToMaster() {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        Collection<Operation> postJoinOperations = nodeEngine.getPostJoinOperations();
        if (postJoinOperations != null && !postJoinOperations.isEmpty()) {
            OperationServiceImpl operationService = nodeEngine.getOperationService();
            Address masterAddress = clusterService.getMasterAddress();
            OnJoinOp operation = new OnJoinOp(postJoinOperations);
            operationService.invokeOnTarget("hz:core:clusterService", operation, masterAddress);
        }
    }

    public HotRestartStore getOnHeapHotRestartStoreForPartition(int partitionId) {
        return this.onHeapStores[this.storeIndexForPartition(partitionId)];
    }

    public HotRestartStore getOffHeapHotRestartStoreForPartition(int partitionId) {
        return this.offHeapStores[this.storeIndexForPartition(partitionId)];
    }

    public long registerRamStore(RamStoreRegistry ramStoreRegistry, String serviceName, String name, int partitionId) {
        long prefix = this.persistentConfigDescriptors.getPrefix(serviceName, name, partitionId);
        this.ramStoreRegistryPrefixMap.put(prefix, ramStoreRegistry);
        return prefix;
    }

    public void registerRamStoreRegistry(String serviceName, RamStoreRegistry registry) {
        this.ramStoreRegistryServiceMap.put(serviceName, registry);
    }

    public void ensureHasConfiguration(String serviceName, String name, Object config) {
        this.persistentConfigDescriptors.ensureHas(this.node.getSerializationService(), serviceName, name, config);
    }

    public void overwriteOrAddConfiguration(String serviceName, String name, Object config) {
        this.persistentConfigDescriptors.overwriteOrAddMapping(this.node.getSerializationService(), serviceName, name, config);
    }

    public void removeConfiguration(String serviceName, String name) {
        this.persistentConfigDescriptors.removeMapping(serviceName, name);
    }

    public String getCacheName(long prefix) {
        ConfigDescriptor descriptor = this.persistentConfigDescriptors.getDescriptor(prefix);
        if (descriptor == null) {
            throw new IllegalArgumentException("No descriptor found for prefix: " + prefix);
        }
        return descriptor.getName();
    }

    public void addClusterHotRestartEventListener(ClusterHotRestartEventListener listener) {
        this.clusterMetadataManager.addClusterHotRestartEventListener(listener);
    }

    public ClusterMetadataManager getClusterMetadataManager() {
        return this.clusterMetadataManager;
    }

    public void prepare() {
        this.partitionThreadCount = this.getOperationExecutor().getPartitionThreadCount();
        if (this.storeCount > this.partitionThreadCount) {
            throw new HotRestartException(String.format("The parallelism level configured for Hot Restart Persistence cannot exceed the number of partition threads. To change the number of partition threads use the '%s' system property. Configured parallelism level is %d, the number of partition threads is %d", ClusterProperty.PARTITION_OPERATION_THREAD_COUNT.getName(), this.storeCount, this.partitionThreadCount));
        }
        int persistedStoreCount = this.persistedStoreCount();
        if (persistedStoreCount > 0) {
            if (this.storeCount != persistedStoreCount) {
                throw new HotRestartException(String.format("Mismatch between configured and actual level of parallelism in Hot Restart Persistence. Configured %d, actual %d", this.storeCount, persistedStoreCount));
            }
        } else {
            if (this.storeCount <= 0) {
                throw new HotRestartException("Configured Hot Restart store count must be a positive integer, but is " + this.storeCount);
            }
            this.clusterMetadataManager.writePartitionThreadCount(this.partitionThreadCount);
        }
        this.persistentConfigDescriptors.restore(this.node.getSerializationService(), this.loadedConfigurationListeners);
        this.clusterMetadataManager.prepare();
        this.encryptionHelper.prepare(this.node, this::rotateEncryptionKey);
        this.createHotRestartStores();
    }

    public void start() {
        try {
            this.logger.info("Starting hot-restart service. Base directory: " + this.hotRestartHome.getAbsolutePath());
            this.clusterMetadataManager.start();
            boolean allowData = this.clusterMetadataManager.isStartWithHotRestart();
            this.logger.info(allowData ? "Starting the Hot Restart procedure." : "Initializing Hot Restart stores, not expecting to reload any data.");
            long start = Clock.currentTimeMillis();
            Throwable failure = null;
            try {
                this.runRestarterPipeline(this.onHeapStores, !allowData);
                this.runRestarterPipeline(this.offHeapStores, !allowData);
            }
            catch (ForceStartException e) {
                throw e;
            }
            catch (Throwable t) {
                failure = t;
            }
            if (failure == null) {
                this.rebuildMapMerkleTrees();
                this.rebuildCacheMerkleTrees();
            }
            this.clusterMetadataManager.loadCompletedLocal(this.deferredPartitionRuntimeState.get(), failure);
            if (this.node.getClusterService().getClusterState().isMigrationAllowed()) {
                this.logger.info("Initializing proxies");
                this.initializeAndPublishProxies();
            }
            this.executeDeferredPostJoinOp();
            this.logger.info(String.format("Hot Restart procedure completed in %,d seconds", TimeUnit.MILLISECONDS.toSeconds(Clock.currentTimeMillis() - start)));
            this.markPartitionReplicas();
            if (!this.deferredClusterState.compareAndSet(null, this.clusterMetadataManager.getCurrentClusterState())) {
                try {
                    RetryUtils.retry(() -> {
                        this.node.getClusterService().changeClusterState(this.deferredClusterState.get(), true);
                        return null;
                    }, 5);
                }
                catch (Throwable t) {
                    this.logger.warning("Could not apply cluster state " + String.valueOf((Object)this.deferredClusterState.get()), t);
                }
            }
            this.resetClusterTopologyIntentOnMaster();
        }
        catch (ForceStartException e) {
            this.handleForceStart(true);
        }
        catch (HotRestartException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRestartException("Thread interrupted during the Hot Restart procedure", e);
        }
        catch (Throwable t) {
            throw new HotRestartException("Hot Restart procedure failed", t);
        }
    }

    @Override
    public boolean trySetDeferredClusterState(ClusterState newClusterState) {
        return this.deferredClusterState.compareAndSet(null, newClusterState);
    }

    private void initializeAndPublishProxies() {
        ProxyServiceImpl proxyService = (ProxyServiceImpl)this.node.getNodeEngine().getProxyService();
        proxyService.initializeProxies(true);
    }

    private void markPartitionReplicas() {
        if (!this.clusterMetadataManager.isStartWithHotRestart() || this.isClusterWideStart() || this.node.getClusterTopologyIntent() == ClusterTopologyIntent.NOT_IN_MANAGED_CONTEXT) {
            return;
        }
        this.logger.info("Marking partition replicas for anti-entropy");
        OperationServiceImpl operationService = this.node.nodeEngine.getOperationService();
        InternalPartitionService partitionService = this.node.getPartitionService();
        PartitionReplicaVersionManager partitionReplicaVersionManager = partitionService.getPartitionReplicaVersionManager();
        int maxBackupCount = partitionService.getMaxAllowedBackupCount();
        int partitionCount = partitionService.getPartitionCount();
        CountDownLatch completionLatch = new CountDownLatch(partitionCount);
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            PartitionReplica owner = partitionService.getPartition(partitionId).getOwnerReplicaOrNull();
            if (owner == null) {
                completionLatch.countDown();
                continue;
            }
            operationService.execute(new MarkReplicasAsSyncRequired(partitionReplicaVersionManager, partitionService.getPartition(partitionId), maxBackupCount, completionLatch));
        }
        try {
            completionLatch.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
    }

    final Collection<ServiceNamespace> getNamespaces(int replicaIndex) {
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        MapService mapService = (MapService)nodeEngine.getService("hz:impl:mapService");
        Set<ServiceNamespace> mapNamespaces = mapService.getMapServiceContext().getMapContainers().values().stream().filter(mapContainer -> mapContainer.getMapConfig().getHotRestartConfig().isEnabled()).filter(mapContainer -> mapContainer.getMapConfig().getTotalBackupCount() >= replicaIndex).map(MapContainer::getObjectNamespace).collect(Collectors.toSet());
        EnterpriseCacheService cacheService = (EnterpriseCacheService)this.node.getNodeEngine().getServiceOrNull("hz:impl:cacheService");
        if (cacheService == null) {
            return mapNamespaces;
        }
        HashSet<ServiceNamespace> namespaces = new HashSet<ServiceNamespace>(mapNamespaces);
        Collection<String> allCacheNamesWithPrefix = cacheService.getAllCacheNamesWithPrefix();
        for (String cacheNameWithPrefix : allCacheNamesWithPrefix) {
            CacheConfig cacheConfig = cacheService.getCacheConfig(cacheNameWithPrefix);
            if (!cacheConfig.getHotRestartConfig().isEnabled() || cacheConfig.getTotalBackupCount() < replicaIndex) continue;
            namespaces.add(CacheService.getObjectNamespace(cacheNameWithPrefix));
        }
        return namespaces;
    }

    private void rebuildCacheMerkleTrees() throws InterruptedException {
        InternalPartitionService partitionService = this.node.getPartitionService();
        EnterpriseCacheService cacheService = (EnterpriseCacheService)this.node.getNodeEngine().getServiceOrNull("hz:impl:cacheService");
        if (cacheService == null) {
            return;
        }
        Collection<String> allCacheNamesWithPrefix = cacheService.getAllCacheNamesWithPrefix();
        HashMap<String, List<int[]>> mapLocalPartitionsWithReplicaIndex = new HashMap<String, List<int[]>>();
        MemberImpl localMember = this.node.getLocalMember();
        int totalRebuildOperations = 0;
        for (String cacheNameWithPrefix : allCacheNamesWithPrefix) {
            CacheConfig cacheConfig = cacheService.getCacheConfig(cacheNameWithPrefix);
            assert (cacheConfig != null) : "Found null cache config";
            boolean hasMerkleTree = cacheService.shouldEnableMerkleTree(cacheNameWithPrefix, false);
            boolean hasHotRestart = cacheConfig.getHotRestartConfig().isEnabled();
            if (!hasMerkleTree || !hasHotRestart) continue;
            int totalBackupCount = cacheConfig.getTotalBackupCount();
            LinkedList<int[]> localPartitionsWithReplicaIndex = new LinkedList<int[]>();
            mapLocalPartitionsWithReplicaIndex.put(cacheConfig.getNameWithPrefix(), localPartitionsWithReplicaIndex);
            for (InternalPartition partition : partitionService.getInternalPartitions()) {
                for (int replicaIndex = 0; replicaIndex <= totalBackupCount; ++replicaIndex) {
                    PartitionReplica replica = partition.getReplica(replicaIndex);
                    if (replica == null || !replica.isIdentical(localMember)) continue;
                    localPartitionsWithReplicaIndex.add(new int[]{partition.getPartitionId(), replicaIndex});
                    ++totalRebuildOperations;
                }
            }
        }
        if (totalRebuildOperations > 0) {
            this.performCacheMerkleTreeRebuild(mapLocalPartitionsWithReplicaIndex, totalRebuildOperations);
        }
    }

    private void performCacheMerkleTreeRebuild(Map<String, List<int[]>> mapLocalPartitionsWithReplicaIndex, int totalRebuildOperations) throws InterruptedException {
        String cacheNameWithPrefix;
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        OperationServiceImpl os = nodeEngine.getOperationService();
        Address thisAddress = this.node.getThisAddress();
        CountDownLatch rebuiltAllLatch = new CountDownLatch(totalRebuildOperations);
        ConcurrentMap<String, AtomicInteger> mapPartitionRebuildCounters = MapUtil.createConcurrentHashMap(mapLocalPartitionsWithReplicaIndex.size());
        for (Map.Entry<String, List<int[]>> entry : mapLocalPartitionsWithReplicaIndex.entrySet()) {
            cacheNameWithPrefix = entry.getKey();
            List<int[]> localPartitions = entry.getValue();
            AtomicInteger partitionRebuildCounter = new AtomicInteger();
            mapPartitionRebuildCounters.put(cacheNameWithPrefix, partitionRebuildCounter);
            if (this.logger.isFineEnabled()) {
                this.logger.fine(String.format("Rebuilding Merkle trees for cache '%s'", cacheNameWithPrefix));
            }
            for (int[] partitionIdAndReplicaIndex : localPartitions) {
                int partitionId = partitionIdAndReplicaIndex[0];
                int replicaIndex = partitionIdAndReplicaIndex[1];
                Operation op = new CacheMerkleTreeRebuildOperation(cacheNameWithPrefix).setPartitionId(partitionId).setReplicaIndex(replicaIndex);
                partitionRebuildCounter.incrementAndGet();
                os.invokeOnTarget("hz:impl:cacheService", op, thisAddress).whenCompleteAsync((response, t) -> {
                    if (t == null) {
                        partitionRebuildCounter.decrementAndGet();
                        rebuiltAllLatch.countDown();
                    } else {
                        rebuiltAllLatch.countDown();
                    }
                }, this.internalAsyncExecutor());
            }
        }
        rebuiltAllLatch.await();
        for (Map.Entry<String, List<Object>> entry : mapPartitionRebuildCounters.entrySet()) {
            cacheNameWithPrefix = entry.getKey();
            AtomicInteger rebuildCounter = (AtomicInteger)((Object)entry.getValue());
            if (rebuildCounter.get() == 0) continue;
            this.logger.severe(String.format("Rebuilding Merkle trees during Hot Restart for cache '%s' has failed on %d partitions, Hot Restart continues. Restarting this node after the cluster successfully restarted rebuilds the Merkle trees.", cacheNameWithPrefix, rebuildCounter.get()));
        }
    }

    private void rebuildMapMerkleTrees() throws InterruptedException {
        InternalPartitionService partitionService = this.node.getPartitionService();
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        MapService mapService = (MapService)nodeEngine.getService("hz:impl:mapService");
        HashMap<String, List<int[]>> mapLocalPartitionsWithReplicaIndex = new HashMap<String, List<int[]>>();
        MemberImpl localMember = this.node.getLocalMember();
        int totalRebuildOperations = 0;
        for (MapContainer mapContainer : mapService.getMapServiceContext().getMapContainers().values()) {
            MapConfig mapConfig = mapContainer.getMapConfig();
            boolean mapHasMerkleTree = mapService.getMapServiceContext().shouldEnableMerkleTree(mapContainer, false);
            boolean mapHasHotRestart = mapConfig.getHotRestartConfig().isEnabled();
            if (!mapHasMerkleTree || !mapHasHotRestart) continue;
            int totalBackupCount = mapContainer.getTotalBackupCount();
            LinkedList<int[]> localPartitionsWithReplicaIndex = new LinkedList<int[]>();
            mapLocalPartitionsWithReplicaIndex.put(mapContainer.getName(), localPartitionsWithReplicaIndex);
            for (InternalPartition partition : partitionService.getInternalPartitions()) {
                for (int replicaIndex = 0; replicaIndex <= totalBackupCount; ++replicaIndex) {
                    PartitionReplica replica = partition.getReplica(replicaIndex);
                    if (replica == null || !replica.isIdentical(localMember)) continue;
                    localPartitionsWithReplicaIndex.add(new int[]{partition.getPartitionId(), replicaIndex});
                    ++totalRebuildOperations;
                }
            }
        }
        if (totalRebuildOperations > 0) {
            this.performMapMerkleTreeRebuild(mapLocalPartitionsWithReplicaIndex, totalRebuildOperations);
        }
    }

    private void performMapMerkleTreeRebuild(Map<String, List<int[]>> mapLocalPartitionsWithReplicaIndex, int totalRebuildOperations) throws InterruptedException {
        String mapName;
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        OperationServiceImpl os = nodeEngine.getOperationService();
        Address thisAddress = this.node.getThisAddress();
        CountDownLatch rebuiltAllLatch = new CountDownLatch(totalRebuildOperations);
        ConcurrentMap<String, AtomicInteger> mapPartitionRebuildCounters = MapUtil.createConcurrentHashMap(mapLocalPartitionsWithReplicaIndex.size());
        for (Map.Entry<String, List<int[]>> entry : mapLocalPartitionsWithReplicaIndex.entrySet()) {
            mapName = entry.getKey();
            List<int[]> localPartitions = entry.getValue();
            AtomicInteger mapPartitionRebuildCounter = new AtomicInteger();
            mapPartitionRebuildCounters.put(mapName, mapPartitionRebuildCounter);
            if (this.logger.isFineEnabled()) {
                this.logger.fine(String.format("Rebuilding Merkle trees for map '%s'", mapName));
            }
            for (int[] partitionIdAndReplicaIndex : localPartitions) {
                int partitionId = partitionIdAndReplicaIndex[0];
                int replicaIndex = partitionIdAndReplicaIndex[1];
                Operation op = new MapMerkleTreeRebuildOperation(mapName).setPartitionId(partitionId).setReplicaIndex(replicaIndex);
                mapPartitionRebuildCounter.incrementAndGet();
                os.invokeOnTarget("hz:impl:mapService", op, thisAddress).whenCompleteAsync((response, t) -> {
                    if (t == null) {
                        mapPartitionRebuildCounter.decrementAndGet();
                        rebuiltAllLatch.countDown();
                    } else {
                        rebuiltAllLatch.countDown();
                    }
                }, this.internalAsyncExecutor());
            }
        }
        rebuiltAllLatch.await();
        for (Map.Entry<String, List<Object>> entry : mapPartitionRebuildCounters.entrySet()) {
            mapName = entry.getKey();
            AtomicInteger rebuildCounter = (AtomicInteger)((Object)entry.getValue());
            if (rebuildCounter.get() == 0) continue;
            this.logger.severe(String.format("Rebuilding Merkle trees during Hot Restart for map '%s' has failed on %d partitions, Hot Restart continues. Restarting this node after the cluster successfully restarted rebuilds the Merkle trees.", mapName, rebuildCounter.get()));
        }
    }

    private Executor internalAsyncExecutor() {
        return this.node.getNodeEngine().getExecutionService().getExecutor("hz:async");
    }

    public boolean backup(long sequence) {
        if (this.hotRestartBackupDir == null) {
            this.logger.warning("Aborting hot backup, backup dir is not configured");
            return false;
        }
        if (this.isBackupInProgress()) {
            this.logger.fine("Hot backup is already in progress, ignoring request for new backup");
            return false;
        }
        this.logger.info("Starting new hot backup with sequence " + sequence);
        File backupDir = this.getBackupDir(sequence);
        HotRestartIntegrationService.ensureDir(backupDir);
        this.persistentConfigDescriptors.backup(backupDir);
        this.clusterMetadataManager.backup(backupDir);
        this.backup(backupDir, this.onHeapStores, true);
        this.backup(backupDir, this.offHeapStores, false);
        return true;
    }

    public File getBackupDir(long sequence) {
        File backupDir = new File(this.hotRestartBackupDir, "backup-" + sequence);
        return this.legacyHotRestartDir ? backupDir : new File(backupDir, this.hotRestartHome.getName());
    }

    public boolean isBackupInProgress() {
        return HotRestartIntegrationService.isBackupInProgress(this.onHeapStores) || HotRestartIntegrationService.isBackupInProgress(this.offHeapStores);
    }

    private static boolean isBackupInProgress(HotRestartStore[] stores) {
        if (stores != null) {
            for (HotRestartStore store : stores) {
                if (!store.getBackupTaskState().inProgress()) continue;
                return true;
            }
        }
        return false;
    }

    private static void interruptBackupTask(HotRestartStore[] stores) {
        if (stores != null) {
            for (HotRestartStore store : stores) {
                if (!store.getBackupTaskState().inProgress()) continue;
                store.interruptBackupTask();
            }
        }
    }

    static BackupTaskStatus getBackupTaskStatus(HotRestartStore[] stores) {
        if (stores == null) {
            return new BackupTaskStatus(BackupTaskState.NO_TASK, 0, 0);
        }
        int failed = 0;
        int succeeded = 0;
        int inprogress = 0;
        block6: for (HotRestartStore store : stores) {
            BackupTaskState state = store.getBackupTaskState();
            switch (state) {
                case NO_TASK: {
                    continue block6;
                }
                case NOT_STARTED: 
                case IN_PROGRESS: {
                    ++inprogress;
                    continue block6;
                }
                case FAILURE: {
                    ++failed;
                    continue block6;
                }
                case SUCCESS: {
                    ++succeeded;
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Unsupported hot backup task state : " + String.valueOf((Object)state));
                }
            }
        }
        BackupTaskState overall = inprogress > 0 ? BackupTaskState.IN_PROGRESS : (failed > 0 ? BackupTaskState.FAILURE : (succeeded > 0 ? BackupTaskState.SUCCESS : BackupTaskState.NO_TASK));
        return new BackupTaskStatus(overall, failed + succeeded, stores.length);
    }

    private void backup(File backupDir, HotRestartStore[] stores, boolean onHeap) {
        if (stores != null) {
            for (int i = 0; i < this.storeCount; ++i) {
                File storeDir = this.storeDir(i, onHeap);
                File targetStoreDir = new File(backupDir, storeDir.getName());
                HotRestartIntegrationService.ensureDir(targetStoreDir);
                stores[i].backup(targetStoreDir);
            }
        }
    }

    private static void ensureDir(File dir) {
        try {
            File canonicalDir = dir.getCanonicalFile();
            if (canonicalDir.exists()) {
                throw new HotRestartException("Path already exists : " + String.valueOf(canonicalDir));
            }
            if (!canonicalDir.exists() && !canonicalDir.mkdirs()) {
                throw new HotRestartException("Could not create the directory " + String.valueOf(canonicalDir));
            }
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    @Override
    public boolean isStartCompleted() {
        return this.clusterMetadataManager.isStartCompleted();
    }

    @Override
    public boolean triggerForceStart() {
        OperationServiceImpl operationService = this.node.nodeEngine.getOperationService();
        Address masterAddress = this.node.getMasterAddress();
        if (this.node.isMaster()) {
            this.logger.info("Force start has been requested. Handling request...");
            return this.clusterMetadataManager.handleForceStartRequest();
        }
        if (masterAddress != null) {
            this.logger.info("Force start has been requested. Delegating request to master " + String.valueOf(masterAddress));
            return operationService.send(new TriggerForceStartOnMasterOperation(false), masterAddress);
        }
        this.logger.warning("Force start not triggered because there is no master member");
        return false;
    }

    @Override
    public boolean triggerPartialStart() {
        OperationServiceImpl operationService = this.node.nodeEngine.getOperationService();
        Address masterAddress = this.node.getMasterAddress();
        if (this.node.isMaster()) {
            this.logger.info("Partial start has been requested. Handling request...");
            return this.clusterMetadataManager.handlePartialStartRequest();
        }
        if (masterAddress != null) {
            this.logger.info("Partial start has been requested. Delegating request to master " + String.valueOf(masterAddress));
            return operationService.send(new TriggerForceStartOnMasterOperation(true), masterAddress);
        }
        this.logger.warning("Partial start not triggered because there is no master member");
        return false;
    }

    public void shutdown() {
        this.logger.info("Shutting down hot-restart service.");
        long start = System.nanoTime();
        this.logger.fine("Shutting down cluster metadata manager");
        this.clusterMetadataManager.shutdown();
        this.logger.fine("Closing all hot-restart stores");
        this.closeHotRestartStores();
        this.logger.fine("Closing encryption subsystem");
        this.encryptionHelper.dispose();
        this.directoryLock.release();
        if (this.logger.isFineEnabled()) {
            long end = System.nanoTime();
            this.logger.fine("Hot-restart service shutdown took " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms.");
        }
    }

    private int persistedStoreCount() {
        if (!this.hotRestartHome.exists()) {
            return 0;
        }
        File[] stores = this.hotRestartHome.listFiles(f -> f.isDirectory() && f.getName().matches(STORE_NAME_PATTERN));
        return stores != null ? stores.length : 0;
    }

    private RamStoreRegistry ramStoreRegistryForPrefix(long prefix) {
        ConfigDescriptor configDescriptor;
        RamStoreRegistry registry = this.ramStoreRegistryPrefixMap.get(prefix);
        if (registry == null && (configDescriptor = this.persistentConfigDescriptors.getDescriptor(prefix)) != null && (registry = this.ramStoreRegistryServiceMap.get(configDescriptor.getServiceName())) != null) {
            this.ramStoreRegistryPrefixMap.put(prefix, registry);
        }
        if (registry == null) {
            throw new IllegalArgumentException("No RamStore registered under prefix " + prefix);
        }
        return registry;
    }

    private void createHotRestartStores() {
        int i;
        HazelcastMemoryManager memMgr = ((EnterpriseNodeExtension)this.node.getNodeExtension()).getMemoryManager();
        HotRestartStore[] stores = new HotRestartStore[this.storeCount];
        for (i = 0; i < this.storeCount; ++i) {
            stores[i] = HotRestartModule.newOnHeapHotRestartStore(this.newHotRestartStoreConfig(i, true), this.node.getProperties());
        }
        this.onHeapStores = stores;
        if (memMgr != null) {
            stores = new HotRestartStore[this.storeCount];
            for (i = 0; i < this.storeCount; ++i) {
                stores[i] = HotRestartModule.newOffHeapHotRestartStore(this.newHotRestartStoreConfig(i, false).setMalloc(memMgr.getSystemAllocator()), this.node.getProperties());
            }
            this.offHeapStores = stores;
        }
    }

    private HotRestartStoreConfig newHotRestartStoreConfig(int storeId, boolean onheap) {
        File dir = this.storeDir(storeId, onheap);
        String name = ThreadUtil.createThreadName(this.node.hazelcastInstance.getName(), dir.getName());
        HotRestartStoreEncryptionConfig encryptionConfig = new HotRestartStoreEncryptionConfig().setCipherBuilder(this.encryptionHelper.newCipherBuilder()).setInitialKeysSupplier(this.encryptionHelper).setKeySize(this.encryptionHelper.getKeySize());
        return new HotRestartStoreConfig().setStoreName(name).setHomeDir(dir).setRamStoreRegistry(this).setLoggingService(this.node.loggingService).setMetricsRegistry(this.node.nodeEngine.getMetricsRegistry()).setEncryptionConfig(encryptionConfig);
    }

    private void runRestarterPipeline(HotRestartStore[] stores, final boolean failIfAnyData) throws Throwable {
        if (stores == null) {
            return;
        }
        assert (stores.length == this.storeCount);
        long deadline = HotRestartIntegrationService.cappedSum(Clock.currentTimeMillis(), this.dataLoadTimeoutMillis);
        this.partitionThreadCount = this.getOperationExecutor().getPartitionThreadCount();
        final RamStoreRestartLoop loop = new RamStoreRestartLoop(stores.length, this.partitionThreadCount, this, this.logger);
        final AtomicReference<Throwable> failure = new AtomicReference<Throwable>();
        Thread[] restartThreads = new Thread[stores.length];
        for (int i = 0; i < stores.length; ++i) {
            final int n = i;
            final HotRestartStore store = stores[n];
            restartThreads[i] = new Thread(store.name() + ".restart-thread"){

                @Override
                public void run() {
                    try {
                        store.hotRestart(failIfAnyData, HotRestartIntegrationService.this.storeCount, loop.keyReceivers[n], loop.keyHandleSenders[n], loop.valueReceivers[n]);
                    }
                    catch (Throwable t) {
                        failure.compareAndSet(null, t);
                        HotRestartIntegrationService.this.logger.severe("Restart thread failed", t);
                    }
                }
            };
        }
        for (Thread t : restartThreads) {
            t.start();
        }
        CountDownLatch doneLatch = new CountDownLatch(this.partitionThreadCount);
        this.getOperationExecutor().executeOnPartitionThreads(() -> {
            try {
                MemoryAdjuster.HOT_RESTART_LOADING_IN_PROGRESS.set(true);
                loop.run(((OperationThread)Thread.currentThread()).getThreadId());
            }
            catch (Throwable t) {
                failure.compareAndSet(null, t);
            }
            finally {
                doneLatch.countDown();
                MemoryAdjuster.HOT_RESTART_LOADING_IN_PROGRESS.set(false);
            }
        });
        try {
            this.awaitCompletionOnPartitionThreads(doneLatch, deadline);
        }
        catch (Throwable throwable) {
            failure.compareAndSet(null, throwable);
            for (Thread thr : restartThreads) {
                thr.interrupt();
            }
        }
        for (Thread thr : restartThreads) {
            thr.join(Math.max(1L, deadline - Clock.currentTimeMillis()));
            if (!thr.isAlive()) continue;
            failure.compareAndSet(null, new HotRestartException("Timed out waiting for a restartThread to complete"));
        }
        Throwable throwable = (Throwable)failure.get();
        if (throwable != null) {
            throw throwable;
        }
    }

    private void awaitCompletionOnPartitionThreads(CountDownLatch doneLatch, long deadline) throws InterruptedException {
        do {
            if (Clock.currentTimeMillis() > deadline) {
                throw new HotRestartException("Hot Restart timed out");
            }
            if (this.node.getState() == NodeState.SHUT_DOWN) {
                throw new HotRestartException("Node is already shut down");
            }
            HotRestartClusterStartStatus hotRestartStatus = this.clusterMetadataManager.getHotRestartStatus();
            Set<UUID> excludedMemberUuids = this.clusterMetadataManager.getExcludedMemberUuids();
            if (hotRestartStatus != HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED || !excludedMemberUuids.contains(this.node.getThisUuid())) continue;
            throw new ForceStartException();
        } while (!doneLatch.await(1L, TimeUnit.SECONDS));
    }

    @Override
    public void forceStartBeforeJoin() {
        if (this.isStartCompleted()) {
            throw new HotRestartException("cannot reset hot restart data since node has already started!");
        }
        Set<UUID> excludedMemberUuids = this.clusterMetadataManager.getExcludedMemberUuids();
        if (!excludedMemberUuids.contains(this.node.getThisUuid())) {
            throw new HotRestartException("cannot reset hot restart data since this node is not excluded! excluded member UUIDs: " + String.valueOf(excludedMemberUuids));
        }
        this.handleForceStart(false);
    }

    private void handleForceStart(boolean isAfterJoin) {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        if (!isAfterJoin && clusterService.isJoined()) {
            this.logger.info("No need to reset hot restart data since node is joined and it will force-start itself.");
            return;
        }
        this.logger.warning("Force start requested, skipping hot restart");
        this.resetNode();
        this.node.getJoiner().setTargetAddress(null);
        this.logger.info("Resetting cluster state to ACTIVE");
        clusterService.reset();
        this.node.getPartitionService().reset();
        this.resetService(isAfterJoin);
        this.node.server.start();
        if (isAfterJoin) {
            this.logger.info("Joining back...");
            this.deferredPostJoinOp.set(null);
            this.node.join();
            this.clusterMetadataManager.forceStartCompleted();
            this.executeDeferredPostJoinOp();
        }
    }

    private void resetNode() {
        this.logger.info("Stopping connection manager...");
        this.node.server.stop();
        this.logger.info("Resetting node...");
        this.node.reset();
        this.logger.info("Resetting NodeEngine...");
        this.node.nodeEngine.reset();
        this.logger.fine("Resetting all services...");
        Collection<ManagedService> managedServices = this.node.nodeEngine.getServices(ManagedService.class);
        for (ManagedService service : managedServices) {
            if (service instanceof ClusterService) continue;
            service.reset();
        }
    }

    @Override
    public void resetService(boolean isAfterJoin) {
        this.logger.info("Closing Hot Restart stores");
        this.closeHotRestartStores();
        this.clusterMetadataManager.stopPersistence();
        this.logger.info("Deleting contents of Hot Restart base-dir " + String.valueOf(this.hotRestartHome));
        this.directoryLock.release();
        this.deletePersistedData();
        this.directoryLock = DirectoryLock.lockForDirectory(this.hotRestartHome, this.logger);
        this.logger.info("Resetting hot restart cluster metadata service...");
        this.clusterMetadataManager.reset(isAfterJoin);
        this.clusterMetadataManager.onClusterStateChange(ClusterState.ACTIVE);
        this.clusterMetadataManager.writePartitionThreadCount(this.getOperationExecutor().getPartitionThreadCount());
        this.persistentConfigDescriptors.reset();
        this.rejoiningActiveCluster.set(false);
        this.deferredPostJoinOp.set(null);
        this.deferredPartitionRuntimeState.set(null);
        this.resetClusterTopologyIntentOnMaster();
        if (!isAfterJoin) {
            this.clusterMetadataManager.prepare();
        }
        this.logger.info("Creating thread local hot restart stores");
        this.createHotRestartStores();
        if (isAfterJoin) {
            try {
                this.runRestarterPipeline(this.onHeapStores, true);
                this.runRestarterPipeline(this.offHeapStores, true);
            }
            catch (Throwable t) {
                throw new HotRestartException("Starting hot restart threads failed!", t);
            }
        }
    }

    private void deletePersistedData() {
        File[] subFiles = this.hotRestartHome.listFiles();
        if (subFiles != null) {
            for (File sf : subFiles) {
                IOUtil.delete(sf);
            }
        }
    }

    private OperationExecutor getOperationExecutor() {
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        OperationServiceImpl operationService = nodeEngine.getOperationService();
        return operationService.getOperationExecutor();
    }

    private File storeDir(int storeId, boolean onheap) {
        return new File(this.hotRestartHome, "s" + storeId + (onheap ? (char)'0' : '1'));
    }

    private int storeIndexForPartition(int partitionId) {
        return this.getOperationExecutor().getPartitionThreadId(partitionId) % this.storeCount;
    }

    private void closeHotRestartStores() {
        HotRestartStore[] stores = this.onHeapStores;
        this.onHeapStores = null;
        if (stores != null) {
            for (HotRestartStore st : stores) {
                st.close();
            }
        }
        stores = this.offHeapStores;
        this.offHeapStores = null;
        if (stores != null) {
            for (HotRestartStore st : stores) {
                st.close();
            }
        }
    }

    private static long cappedSum(long a2, long b) {
        assert (a2 >= 0L) : "a is negative";
        assert (b >= 0L) : "b is negative";
        long sum = a2 + b;
        return sum >= 0L ? sum : Long.MAX_VALUE;
    }

    void interruptBackupTask() {
        this.logger.info("Interrupting hot backup tasks");
        HotRestartIntegrationService.interruptBackupTask(this.offHeapStores);
        HotRestartIntegrationService.interruptBackupTask(this.onHeapStores);
    }

    BackupTaskStatus getBackupTaskStatus() {
        BackupTaskStatus offHeapStatus = HotRestartIntegrationService.getBackupTaskStatus(this.offHeapStores);
        BackupTaskStatus onHeapStatus = HotRestartIntegrationService.getBackupTaskStatus(this.onHeapStores);
        BackupTaskState offHeapState = offHeapStatus.getState();
        BackupTaskState onHeapState = onHeapStatus.getState();
        BackupTaskState state = offHeapState.inProgress() || onHeapState.inProgress() ? BackupTaskState.IN_PROGRESS : (offHeapState == BackupTaskState.FAILURE || onHeapState == BackupTaskState.FAILURE ? BackupTaskState.FAILURE : (offHeapState == BackupTaskState.NO_TASK && onHeapState == BackupTaskState.NO_TASK ? BackupTaskState.NO_TASK : BackupTaskState.SUCCESS));
        return new BackupTaskStatus(state, offHeapStatus.getCompleted() + onHeapStatus.getCompleted(), offHeapStatus.getTotal() + onHeapStatus.getTotal());
    }

    @Override
    public boolean isMemberExcluded(Address memberAddress, UUID memberUuid) {
        return this.getExcludedMemberUuids().contains(memberUuid);
    }

    @Override
    public Set<UUID> getExcludedMemberUuids() {
        return this.clusterMetadataManager.getExcludedMemberUuids();
    }

    public void onInitialClusterState(ClusterState initialState) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("ClusterState: " + String.valueOf((Object)initialState) + ", isStartWithHotRestart: " + this.clusterMetadataManager.isStartWithHotRestart() + ", rejoiningActiveCluster: " + String.valueOf(this.rejoiningActiveCluster.get()));
        }
        if (this.clusterMetadataManager.isStartWithHotRestart() && initialState.isJoinAllowed() && this.rejoiningActiveCluster.get().booleanValue()) {
            this.clusterMetadataManager.setRejoiningClusterInActiveState(true);
        } else {
            if (!this.autoRemoveStaleData) {
                return;
            }
            if (this.clusterMetadataManager.isStartWithHotRestart() && initialState.isJoinAllowed()) {
                UUID thisUuid = this.node.getThisUuid();
                if (this.isMemberExcluded(this.node.getThisAddress(), thisUuid)) {
                    return;
                }
                String message = "Cannot join the cluster with state " + String.valueOf((Object)initialState) + ". Will initiate a force start after removing Hot Restart data.";
                this.logger.warning(message);
                this.handleExcludedMemberUuids(this.node.getMasterAddress(), Collections.singleton(thisUuid));
            }
        }
    }

    @Override
    public void notifyExcludedMember(Address memberAddress) {
        Set<UUID> excludedMemberUuids = this.clusterMetadataManager.getExcludedMemberUuids();
        OperationServiceImpl operationService = this.node.nodeEngine.getOperationService();
        operationService.send(new SendExcludedMemberUuidsOperation(excludedMemberUuids), memberAddress);
    }

    @Override
    public void handleExcludedMemberUuids(Address sender, Set<UUID> excludedMemberUuids) {
        if (!excludedMemberUuids.contains(this.node.getThisUuid())) {
            this.logger.warning("Should handle final cluster start result with excluded member UUIDs: " + String.valueOf(excludedMemberUuids) + " within hot restart service since this member is not excluded. sender: " + String.valueOf(sender));
            return;
        }
        this.clusterMetadataManager.receiveHotRestartStatus(sender, HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED, excludedMemberUuids, null);
    }

    @Override
    public ClusterHotRestartStatusDTO getCurrentClusterHotRestartStatus() {
        return ClusterHotRestartStatusDTOUtil.create(this.clusterMetadataManager);
    }

    @Override
    public void waitPartitionReplicaSyncOnCluster(long timeout, TimeUnit unit, Supplier<SafeStateCheckOperation> operationSupplier) {
        boolean retryRequired;
        Collection<Member> members;
        int success;
        ClusterServiceImpl clusterService = this.node.getClusterService();
        ClusterState clusterState = clusterService.getClusterState();
        if (clusterState != ClusterState.PASSIVE) {
            throw new IllegalStateException("Cluster should be in PASSIVE state! Current state is " + String.valueOf((Object)clusterState));
        }
        long timeoutNanos = unit.toNanos(timeout);
        long startTimeNanos = System.nanoTime();
        block2: do {
            success = 0;
            retryRequired = false;
            members = clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
            OperationServiceImpl operationService = this.node.nodeEngine.getOperationService();
            for (Member member : clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR)) {
                while (System.nanoTime() - startTimeNanos < timeoutNanos) {
                    SafeStateCheckOperation operation = operationSupplier.get();
                    try {
                        InvocationFuture future = operationService.invokeOnTarget("hz:core:partitionService", operation, member.getAddress());
                        boolean safe = (Boolean)future.get();
                        if (safe) {
                            ++success;
                            break;
                        }
                        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                    }
                    catch (Exception e) {
                        retryRequired = this.handleExceptionOnWait(e);
                        break;
                    }
                }
                if (!retryRequired) continue;
                continue block2;
            }
        } while (success < members.size() && retryRequired && System.nanoTime() - startTimeNanos < timeoutNanos);
        if (success < clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).size()) {
            throw new IllegalStateException(new TimeoutException("Time out while syncing partition replicas"));
        }
    }

    private boolean handleExceptionOnWait(Exception e) {
        if (e instanceof TargetNotMemberException || e.getCause() instanceof TargetNotMemberException) {
            this.logger.fine("Target is not a member, refreshing the members list and retrying.");
            return true;
        }
        throw new IllegalStateException("Error while syncing partition replicas", e);
    }

    @Override
    public void setRejoiningActiveCluster(boolean rejoiningActiveCluster) {
        this.rejoiningActiveCluster.compareAndSet(null, rejoiningActiveCluster);
    }

    @Override
    public void setClusterTopologyIntentOnMaster(ClusterTopologyIntent clusterTopologyIntent) {
        this.clusterTopologyIntentOnMaster = clusterTopologyIntent;
        this.clusterMetadataManager.setClusterTopologyIntentOnMaster(clusterTopologyIntent);
        if (this.clusterTopologyIntentOnMaster == ClusterTopologyIntent.CLUSTER_START) {
            this.node.initializeClusterTopologyIntent(this.clusterTopologyIntentOnMaster);
        }
    }

    @Override
    public boolean isClusterMetadataFoundOnDisk() {
        return this.clusterMetadataManager.isStartWithHotRestart();
    }

    @Override
    public void onClusterTopologyIntentChange() {
        this.clusterMetadataManager.onMembershipChange();
    }

    @Override
    public void onMemberLeft(Member member, ClusterState clusterState) {
        this.clusterMetadataManager.onMemberLeft(member, clusterState);
    }

    @Override
    public void onMemberJoined(Member member) {
        this.clusterMetadataManager.onMemberJoined(member);
    }

    public ClusterTopologyIntent getClusterTopologyIntentOnMaster() {
        return this.clusterTopologyIntentOnMaster;
    }

    private void resetClusterTopologyIntentOnMaster() {
        this.clusterTopologyIntentOnMaster = ClusterTopologyIntent.IN_MANAGED_CONTEXT_UNKNOWN;
        this.clusterMetadataManager.setClusterTopologyIntentOnMaster(this.clusterTopologyIntentOnMaster);
    }

    public boolean isClusterWideStart() {
        return !this.node.isClusterStateManagementAutomatic() || this.node.clusterService.isMaster() ? this.node.getClusterTopologyIntent() == ClusterTopologyIntent.CLUSTER_START : this.clusterTopologyIntentOnMaster == ClusterTopologyIntent.CLUSTER_START;
    }

    public File getHotRestartHome() {
        return this.hotRestartHome;
    }

    private void rotateEncryptionKey(byte[] key) {
        this.rotateEncryptionKey(key, this.onHeapStores);
        this.rotateEncryptionKey(key, this.offHeapStores);
    }

    private void rotateEncryptionKey(byte[] key, HotRestartStore[] stores) {
        if (stores != null) {
            for (int i = 0; i < this.storeCount; ++i) {
                stores[i].rotateMasterEncryptionKey(key);
            }
        }
    }

    private class MarkReplicasAsSyncRequired
    implements PartitionSpecificRunnable {
        private final PartitionReplicaVersionManager partitionReplicaVersionManager;
        private final int maxBackupCount;
        private final int partitionId;
        private final CountDownLatch completionLatch;
        private final InternalPartition partition;

        MarkReplicasAsSyncRequired(PartitionReplicaVersionManager partitionReplicaVersionManager, InternalPartition partition, int maxBackupCount, CountDownLatch completionLatch) {
            this.partitionReplicaVersionManager = partitionReplicaVersionManager;
            this.partition = partition;
            this.partitionId = partition.getPartitionId();
            this.maxBackupCount = maxBackupCount;
            this.completionLatch = completionLatch;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MemberImpl localMember = HotRestartIntegrationService.this.node.getLocalMember();
                for (int replicaIndex = 1; replicaIndex <= this.maxBackupCount; ++replicaIndex) {
                    Collection<ServiceNamespace> namespaces = HotRestartIntegrationService.this.getNamespaces(replicaIndex);
                    if (namespaces.isEmpty()) continue;
                    namespaces.forEach(ns -> this.partitionReplicaVersionManager.getPartitionReplicaVersions(this.partitionId, (ServiceNamespace)ns));
                    if (this.partition.getReplica(replicaIndex) == null || !this.partition.getReplica(replicaIndex).isIdentical(localMember)) continue;
                    for (ServiceNamespace namespace : namespaces) {
                        this.partitionReplicaVersionManager.markPartitionReplicaAsSyncRequired(this.partitionId, namespace, replicaIndex);
                        ((PartitionReplicaManager)this.partitionReplicaVersionManager).triggerPartitionReplicaSync(this.partitionId, namespaces, replicaIndex);
                    }
                }
            }
            finally {
                this.completionLatch.countDown();
            }
        }
    }
}

