/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.tree.impl;

import com.hazelcast.internal.elastic.tree.OffHeapComparator;
import com.hazelcast.internal.elastic.tree.OffHeapTreeEntry;
import com.hazelcast.internal.elastic.tree.OffHeapTreeStore;
import com.hazelcast.internal.elastic.tree.OrderingDirection;
import com.hazelcast.internal.elastic.tree.impl.EntryIterator;
import com.hazelcast.internal.elastic.tree.impl.RedBlackTreeNode;
import com.hazelcast.internal.memory.HeapMemoryAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.util.HashSet;
import java.util.Iterator;

public class RedBlackTreeStore
implements OffHeapTreeStore {
    private static final RedBlackTreeNode NIL = new RedBlackTreeNode();
    private boolean assertOn;
    private final MemoryAllocator malloc;
    private final OffHeapComparator offHeapKeyComparator;
    private final RedBlackTreeNode nodeCached;
    private final RedBlackTreeNode leftCached;
    private final RedBlackTreeNode rightCached;
    private RedBlackTreeNode root;

    public RedBlackTreeStore(MemoryAllocator malloc, OffHeapComparator offHeapKeyComparator) {
        this(malloc, offHeapKeyComparator, false);
    }

    public RedBlackTreeStore(MemoryAllocator malloc, OffHeapComparator offHeapKeyComparator, boolean disableConsistencyAssertions) {
        this.malloc = malloc;
        this.offHeapKeyComparator = offHeapKeyComparator;
        this.nodeCached = RedBlackTreeNode.of(this, malloc, 0L);
        this.leftCached = RedBlackTreeNode.of(this, malloc, 0L);
        this.rightCached = RedBlackTreeNode.of(this, malloc, 0L);
        this.assertOn = !disableConsistencyAssertions && this.getClass().desiredAssertionStatus();
    }

    @Override
    public OffHeapTreeEntry put(MemoryBlock key, MemoryBlock value) {
        return this.put(key, value, this.offHeapKeyComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapTreeEntry put(MemoryBlock key, MemoryBlock value, OffHeapComparator comparator) {
        this.checkNotNull(key, KeyType.OFF_HEAP);
        this.checkNotNull(value, KeyType.OFF_HEAP);
        try {
            if (this.root == null) {
                this.setRoot(this.createNewNode(key, value));
                OffHeapTreeEntry offHeapTreeEntry = this.root.entry();
                return offHeapTreeEntry;
            }
            LookupResult result = this.lookup(key, KeyType.OFF_HEAP, comparator);
            if (result.isExactMatch) {
                RedBlackTreeNode.Entry entry = (RedBlackTreeNode.Entry)result.node.entry();
                entry.addValue(value);
                RedBlackTreeNode.Entry entry2 = entry;
                return entry2;
            }
            RedBlackTreeNode node = this.createNewLeaf(key, value, result.node, result.side);
            OffHeapTreeEntry offHeapTreeEntry = node.entry();
            return offHeapTreeEntry;
        }
        finally {
            this.assertNoInconsistencies();
        }
    }

    @Override
    public OffHeapTreeEntry getEntry(MemoryBlock key) {
        return this.getEntry(key, KeyType.OFF_HEAP, this.offHeapKeyComparator);
    }

    @Override
    public OffHeapTreeEntry getEntry(HeapData key) {
        return this.getEntry(key, KeyType.ON_HEAP, this.offHeapKeyComparator);
    }

    @Override
    public OffHeapTreeEntry getEntry(MemoryBlock key, OffHeapComparator comparator) {
        return this.getEntry(key, KeyType.OFF_HEAP, comparator == null ? this.offHeapKeyComparator : comparator);
    }

    private OffHeapTreeEntry getEntry(Object key, KeyType keyType, OffHeapComparator comparator) {
        LookupResult result = this.lookup(key, keyType, comparator);
        return result.isExactMatch && result.node != null ? result.node.entry() : null;
    }

    @Override
    public OffHeapTreeEntry searchEntry(MemoryBlock key) {
        LookupResult result = this.lookup(key, KeyType.OFF_HEAP, this.offHeapKeyComparator);
        return result.node != null ? result.node.entry() : null;
    }

    @Override
    public void dispose(boolean releasePayload) {
        if (this.root != null) {
            this.root.dispose(releasePayload);
            this.root = null;
        }
    }

    @Override
    public void remove(OffHeapTreeEntry entry) {
        RedBlackTreeNode child;
        RedBlackTreeNode node = ((RedBlackTreeNode.Entry)entry).node();
        if (node.isNil()) {
            throw new IllegalArgumentException("Invalid entry.");
        }
        byte origColor = node.color();
        if (node.left().isNil()) {
            child = node.right();
            this.transplant(node, child);
        } else if (node.right().isNil()) {
            child = node.left();
            this.transplant(node, child);
        } else {
            RedBlackTreeNode minChild = this.treeMin(node.right());
            origColor = minChild.color();
            child = minChild.right();
            if (!minChild.parent().equals(node)) {
                this.transplant(minChild, minChild.right());
                minChild.right(node.right());
                RedBlackTreeNode rightMinGrandChild = minChild.right();
                if (!rightMinGrandChild.isNil()) {
                    rightMinGrandChild.parent(minChild);
                }
            }
            this.transplant(node, minChild);
            RedBlackTreeNode leftChild = node.left();
            leftChild.parent(minChild);
            minChild.left(leftChild);
            minChild.color(node.color());
        }
        if (origColor == 0 && !child.isNil()) {
            this.removeFixUp(child);
        }
        node.clearSides();
        node.dispose();
        this.assertNoInconsistencies();
    }

    @Override
    public Iterator<OffHeapTreeEntry> iterator() {
        return this.entries();
    }

    @Override
    public Iterator<OffHeapTreeEntry> entries() {
        return this.entries(OrderingDirection.ASC);
    }

    @Override
    public Iterator<OffHeapTreeEntry> entries(OrderingDirection direction) {
        return new EntryIterator(this.root, direction);
    }

    @Override
    public Iterator<OffHeapTreeEntry> entries(OffHeapTreeEntry root) {
        return this.entries(root, OrderingDirection.ASC);
    }

    @Override
    public Iterator<OffHeapTreeEntry> entries(OffHeapTreeEntry entry, OrderingDirection direction) {
        return new EntryIterator(((RedBlackTreeNode.Entry)entry).node(), direction);
    }

    private void checkNotNull(Object blob, KeyType type) {
        if (blob == null || type.equals((Object)KeyType.OFF_HEAP) && ((MemoryBlock)blob).address() == 0L) {
            throw new IllegalArgumentException("Null blobs or null-address based, not allowed.");
        }
    }

    private void setRoot(RedBlackTreeNode node) {
        RedBlackTreeNode redBlackTreeNode = this.root = node.isNil() ? null : node;
        if (this.root != null) {
            this.root.parent(null);
        }
    }

    private LookupResult lookup(Object key, KeyType type, OffHeapComparator comparator) {
        this.checkNotNull(key, type);
        if (this.root == null) {
            return new LookupResult(null, true);
        }
        this.nodeCached.reset(this.root.address());
        this.leftCached.reset();
        this.rightCached.reset();
        while (true) {
            int compareResult;
            if ((compareResult = this.compareKeys(comparator, key, type, this.nodeCached)) > 0) {
                this.rightCached.reset(this.nodeCached.rightAddress());
                if (this.rightCached.isNil()) {
                    return new LookupResult(this.nodeCached, false, 0);
                }
                this.nodeCached.reset(this.rightCached.address());
                continue;
            }
            if (compareResult >= 0) break;
            this.leftCached.reset(this.nodeCached.leftAddress());
            if (this.leftCached.isNil()) {
                return new LookupResult(this.nodeCached, false, 1);
            }
            this.nodeCached.reset(this.leftCached.address());
        }
        return new LookupResult(this.nodeCached, true);
    }

    private RedBlackTreeNode createNewNode(MemoryBlock key, MemoryBlock value) {
        RedBlackTreeNode node = null;
        try {
            node = RedBlackTreeNode.newNode(this, this.malloc);
            RedBlackTreeNode.Entry entry = (RedBlackTreeNode.Entry)node.entry();
            entry.setKey(key);
            entry.addValue(value);
            return node;
        }
        catch (NativeOutOfMemoryError | Exception ex) {
            if (node != null) {
                node.dispose();
            }
            throw ExceptionUtil.rethrow(ex);
        }
    }

    private RedBlackTreeNode createNewLeaf(MemoryBlock key, MemoryBlock value, RedBlackTreeNode parent, byte side) {
        RedBlackTreeNode node = this.createNewNode(key, value);
        node.color((byte)1);
        node.parent(parent);
        if (side == 1) {
            parent.left(node);
        } else {
            parent.right(node);
        }
        this.checkRedBlackConsistency(parent, node, side);
        return node;
    }

    private void checkRedBlackConsistency(RedBlackTreeNode father, RedBlackTreeNode son, byte sonSide) {
        if (father == null) {
            this.root.color((byte)0);
            return;
        }
        RedBlackTreeNode grandFather = father.parent();
        if (father.color() == 0) {
            return;
        }
        byte fathersSide = father.side();
        RedBlackTreeNode uncle = fathersSide == 1 ? grandFather.right() : grandFather.left();
        if (!uncle.isNil() && this.case1(father, grandFather, uncle)) {
            return;
        }
        if (sonSide != fathersSide) {
            this.case2(father, son, sonSide, grandFather, fathersSide);
            RedBlackTreeNode tmp = father;
            father = son;
            son = tmp;
            sonSide = son.side();
            fathersSide = father.side();
        }
        if (sonSide == fathersSide && this.case3(father, sonSide, grandFather, fathersSide)) {
            return;
        }
        this.root.color((byte)0);
    }

    private boolean case3(RedBlackTreeNode father, byte sonSide, RedBlackTreeNode grandFather, byte fathersSide) {
        if (grandFather.isNil()) {
            return true;
        }
        RedBlackTreeNode grandFathersParent = grandFather.parent();
        if (grandFathersParent == null) {
            this.setRoot(father);
        } else {
            byte grandFathersSide = grandFather.side();
            if (grandFathersSide == 1) {
                grandFathersParent.left(father);
            } else {
                grandFathersParent.right(father);
            }
            father.parent(grandFathersParent);
        }
        RedBlackTreeNode fathersRight = father.right();
        RedBlackTreeNode fathersLeft = father.left();
        if (sonSide == 1) {
            father.right(grandFather);
            grandFather.left(fathersRight);
            grandFather.parent(father);
            if (!fathersRight.isNil()) {
                fathersRight.parent(grandFather);
            }
        } else {
            father.left(grandFather);
            grandFather.right(fathersLeft);
            grandFather.parent(father);
            if (!fathersLeft.isNil()) {
                fathersLeft.parent(grandFather);
            }
        }
        grandFather.color((byte)1);
        father.color((byte)0);
        grandFather.side(fathersSide == 1 ? (byte)0 : 1);
        return false;
    }

    private void case2(RedBlackTreeNode father, RedBlackTreeNode son, byte sonSide, RedBlackTreeNode grandFather, byte fathersSide) {
        RedBlackTreeNode sonsChild;
        if (fathersSide == 1) {
            grandFather.left(son);
        } else {
            grandFather.right(son);
        }
        RedBlackTreeNode redBlackTreeNode = sonsChild = sonSide == 0 ? son.left() : son.right();
        if (sonSide == 0) {
            father.right(sonsChild);
        } else {
            father.left(sonsChild);
        }
        if (!sonsChild.isNil()) {
            sonsChild.parent(father);
        }
        if (sonSide == 0) {
            son.left(father);
        } else {
            son.right(father);
        }
        father.parent(son);
        son.parent(grandFather);
    }

    private boolean case1(RedBlackTreeNode father, RedBlackTreeNode grandfather, RedBlackTreeNode uncle) {
        byte uncleColor = uncle.color();
        if (uncleColor == 1) {
            uncle.color((byte)0);
            father.color((byte)0);
            if (!grandfather.isNil()) {
                grandfather.color((byte)1);
                byte grandFatherSide = grandfather.side();
                RedBlackTreeNode grandFatherParent = grandfather.parent();
                this.checkRedBlackConsistency(grandFatherParent, grandfather, grandFatherSide);
            } else {
                this.root.color((byte)0);
            }
            return true;
        }
        return false;
    }

    private int compareKeys(OffHeapComparator comparator, Object key, KeyType type, RedBlackTreeNode node) {
        MemoryBlock against = node.entry().getKey();
        if (type.equals((Object)KeyType.OFF_HEAP)) {
            return comparator.compare((MemoryBlock)key, against);
        }
        byte[] againstBlob = new byte[against.size() - 4];
        against.copyTo(4L, againstBlob, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET, againstBlob.length);
        return comparator.compare(((Data)key).toByteArray(), againstBlob);
    }

    private RedBlackTreeNode treeMin(RedBlackTreeNode entry) {
        RedBlackTreeNode leftChild;
        RedBlackTreeNode minEntry = entry;
        while (!(leftChild = minEntry.left()).isNil()) {
            minEntry = leftChild;
        }
        return minEntry;
    }

    private void transplant(RedBlackTreeNode which, RedBlackTreeNode with) {
        assert (!which.equals(with));
        if (this.root.equals(which)) {
            this.setRoot(with);
            return;
        }
        RedBlackTreeNode parent = which.parent();
        assert (parent != null) : "Parent can't be NIL since src isn't ROOT. root: " + String.valueOf(this.root) + ", src: " + String.valueOf(which) + ", root_parent: " + String.valueOf(this.root.parent());
        RedBlackTreeNode entryParentLeftChildAddress = parent.left();
        if (which.equals(entryParentLeftChildAddress)) {
            assert (!which.equals(parent.right()));
            parent.left(with);
        } else {
            parent.right(with);
        }
        if (!with.isNil()) {
            with.parent(parent);
        }
    }

    private void rotateRight(RedBlackTreeNode node) {
        RedBlackTreeNode parent = node.parent();
        RedBlackTreeNode leftChild = node.left();
        if (leftChild.isNil()) {
            return;
        }
        RedBlackTreeNode leftChildsRightChild = leftChild.right();
        node.left(leftChildsRightChild);
        if (!leftChildsRightChild.isNil()) {
            leftChildsRightChild.parent(node);
        }
        leftChild.parent(parent);
        if (this.root.equals(node)) {
            this.setRoot(leftChild);
        } else if (parent.right().equals(node)) {
            parent.right(leftChild);
        } else {
            parent.left(leftChild);
        }
        leftChild.right(node);
        node.parent(leftChild);
    }

    private void rotateLeft(RedBlackTreeNode node) {
        RedBlackTreeNode parent = node.parent();
        RedBlackTreeNode rightChild = node.right();
        if (rightChild.isNil()) {
            return;
        }
        RedBlackTreeNode rightChildsLeftChild = rightChild.left();
        node.right(rightChildsLeftChild);
        if (!rightChildsLeftChild.isNil()) {
            rightChildsLeftChild.parent(node);
        }
        rightChild.parent(parent);
        if (this.root.equals(node)) {
            this.setRoot(rightChild);
        } else if (parent.left().equals(node)) {
            parent.left(rightChild);
        } else {
            parent.right(rightChild);
        }
        rightChild.left(node);
        node.parent(rightChild);
    }

    private void removeFixUp(RedBlackTreeNode node) {
        while (!node.isNil() && !node.equals(this.root) && node.color() == 0) {
            RedBlackTreeNode fathersLeftChildsRightChild;
            RedBlackTreeNode father = node.parent();
            RedBlackTreeNode fathersLeftChild = father.left();
            RedBlackTreeNode fathersRightChild = father.right();
            if (node.equals(fathersLeftChild)) {
                RedBlackTreeNode fathersRightChildsRightChild;
                if (fathersRightChild.color() == 1) {
                    fathersRightChild.color((byte)0);
                    father.color((byte)1);
                    this.rotateLeft(father);
                    fathersRightChild = father.right();
                }
                RedBlackTreeNode fathersRightChildsLeftChild = fathersRightChild.isNil() ? NIL : fathersRightChild.left();
                RedBlackTreeNode redBlackTreeNode = fathersRightChildsRightChild = fathersRightChild.isNil() ? NIL : fathersRightChild.right();
                if (!fathersRightChild.isNil() && fathersRightChildsLeftChild.color() == 0 && fathersRightChildsRightChild.color() == 0) {
                    fathersRightChild.color((byte)1);
                    node = father;
                    continue;
                }
                if (!fathersRightChild.isNil() && fathersRightChildsRightChild.color() == 0) {
                    if (!fathersRightChildsLeftChild.isNil()) {
                        fathersRightChildsLeftChild.color((byte)0);
                    }
                    fathersRightChild.color((byte)1);
                    this.rotateRight(fathersRightChild);
                    fathersRightChild = father.right();
                    fathersRightChildsRightChild = fathersRightChild.isNil() ? NIL : fathersRightChild.right();
                    RedBlackTreeNode redBlackTreeNode2 = fathersRightChildsLeftChild = fathersRightChild.isNil() ? NIL : fathersRightChild.left();
                }
                if (!fathersRightChildsLeftChild.isNil()) {
                    fathersRightChild.color(father.color());
                    if (!fathersRightChildsRightChild.isNil()) {
                        fathersRightChildsRightChild.color((byte)0);
                    }
                }
                father.color((byte)0);
                this.rotateLeft(father);
                node = this.root;
                continue;
            }
            if (fathersLeftChild.color() == 1) {
                fathersLeftChild.color((byte)0);
                father.color((byte)1);
                this.rotateRight(father);
                fathersLeftChild = father.left();
            }
            RedBlackTreeNode fathersLeftChildsLeftChild = fathersLeftChild.isNil() ? NIL : fathersLeftChild.left();
            RedBlackTreeNode redBlackTreeNode = fathersLeftChildsRightChild = fathersLeftChild.isNil() ? NIL : fathersLeftChild.right();
            if (!fathersLeftChild.isNil() && fathersLeftChildsLeftChild.color() == 0 && fathersLeftChildsRightChild.color() == 0) {
                fathersLeftChild.color((byte)1);
                node = father;
                continue;
            }
            if (!fathersLeftChild.isNil() && fathersLeftChildsRightChild.color() == 0) {
                if (!fathersLeftChildsLeftChild.isNil()) {
                    fathersLeftChildsLeftChild.color((byte)0);
                }
                fathersLeftChild.color((byte)1);
                this.rotateLeft(fathersLeftChild);
                fathersLeftChild = father.left();
                fathersLeftChildsRightChild = fathersLeftChild.isNil() ? NIL : fathersLeftChild.right();
                RedBlackTreeNode redBlackTreeNode3 = fathersLeftChildsLeftChild = fathersLeftChild.isNil() ? NIL : fathersLeftChild.left();
            }
            if (!fathersLeftChildsLeftChild.isNil()) {
                fathersLeftChild.color(father.color());
                if (!fathersLeftChildsRightChild.isNil()) {
                    fathersLeftChildsRightChild.color((byte)0);
                }
            }
            father.color((byte)0);
            this.rotateRight(father);
            node = this.root;
        }
        node.color((byte)0);
    }

    private void assertNoInconsistencies() {
        if (!this.assertOn) {
            return;
        }
        HashSet<OffHeapTreeEntry> entries = new HashSet<OffHeapTreeEntry>();
        HashSet<MemoryBlock> keys = new HashSet<MemoryBlock>();
        for (OffHeapTreeEntry entry : this) {
            assert (!entries.contains(entry)) : "Tree in illegal state, entry: " + String.valueOf(entry) + " exists more than once.";
            entries.add(entry);
            assert (!keys.contains(entry.getKey())) : "Tree in illegal state, entry key: " + String.valueOf(entry.getKey()) + " is referenced more than once.";
            keys.add(entry.getKey());
            assert (entry.hasValues()) : "Tree in illegal state, entry: " + String.valueOf(entry) + " has no values.";
        }
    }

    private static enum KeyType {
        ON_HEAP,
        OFF_HEAP;

    }

    private static final class LookupResult {
        private final RedBlackTreeNode node;
        private final boolean isExactMatch;
        private final byte side;

        private LookupResult(RedBlackTreeNode node, boolean isExactMatch) {
            this(node, isExactMatch, -1);
        }

        private LookupResult(RedBlackTreeNode node, boolean isExactMatch, byte side) {
            this.node = node != null ? node.asNew() : null;
            this.isExactMatch = isExactMatch;
            this.side = side;
        }
    }
}

