/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.queue;

import com.hazelcast.internal.elastic.queue.ElasticQueue;
import com.hazelcast.internal.elastic.queue.LongConcurrentLinkedQueue;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import java.util.AbstractQueue;
import java.util.Iterator;

public final class ConcurrentLinkedElasticQueue<E>
extends AbstractQueue<E>
implements ElasticQueue<E> {
    private final LongConcurrentLinkedQueue queue;
    private final EnterpriseSerializationService ss;

    public ConcurrentLinkedElasticQueue(EnterpriseSerializationService ss, MemoryAllocator malloc) {
        this.ss = ss;
        this.queue = new LongConcurrentLinkedQueue(malloc, 0L);
    }

    @Override
    public boolean offer(E e) {
        NativeMemoryData binary = (NativeMemoryData)this.ss.toData(e, DataType.NATIVE);
        if (this.queue.offer(binary.address())) {
            return true;
        }
        this.ss.disposeData(binary);
        return false;
    }

    @Override
    public E poll() {
        return this.first(true);
    }

    @Override
    public E peek() {
        return this.first(false);
    }

    private E first(boolean remove) {
        long address = this.queue.poll();
        return this.toItem(address, remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E toItem(long address, boolean dispose) {
        if (address != this.queue.nullItem()) {
            NativeMemoryData data = new NativeMemoryData().reset(address);
            try {
                Object t = this.ss.toObject(data);
                return (E)t;
            }
            finally {
                if (dispose) {
                    this.ss.disposeData(data);
                }
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public void destroy() {
        this.queue.dispose();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }
}

