/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.HDBTreeLeafNodeAccessor;
import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.NodeSplitStrategy;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.bplustree.TStoreBTreeInnerNodeAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;

class TStoreBTreeLeafNodeAccessor
extends HDBTreeLeafNodeAccessor {
    private final TStoreAllocator tstoreBtreeAllocator;

    TStoreBTreeLeafNodeAccessor(LockManager lockManager, EnterpriseSerializationService ess, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MemoryAllocator keyAllocator, TStoreAllocator btreeAllocator, int nodeSize, NodeSplitStrategy nodeSplitStrategy, EntrySlotPayload entrySlotPayload) {
        super(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, nodeSplitStrategy, entrySlotPayload);
        this.tstoreBtreeAllocator = btreeAllocator;
    }

    @Override
    int getKeyPartition(Data key) {
        return this.tstoreBtreeAllocator.getKeyPartition(key);
    }

    @Override
    void allocateLogical(long stableAddress, LockingContext lockingContext) {
        this.tstoreBtreeAllocator.allocateLogical(stableAddress, lockingContext);
    }

    @Override
    boolean isAllocated(long stableAddress) {
        return this.tstoreBtreeAllocator.isAllocated(stableAddress);
    }

    @Override
    long translateToLogical(long stableAddress, LockingContext lockingContext) {
        return this.tstoreBtreeAllocator.translateToLogical(stableAddress, lockingContext);
    }

    @Override
    protected long translateToPhysical(long stableAddress, LockingContext lockingContext) {
        return this.tstoreBtreeAllocator.translateToPhysical(stableAddress, lockingContext);
    }

    @Override
    boolean requiresUnlockBeforeNodeDisposal() {
        return false;
    }

    @Override
    long tryLockRecord(int partition, long keyHash) {
        return this.tstoreBtreeAllocator.tryLockRecord(partition, keyHash);
    }

    @Override
    void yield(int partition) {
        this.tstoreBtreeAllocator.yield(partition);
    }

    @Override
    void waitUntilRecordUnlocked(int partition, long keyHash, long cookie) {
        this.tstoreBtreeAllocator.waitUntilRecordUnlocked(partition, keyHash, cookie);
    }

    @Override
    void unlockRecord(int partition, long keyHash, long cookie) {
        this.tstoreBtreeAllocator.unlockRecord(partition, keyHash, cookie);
    }

    @Override
    protected long getLockStateAddr(long nodeAddr) {
        return this.tstoreBtreeAllocator.getLockAddress(nodeAddr);
    }

    @Override
    void pinAndReplaceLastUnpinned(long stableAddress, LockingContext lockingContext) {
        this.tstoreBtreeAllocator.pinAndReplaceLastUnpinned(stableAddress, lockingContext);
    }

    @Override
    void unpinIfNotLastUnpinned(long stableAddress, LockingContext lockingContext) {
        this.tstoreBtreeAllocator.unpinIfNotLastUnpinned(stableAddress, lockingContext);
    }

    @Override
    void unpin(LockingContext lockingContext, long stableAddress) {
        this.tstoreBtreeAllocator.unpin(stableAddress, lockingContext);
    }

    @Override
    void ensureReadable(long stableAddress, LockingContext lockingContext) {
        this.tstoreBtreeAllocator.ensureReadable(stableAddress, lockingContext);
    }

    @Override
    void ensureWritable(long stableAddress, LockingContext lockingContext) {
        this.tstoreBtreeAllocator.ensureWritable(stableAddress, lockingContext);
    }

    @Override
    void upgradeToWritable(long stableAddress, LockingContext lockingContext) {
        this.tstoreBtreeAllocator.upgradeToWritable(stableAddress, lockingContext);
    }

    @Override
    Data getValue(long nodeAddr, int slot, int partition, Data entryKey) {
        return this.tstoreBtreeAllocator.getRecordValue(partition, entryKey);
    }

    @Override
    long nodeFromLock(long lockAddr) {
        return this.tstoreBtreeAllocator.nodeFromAddress(lockAddr - 8L);
    }

    @Override
    void beforeOperation() {
        TStoreBTreeInnerNodeAccessor.beforeOperation0(this.tstoreBtreeAllocator);
    }

    @Override
    void afterOperation(LockingContext lockingContext) {
        TStoreBTreeInnerNodeAccessor.afterOperation0(this.tstoreBtreeAllocator, lockingContext);
    }

    @Override
    void beforePartitionOperation(int partitionId, LockingContext lockingContext) {
        TStoreBTreeInnerNodeAccessor.beforePartitionOperation0(this.tstoreBtreeAllocator, partitionId, lockingContext);
    }

    @Override
    void beforeLock() {
        this.tstoreBtreeAllocator.pauseEpoch();
    }

    @Override
    void afterLock() {
        this.tstoreBtreeAllocator.resumeEpoch();
    }
}

