/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.Logger;
import com.hazelcast.version.MemberVersion;

public class BuildInfo {
    public static final int UNKNOWN_HAZELCAST_VERSION = -1;
    private static final int MAJOR_VERSION_MULTIPLIER = 10000;
    private static final int MINOR_VERSION_MULTIPLIER = 100;
    private static final int PATCH_TOKEN_INDEX = 3;
    private final String version;
    private final String build;
    private final String revision;
    private final int buildNumber;
    private final boolean enterprise;
    private final byte serializationVersion;
    private final BuildInfo upstreamBuildInfo;
    private final String commitId;
    private final MemberVersion lastLtsVersion;
    private final MemberVersion previousVersion;

    public BuildInfo(String version, String build, String revision, int buildNumber, boolean enterprise, byte serializationVersion, String commitId) {
        this(version, build, revision, buildNumber, enterprise, serializationVersion, commitId, null, null, null);
    }

    public BuildInfo(String version, String build, String revision, int buildNumber, boolean enterprise, byte serializationVersion, String commitId, BuildInfo upstreamBuildInfo, MemberVersion lastLtsVersion, MemberVersion previousVersion) {
        this.version = version;
        this.build = build;
        this.revision = revision;
        this.buildNumber = buildNumber;
        this.enterprise = enterprise;
        this.serializationVersion = serializationVersion;
        this.commitId = commitId;
        this.upstreamBuildInfo = upstreamBuildInfo;
        this.lastLtsVersion = lastLtsVersion;
        this.previousVersion = previousVersion;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getVersion() {
        return this.version;
    }

    public MemberVersion getCodebaseVersion() {
        return MemberVersion.of(this.version);
    }

    public String getBuild() {
        return this.build;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isEnterprise() {
        return this.enterprise;
    }

    public byte getSerializationVersion() {
        return this.serializationVersion;
    }

    public BuildInfo getUpstreamBuildInfo() {
        return this.upstreamBuildInfo;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public MemberVersion getLastLtsVersion() {
        return this.lastLtsVersion;
    }

    public MemberVersion getPreviousVersion() {
        return this.previousVersion;
    }

    public String toString() {
        return "BuildInfo{version='" + this.version + "', build='" + this.build + "', buildNumber=" + this.buildNumber + ", revision=" + this.revision + ", enterprise=" + this.enterprise + ", serializationVersion=" + this.serializationVersion + (String)(this.upstreamBuildInfo == null ? "" : ", upstream=" + String.valueOf(this.upstreamBuildInfo)) + ", lastLtsVersion=" + String.valueOf(this.lastLtsVersion) + ", previousVersion=" + String.valueOf(this.previousVersion) + "}";
    }

    public static int calculateVersion(String version) {
        if (null == version) {
            return -1;
        }
        String[] versionTokens = StringUtil.tokenizeVersionString(version);
        if (versionTokens != null) {
            try {
                String patchVersionString;
                int calculatedVersion = 10000 * Integer.parseInt(versionTokens[0]) + 100 * Integer.parseInt(versionTokens[1]);
                int groupCount = versionTokens.length;
                if (groupCount >= 3 && null != (patchVersionString = versionTokens[3]) && !patchVersionString.startsWith("-")) {
                    calculatedVersion += Integer.parseInt(patchVersionString);
                }
                return calculatedVersion;
            }
            catch (Exception e) {
                Logger.getLogger(BuildInfo.class).warning("Failed to calculate version using version string " + version, e);
            }
        }
        return -1;
    }
}

