/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication.compact;

import com.hazelcast.enterprise.wan.impl.replication.WanEventBatch;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.schema.MemberSchemaService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SchemaReplicationTracker {
    private final Set<Long> replicatedSchemas = ConcurrentHashMap.newKeySet();

    public void onReplicatedSchemaAcknowledgment(List<Long> replicatedSchemaIds) {
        this.replicatedSchemas.addAll(replicatedSchemaIds);
    }

    public void addNotYetReplicatedSchemasToEvent(WanEventBatch eventBatch, MemberSchemaService schemaService) {
        ArrayList<Schema> schemas = null;
        for (Schema schema : schemaService.getAllSchemas()) {
            if (this.replicatedSchemas.contains(schema.getSchemaId())) continue;
            if (schemas == null) {
                schemas = new ArrayList<Schema>();
            }
            schemas.add(schema);
        }
        if (schemas != null) {
            eventBatch.setCompactSchemas(schemas);
        }
    }
}

