/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.cluster.Address;
import com.hazelcast.enterprise.wan.impl.replication.WanBatchPublisher;
import com.hazelcast.enterprise.wan.impl.replication.WanBatchSender;
import com.hazelcast.enterprise.wan.impl.replication.WanEventBatch;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.diagnostics.StoreLatencyPlugin;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class LatencyTrackingWanBatchSender
implements WanBatchSender {
    static final String KEY = "WanBatchSenderLatency";
    private final WanBatchSender delegate;
    private final StoreLatencyPlugin storeLatencyPlugin;
    private final ConcurrentHashMap<Address, StoreLatencyPlugin.LatencyProbe> latencyProbes;
    private final String wanPublisherId;
    private final Executor responseExecutor;
    private final ConstructorFunction<Address, StoreLatencyPlugin.LatencyProbe> createLatencyProbe = new ConstructorFunction<Address, StoreLatencyPlugin.LatencyProbe>(){

        @Override
        public StoreLatencyPlugin.LatencyProbe createNew(Address address) {
            return LatencyTrackingWanBatchSender.this.storeLatencyPlugin.newProbe(LatencyTrackingWanBatchSender.KEY, LatencyTrackingWanBatchSender.this.wanPublisherId, address.toString());
        }
    };

    public LatencyTrackingWanBatchSender(WanBatchSender delegate, StoreLatencyPlugin plugin, String wanPublisherId, Executor responseExecutor) {
        this.delegate = delegate;
        this.storeLatencyPlugin = plugin;
        this.latencyProbes = new ConcurrentHashMap();
        this.wanPublisherId = wanPublisherId;
        this.responseExecutor = responseExecutor;
    }

    @Override
    public void init(Node node, WanBatchPublisher publisher) {
        throw new UnsupportedOperationException("Not supported as a standalone sender, use constructor for initialisation");
    }

    @Override
    public InternalCompletableFuture<Boolean> send(WanEventBatch batchReplicationEvent, Address target) {
        long startNanos = System.nanoTime();
        InternalCompletableFuture<Boolean> result = this.delegate.send(batchReplicationEvent, target);
        result.whenCompleteAsync((response, t) -> this.recordLatency(target, startNanos), this.responseExecutor);
        return result;
    }

    private void recordLatency(Address target, long startNanos) {
        StoreLatencyPlugin.LatencyProbe probe = ConcurrencyUtil.getOrPutIfAbsent(this.latencyProbes, target, this.createLatencyProbe);
        probe.recordValue(System.nanoTime() - startNanos);
    }
}

