/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.enterprise.wan.impl.operation.MerkleTreeNodeValueComparison;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.internal.cluster.impl.operations.WanOperation;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.map.impl.operation.MerkleTreeNodeCompareOperationFactory;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public class WanMerkleTreeNodeCompareOperation
extends Operation
implements WanOperation,
IdentifiedDataSerializable,
AllowedDuringPassiveState {
    private String mapName;
    private MerkleTreeNodeValueComparison remoteLevels;

    public WanMerkleTreeNodeCompareOperation() {
    }

    public WanMerkleTreeNodeCompareOperation(String mapName, MerkleTreeNodeValueComparison remoteLevels) {
        this.mapName = mapName;
        this.remoteLevels = remoteLevels;
    }

    @Override
    public CallStatus call() {
        return new OffloadedMerkleTreeComparison();
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.mapName);
        out.writeObject(this.remoteLevels);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.mapName = in.readString();
        this.remoteLevels = (MerkleTreeNodeValueComparison)in.readObject();
    }

    private final class OffloadedMerkleTreeComparison
    extends Offload
    implements BiConsumer<Map<Integer, int[]>, Throwable> {
        private OffloadedMerkleTreeComparison() {
            super(WanMerkleTreeNodeCompareOperation.this);
        }

        @Override
        public void start() {
            try {
                MerkleTreeNodeCompareOperationFactory factory = new MerkleTreeNodeCompareOperationFactory(WanMerkleTreeNodeCompareOperation.this.mapName, WanMerkleTreeNodeCompareOperation.this.remoteLevels);
                OperationService os = WanMerkleTreeNodeCompareOperation.this.getNodeEngine().getOperationService();
                ManagedExecutorService wanExecutor = this.nodeEngine.getExecutionService().getExecutor("hz:wan");
                os.invokeOnPartitionsAsync("hz:impl:mapService", (OperationFactory)factory, WanMerkleTreeNodeCompareOperation.this.remoteLevels.getPartitionIds()).whenCompleteAsync((BiConsumer)this, (Executor)wanExecutor);
            }
            catch (Exception e) {
                WanMerkleTreeNodeCompareOperation.this.sendResponse(e);
            }
        }

        @Override
        public void accept(Map<Integer, int[]> response, Throwable throwable) {
            if (throwable == null) {
                MerkleTreeNodeValueComparison comparison = new MerkleTreeNodeValueComparison(response);
                WanMerkleTreeNodeCompareOperation.this.sendResponse(comparison);
            } else {
                WanMerkleTreeNodeCompareOperation.this.sendResponse(throwable);
            }
        }
    }
}

