/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.config.AbstractWanPublisherConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.wan.WanPublisher;
import com.hazelcast.wan.impl.DelegatingWanScheme;
import com.hazelcast.wan.impl.WanReplicationServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;

class WanSchemeContainer {
    private final ConcurrentHashMap<String, DelegatingWanScheme> wanReplications = new ConcurrentHashMap(2);
    private final Object publisherInitializationMutex = new Object();
    private final Node node;
    private final ConstructorFunction<String, DelegatingWanScheme> publisherDelegateConstructor = new ConstructorFunction<String, DelegatingWanScheme>(){

        @Override
        public DelegatingWanScheme createNew(String name) {
            WanReplicationConfig replicationConfig = WanSchemeContainer.this.node.getConfig().getWanReplicationConfig(name);
            return new DelegatingWanScheme(name, WanSchemeContainer.this.createPublishers(replicationConfig));
        }
    };

    WanSchemeContainer(Node node) {
        this.node = node;
    }

    private ConcurrentMap<String, WanPublisher> createPublishers(WanReplicationConfig wanReplicationConfig) {
        List<WanBatchPublisherConfig> batchPublisherConfigs = wanReplicationConfig.getBatchPublisherConfigs();
        List<WanCustomPublisherConfig> customPublisherConfigs = wanReplicationConfig.getCustomPublisherConfigs();
        int publisherCount = batchPublisherConfigs.size() + customPublisherConfigs.size();
        if (publisherCount == 0) {
            return MapUtil.createConcurrentHashMap(1);
        }
        ConcurrentMap<String, WanPublisher> publishers = MapUtil.createConcurrentHashMap(publisherCount);
        Map publisherConfigs = MapUtil.createHashMap(publisherCount);
        Stream.of(batchPublisherConfigs, customPublisherConfigs).flatMap(Collection::stream).forEach(publisherConfig -> {
            String publisherId = WanReplicationServiceImpl.getWanPublisherId(publisherConfig);
            if (publishers.containsKey(publisherId)) {
                throw new InvalidConfigurationException("Detected duplicate publisher ID '" + publisherId + "' for a single WAN replication config");
            }
            WanPublisher publisher = this.createPublisher((AbstractWanPublisherConfig)publisherConfig);
            publishers.put(publisherId, publisher);
            publisherConfigs.put(publisherId, publisherConfig);
        });
        for (Map.Entry publisherEntry : publishers.entrySet()) {
            String publisherId = (String)publisherEntry.getKey();
            WanPublisher publisher = (WanPublisher)publisherEntry.getValue();
            this.node.getSerializationService().getManagedContext().initialize(publisher);
            publisher.init(wanReplicationConfig, (AbstractWanPublisherConfig)publisherConfigs.get(publisherId));
        }
        return publishers;
    }

    private WanPublisher createPublisher(AbstractWanPublisherConfig publisherConfig) {
        WanPublisher publisher = ClassLoaderUtil.getOrCreate(publisherConfig.getImplementation(), this.node.getConfigClassLoader(), publisherConfig.getClassName());
        if (publisher == null) {
            throw new InvalidConfigurationException("Either 'implementation' or 'className' attribute need to be set in the WAN publisher configuration for publisher " + String.valueOf(publisherConfig));
        }
        return publisher;
    }

    public DelegatingWanScheme getWanReplicationPublishers(String wanReplicationScheme) {
        return ConcurrencyUtil.getOrPutSynchronized(this.wanReplications, wanReplicationScheme, this.publisherInitializationMutex, this.publisherDelegateConstructor);
    }

    ConcurrentHashMap<String, DelegatingWanScheme> getWanReplications() {
        return this.wanReplications;
    }

    public void shutdown() {
        for (DelegatingWanScheme publisherDelegate : this.wanReplications.values()) {
            for (WanPublisher publisher : publisherDelegate.getPublishers()) {
                if (publisher == null) continue;
                publisher.shutdown();
            }
        }
        this.wanReplications.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensurePublishersInitialized(String wanReplicationName) {
        DelegatingWanScheme existingPublishers = this.getWanReplicationPublishers(wanReplicationName);
        WanReplicationConfig wanReplicationConfig = this.node.getConfig().getWanReplicationConfig(wanReplicationName);
        Map newConfigMap = MapUtil.createHashMap(1);
        Stream.of(wanReplicationConfig.getBatchPublisherConfigs(), wanReplicationConfig.getCustomPublisherConfigs()).flatMap(Collection::stream).forEach(publisherConfig -> {
            String publisherId = WanReplicationServiceImpl.getWanPublisherId(publisherConfig);
            if (existingPublishers.getPublisher(publisherId) == null && newConfigMap.put(publisherId, publisherConfig) != null) {
                throw new InvalidConfigurationException("Detected duplicate publisher ID '" + publisherId + "' for a single WAN replication config");
            }
        });
        if (newConfigMap.isEmpty()) {
            return;
        }
        Object object = this.publisherInitializationMutex;
        synchronized (object) {
            String publisherId;
            Map<String, WanPublisher> newPublishers = MapUtil.createHashMap(newConfigMap.size());
            for (Map.Entry newPublisherEntry : newConfigMap.entrySet()) {
                publisherId = (String)newPublisherEntry.getKey();
                AbstractWanPublisherConfig publisherConfig2 = (AbstractWanPublisherConfig)newPublisherEntry.getValue();
                if (existingPublishers.getPublisher(publisherId) != null) continue;
                newPublishers.put(publisherId, this.createPublisher(publisherConfig2));
            }
            for (Map.Entry newPublisherEntry : newPublishers.entrySet()) {
                publisherId = (String)newPublisherEntry.getKey();
                WanPublisher publisher = (WanPublisher)newPublisherEntry.getValue();
                this.node.getSerializationService().getManagedContext().initialize(publisher);
                publisher.init(wanReplicationConfig, (AbstractWanPublisherConfig)newConfigMap.get(publisherId));
                existingPublishers.addPublisher(publisherId, publisher);
            }
        }
    }
}

