/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.CallerAware;
import com.hazelcast.cp.internal.IndeterminateOperationStateAware;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.operation.RaftReplicateOp;
import com.hazelcast.cp.internal.raft.impl.RaftNode;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.io.IOException;

public class DefaultRaftReplicateOp
extends RaftReplicateOp
implements IndeterminateOperationStateAware {
    private RaftOp op;

    public DefaultRaftReplicateOp() {
    }

    public DefaultRaftReplicateOp(CPGroupId groupId, RaftOp op) {
        super(groupId);
        this.op = op;
    }

    @Override
    protected InternalCompletableFuture replicate(RaftNode raftNode) {
        RaftOp raftOp = this.op;
        if (raftOp instanceof CallerAware) {
            CallerAware aware = (CallerAware)((Object)raftOp);
            aware.setCaller(this.getCallerAddress(), this.getCallId());
        }
        return raftNode.replicate(this.op);
    }

    @Override
    public boolean isRetryableOnIndeterminateOperationState() {
        RaftOp raftOp = this.op;
        if (raftOp instanceof IndeterminateOperationStateAware) {
            IndeterminateOperationStateAware aware = (IndeterminateOperationStateAware)((Object)raftOp);
            return aware.isRetryableOnIndeterminateOperationState();
        }
        return false;
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.op);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.op = (RaftOp)in.readObject();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", op=").append(this.op);
    }
}

