/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.cpmap;

import com.hazelcast.cp.internal.datastructures.cpmap.CPMapDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.cpmap.store.CPMapStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CPMapRegistrySnapshot
implements IdentifiedDataSerializable {
    private Map<String, CPMapStore> maps = new HashMap<String, CPMapStore>();
    private Set<String> destroyedNames = new HashSet<String>();

    public CPMapRegistrySnapshot() {
    }

    public CPMapRegistrySnapshot(Map<String, CPMapStore> maps, Set<String> destroyedNames) {
        this.maps.putAll(maps);
        this.destroyedNames.addAll(destroyedNames);
    }

    public boolean isEmpty() {
        return this.maps.isEmpty() && this.destroyedNames.isEmpty();
    }

    public Map<String, CPMapStore> getMaps() {
        return this.maps;
    }

    public Set<String> getDestroyedNames() {
        return this.destroyedNames;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.maps.size());
        for (Map.Entry<String, CPMapStore> map : this.maps.entrySet()) {
            out.writeString(map.getKey());
            out.writeObject(map.getValue());
        }
        out.writeInt(this.destroyedNames.size());
        for (String name : this.destroyedNames) {
            out.writeString(name);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int mapsCount = in.readInt();
        this.maps = new HashMap<String, CPMapStore>(mapsCount);
        for (int i = 0; i < mapsCount; ++i) {
            String mapName = in.readString();
            CPMapStore cpMapStore = (CPMapStore)in.readObject();
            this.maps.put(mapName, cpMapStore);
        }
        int count = in.readInt();
        this.destroyedNames = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            String name = in.readString();
            this.destroyedNames.add(name);
        }
    }

    @Override
    public int getFactoryId() {
        return CPMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    public String toString() {
        return "CPMapRegistrySnapshot{maps=" + String.valueOf(this.maps) + ", destroyedNames=" + String.valueOf(this.destroyedNames) + "}";
    }
}

