/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.security.permission.AllPermissions;
import com.hazelcast.security.permission.AtomicLongPermission;
import com.hazelcast.security.permission.AtomicReferencePermission;
import com.hazelcast.security.permission.CPMapPermission;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.security.permission.CardinalityEstimatorPermission;
import com.hazelcast.security.permission.ConfigPermission;
import com.hazelcast.security.permission.ConnectorPermission;
import com.hazelcast.security.permission.CountDownLatchPermission;
import com.hazelcast.security.permission.DurableExecutorServicePermission;
import com.hazelcast.security.permission.ExecutorServicePermission;
import com.hazelcast.security.permission.FlakeIdGeneratorPermission;
import com.hazelcast.security.permission.JobPermission;
import com.hazelcast.security.permission.ListPermission;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.security.permission.ManagementPermission;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.security.permission.PNCounterPermission;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.security.permission.ReliableTopicPermission;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.security.permission.RingBufferPermission;
import com.hazelcast.security.permission.ScheduledExecutorPermission;
import com.hazelcast.security.permission.SemaphorePermission;
import com.hazelcast.security.permission.SetPermission;
import com.hazelcast.security.permission.SqlPermission;
import com.hazelcast.security.permission.TopicPermission;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.security.permission.UserCodeDeploymentPermission;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import com.hazelcast.security.permission.VectorCollectionPermission;
import java.io.IOException;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class PermissionConfig
implements IdentifiedDataSerializable,
Versioned {
    private PermissionType type;
    private String name;
    private String principal;
    private Set<String> endpoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<String> actions = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean deny;

    public PermissionConfig() {
    }

    public PermissionConfig(PermissionType type, String name, String principal) {
        this.type = type;
        this.name = name;
        this.principal = principal;
    }

    public PermissionConfig(PermissionConfig permissionConfig) {
        this.type = permissionConfig.type;
        this.name = permissionConfig.getName();
        this.principal = permissionConfig.getPrincipal();
        for (String endpoint : permissionConfig.getEndpoints()) {
            this.endpoints.add(endpoint);
        }
        for (String action : permissionConfig.getActions()) {
            this.actions.add(action);
        }
    }

    public PermissionConfig addEndpoint(String endpoint) {
        this.endpoints.add(endpoint);
        return this;
    }

    public PermissionConfig addAction(String action) {
        this.actions.add(action);
        return this;
    }

    public PermissionType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Set<String> getEndpoints() {
        return this.endpoints;
    }

    public Set<String> getActions() {
        return this.actions;
    }

    public PermissionConfig setType(PermissionType type) {
        this.type = type;
        return this;
    }

    public PermissionConfig setName(String name) {
        this.name = name;
        return this;
    }

    public PermissionConfig setPrincipal(String principal) {
        this.principal = principal;
        return this;
    }

    public PermissionConfig setActions(Set<String> actions) {
        this.actions = actions;
        return this;
    }

    public PermissionConfig setEndpoints(Set<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 61;
    }

    public boolean isDeny() {
        return this.deny;
    }

    public PermissionConfig setDeny(boolean deny) {
        this.deny = deny;
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.type.getNodeName());
        out.writeString(this.name);
        if (StringUtil.isNullOrEmptyAfterTrim(this.principal)) {
            out.writeString("*");
        } else {
            out.writeString(this.principal);
        }
        out.writeInt(this.endpoints.size());
        for (String endpoint : this.endpoints) {
            out.writeString(endpoint);
        }
        out.writeInt(this.actions.size());
        for (String action : this.actions) {
            out.writeString(action);
        }
        if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            out.writeBoolean(this.deny);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int actionsSize;
        this.type = PermissionType.getType(in.readString());
        this.name = in.readString();
        this.principal = in.readString();
        int endpointsSize = in.readInt();
        if (endpointsSize != 0) {
            Set<String> endpoints = SetUtil.createHashSet(endpointsSize);
            for (int i = 0; i < endpointsSize; ++i) {
                endpoints.add(in.readString());
            }
            this.endpoints = endpoints;
        }
        if ((actionsSize = in.readInt()) != 0) {
            Set<String> actions = SetUtil.createHashSet(actionsSize);
            for (int i = 0; i < actionsSize; ++i) {
                actions.add(in.readString());
            }
            this.actions = actions;
        }
        if (in.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            this.deny = in.readBoolean();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PermissionConfig)) {
            return false;
        }
        PermissionConfig that = (PermissionConfig)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.principal != null ? !this.principal.equals(that.principal) : that.principal != null) {
            return false;
        }
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.deny != that.deny) {
            return false;
        }
        return this.actions != null ? this.actions.equals(that.actions) : that.actions == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
        result = 31 * result + (this.endpoints != null ? this.endpoints.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        result = 31 * result + Boolean.hashCode(this.deny);
        return result;
    }

    public String toString() {
        return "PermissionConfig{type=" + String.valueOf((Object)this.type) + ", name='" + this.name + "', clientUuid='" + this.principal + "', endpoints=" + String.valueOf(this.endpoints) + ", actions=" + String.valueOf(this.actions) + ", deny=" + this.deny + "}";
    }

    public static enum PermissionType {
        ALL("all-permissions", AllPermissions.class),
        MAP("map-permission", MapPermission.class),
        QUEUE("queue-permission", QueuePermission.class),
        TOPIC("topic-permission", TopicPermission.class),
        MULTIMAP("multimap-permission", MultiMapPermission.class),
        LIST("list-permission", ListPermission.class),
        SET("set-permission", SetPermission.class),
        FLAKE_ID_GENERATOR("flake-id-generator-permission", FlakeIdGeneratorPermission.class),
        LOCK("lock-permission", LockPermission.class),
        ATOMIC_LONG("atomic-long-permission", AtomicLongPermission.class),
        ATOMIC_REFERENCE("atomic-reference-permission", AtomicReferencePermission.class),
        COUNTDOWN_LATCH("countdown-latch-permission", CountDownLatchPermission.class),
        SEMAPHORE("semaphore-permission", SemaphorePermission.class),
        EXECUTOR_SERVICE("executor-service-permission", ExecutorServicePermission.class),
        TRANSACTION("transaction-permission", TransactionPermission.class),
        DURABLE_EXECUTOR_SERVICE("durable-executor-service-permission", DurableExecutorServicePermission.class),
        CARDINALITY_ESTIMATOR("cardinality-estimator-permission", CardinalityEstimatorPermission.class),
        SCHEDULED_EXECUTOR("scheduled-executor-permission", ScheduledExecutorPermission.class),
        CACHE("cache-permission", CachePermission.class),
        USER_CODE_DEPLOYMENT("user-code-deployment-permission", UserCodeDeploymentPermission.class),
        CONFIG("config-permission", ConfigPermission.class),
        PN_COUNTER("pn-counter-permission", PNCounterPermission.class),
        RING_BUFFER("ring-buffer-permission", RingBufferPermission.class),
        RELIABLE_TOPIC("reliable-topic-permission", ReliableTopicPermission.class),
        REPLICATEDMAP("replicatedmap-permission", ReplicatedMapPermission.class),
        MANAGEMENT("management-permission", ManagementPermission.class),
        JOB("job-permission", JobPermission.class),
        CONNECTOR("connector-permission", ConnectorPermission.class),
        SQL("sql-permission", SqlPermission.class),
        CPMAP("cpmap-permission", CPMapPermission.class),
        USER_CODE_NAMESPACE("user-code-namespace-permission", UserCodeNamespacePermission.class),
        VECTOR_COLLECTION("vector-collection-permission", VectorCollectionPermission.class);

        private final String nodeName;
        private final String className;

        private PermissionType(String nodeName, Class<? extends Permission> permClass) {
            this.nodeName = nodeName;
            this.className = permClass.getName();
        }

        public static PermissionType getType(String nodeName) {
            return PermissionType.findPermissionTypeByFilter(v -> v.nodeName.equals(nodeName));
        }

        public static PermissionType getTypeByPermissionClassName(String permissionClassname) {
            return PermissionType.findPermissionTypeByFilter(v -> v.className.equals(permissionClassname));
        }

        public String getNodeName() {
            return this.nodeName;
        }

        private static PermissionType findPermissionTypeByFilter(Predicate<PermissionType> filterPredicate) {
            return Arrays.stream(PermissionType.values()).filter(filterPredicate).findFirst().orElse(null);
        }
    }
}

