/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractSymmetricEncryptionConfig;
import com.hazelcast.config.SecureStoreConfig;
import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;

public class EncryptionAtRestConfig
extends AbstractSymmetricEncryptionConfig<EncryptionAtRestConfig> {
    private SecureStoreConfig secureStoreConfig = new NoSecureStoreConfig();
    private int keySize;

    public int getKeySize() {
        return this.keySize;
    }

    public EncryptionAtRestConfig setKeySize(int keySize) {
        this.keySize = keySize;
        return this;
    }

    public SecureStoreConfig getSecureStoreConfig() {
        return this.secureStoreConfig;
    }

    public EncryptionAtRestConfig setSecureStoreConfig(SecureStoreConfig secureStoreConfig) {
        Preconditions.checkNotNull(secureStoreConfig, "Secure Store config cannot be null!");
        this.secureStoreConfig = secureStoreConfig;
        return this;
    }

    public String toString() {
        return "EncryptionAtRestConfig{enabled=" + this.enabled + ", algorithm='" + this.algorithm + "', salt='***', keySize=" + this.keySize + ", secureStoreConfig=" + String.valueOf(this.secureStoreConfig) + "}";
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionAtRestConfig)) {
            return false;
        }
        EncryptionAtRestConfig other = (EncryptionAtRestConfig)o;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (!Objects.equals(this.algorithm, other.algorithm)) {
            return false;
        }
        if (!Objects.equals(this.salt, other.salt)) {
            return false;
        }
        if (this.keySize != other.keySize) {
            return false;
        }
        return Objects.equals(this.secureStoreConfig, other.secureStoreConfig);
    }

    public final int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + (this.salt == null ? 0 : this.salt.hashCode());
        result = 31 * result + this.keySize;
        result = 31 * result + (this.secureStoreConfig == null ? 0 : this.secureStoreConfig.hashCode());
        return result;
    }

    private static final class NoSecureStoreConfig
    extends SecureStoreConfig {
        private NoSecureStoreConfig() {
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof NoSecureStoreConfig;
        }
    }
}

