/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.vector;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionClearCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionDeleteCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionGetCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionOptimizeCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionPutAllCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionPutCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionPutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionSearchNearVectorCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionSetCodec;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionSizeCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.VectorCollection;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.DataVectorDocument;
import com.hazelcast.vector.impl.SearchResultsImpl;
import com.hazelcast.vector.impl.VectorUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public class ClientVectorCollectionProxyImpl<K, V>
extends ClientProxy
implements VectorCollection<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected static final String NULL_MAP_IS_NOT_ALLOWED = "Null documents map is not allowed!";

    public ClientVectorCollectionProxyImpl(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    public CompletionStage<VectorDocument<V>> getAsync(@Nonnull K key) {
        return this.invokeSingleKeyOperationAsync(key, VectorCollectionGetCodec::encodeRequest, r -> this.toObject(VectorCollectionGetCodec.decodeResponse(r)));
    }

    @Override
    public CompletionStage<VectorDocument<V>> putAsync(@Nonnull K key, @Nonnull VectorDocument<V> value) {
        return this.invokeSingleKeyValueOperationAsync(key, value, VectorCollectionPutCodec::encodeRequest, r -> this.toObject(VectorCollectionPutCodec.decodeResponse(r)));
    }

    @Override
    public CompletionStage<Void> setAsync(@Nonnull K key, @Nonnull VectorDocument<V> value) {
        return this.invokeSingleKeyValueOperationAsync(key, value, VectorCollectionSetCodec::encodeRequest, r -> null);
    }

    @Override
    public CompletionStage<VectorDocument<V>> putIfAbsentAsync(@Nonnull K key, @Nonnull VectorDocument<V> value) {
        return this.invokeSingleKeyValueOperationAsync(key, value, VectorCollectionPutIfAbsentCodec::encodeRequest, r -> this.toObject(VectorCollectionPutIfAbsentCodec.decodeResponse(r)));
    }

    @Override
    public CompletionStage<Void> putAllAsync(Map<? extends K, VectorDocument<V>> documents) {
        Objects.requireNonNull(documents, NULL_MAP_IS_NOT_ALLOWED);
        InternalCompletableFuture<Void> future = new InternalCompletableFuture<Void>();
        this.putAllInternalAsync(documents, future);
        return future;
    }

    @Override
    public CompletionStage<VectorDocument<V>> removeAsync(K key) {
        return this.invokeSingleKeyOperationAsync(key, VectorCollectionRemoveCodec::encodeRequest, r -> this.toObject(VectorCollectionRemoveCodec.decodeResponse(r)));
    }

    @Override
    public CompletionStage<Void> deleteAsync(K key) {
        return this.invokeSingleKeyOperationAsync(key, VectorCollectionDeleteCodec::encodeRequest, r -> null);
    }

    @Override
    public CompletionStage<Void> optimizeAsync(String indexName) {
        ClientMessage request = VectorCollectionOptimizeCodec.encodeRequest(this.name, indexName);
        ClientInvocationFuture future = this.invokeAsync(request);
        return future.thenAcceptAsync(response -> {}, ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public CompletionStage<Void> clearAsync() {
        ClientMessage request = VectorCollectionClearCodec.encodeRequest(this.name);
        ClientInvocationFuture future = this.invokeAsync(request);
        return future.thenAcceptAsync(response -> {}, ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public long size() {
        ClientMessage request = VectorCollectionSizeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return VectorCollectionSizeCodec.decodeResponse(response);
    }

    @Override
    public CompletionStage<SearchResults<K, V>> searchAsync(VectorValues vectors, SearchOptions searchOptions) {
        Preconditions.checkNotNull(searchOptions);
        try {
            ClientMessage request = VectorCollectionSearchNearVectorCodec.encodeRequest(this.name, vectors, searchOptions);
            ClientInvocationFuture future = this.invokeAsync(request);
            SerializationService ss = this.getSerializationService();
            return new ClientDelegatingFuture(future, ss, VectorCollectionSearchNearVectorCodec::decodeResponse).thenApplyAsync(resultsList -> VectorUtil.deserialize(new SearchResultsImpl<Data, Data>((List)resultsList), this.getSerializationService()), ConcurrencyUtil.CALLER_RUNS);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void putAllInternalAsync(@Nonnull Map<? extends K, ? extends VectorDocument<V>> map, @Nonnull InternalCompletableFuture<Void> future) {
        if (map.isEmpty()) {
            future.complete(null);
            return;
        }
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        HashMap<Integer, List> entryMap = new HashMap<Integer, List>(partitionCount);
        for (Map.Entry<K, VectorDocument<V>> entry : map.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), NULL_KEY_IS_NOT_ALLOWED);
            Preconditions.checkNotNull(entry.getValue(), NULL_VALUE_IS_NOT_ALLOWED);
            Data keyData = this.toData(entry.getKey());
            int partitionId = partitionService.getPartitionId(keyData);
            List partitionEntries = entryMap.computeIfAbsent(partitionId, x -> new ArrayList());
            partitionEntries.add(new AbstractMap.SimpleEntry<Data, DataVectorDocument>(keyData, this.toData(entry.getValue())));
        }
        assert (!entryMap.isEmpty());
        AtomicInteger counter = new AtomicInteger(entryMap.size());
        BiConsumer<ClientMessage, Throwable> callback = (response, t) -> {
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            }
            if (counter.decrementAndGet() == 0 && !future.isDone()) {
                future.complete(null);
            }
        };
        for (Map.Entry entry : entryMap.entrySet()) {
            Integer partitionId = (Integer)entry.getKey();
            List partitionEntries = (List)entry.getValue();
            ClientMessage request = partitionEntries.size() > 1 ? VectorCollectionPutAllCodec.encodeRequest(this.name, partitionEntries) : VectorCollectionSetCodec.encodeRequest(this.name, (Data)((Map.Entry)partitionEntries.get(0)).getKey(), (DataVectorDocument)((Map.Entry)partitionEntries.get(0)).getValue());
            this.invokeOnPartitionAsync(request, partitionId).whenCompleteAsync(callback, ConcurrencyUtil.getDefaultAsyncExecutor());
        }
    }

    private <R> CompletionStage<R> invokeSingleKeyOperationAsync(@Nonnull K key, BiFunction<String, Data, ClientMessage> encode, ClientMessageDecoder<R> decode) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        try {
            Data keyData = this.toData(key);
            ClientMessage request = encode.apply(this.name, keyData);
            ClientInvocationFuture future = this.invokeOnKeyOwnerAsync(request, keyData);
            SerializationService ss = this.getSerializationService();
            return CompletableFuture.completedFuture(null).thenComposeAsync(v -> new ClientDelegatingFuture(future, ss, decode), ConcurrencyUtil.CALLER_RUNS);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private <R> CompletionStage<R> invokeSingleKeyValueOperationAsync(@Nonnull K key, @Nonnull VectorDocument<V> value, TriFunction<String, Data, DataVectorDocument, ClientMessage> encode, ClientMessageDecoder<R> decode) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        try {
            Data keyData = this.toData(key);
            DataVectorDocument valueData = this.toData(value);
            ClientMessage request = encode.apply(this.name, keyData, valueData);
            ClientInvocationFuture future = this.invokeOnKeyOwnerAsync(request, keyData);
            SerializationService ss = this.getSerializationService();
            return CompletableFuture.completedFuture(null).thenComposeAsync(v -> new ClientDelegatingFuture(future, ss, decode), ConcurrencyUtil.CALLER_RUNS);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private DataVectorDocument toData(VectorDocument o) {
        return VectorUtil.serialize(o, this.getSerializationService());
    }

    private <T> VectorDocument<T> toObject(DataVectorDocument o) {
        return VectorUtil.deserialize(o, this.getSerializationService());
    }

    private ClientInvocationFuture invokeOnKeyOwnerAsync(ClientMessage request, Data keyData) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        return this.invokeOnPartitionAsync(request, partitionId);
    }

    private ClientInvocationFuture invokeOnPartitionAsync(ClientMessage request, int partitionId) {
        ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstance)this.getClient(), request, (Object)this.getName(), partitionId);
        return clientInvocation.invoke();
    }
}

